/****************************************************************************/

/*
 *	cktimer.h -- CKcore on board TIMER support defines.
 *
 *  (C) Copyright 2004, Li Chunqiang (chunqiang_li@c-sky.com)
 *  (C) Copyright 2004, Kang Sun (sunk@vlsi.zju.edu.cn)
 *	(C) Copyright 1999-2003, Greg Ungerer (gerg@snapgear.com)
 * 	(C) Copyright 2000, Lineo Inc. (www.lineo.com) 
 */

/****************************************************************************/
#ifndef	cktimer_h
#define	cktimer_h
/****************************************************************************/

#include <linux/config.h>

#if (defined(CONFIG_CK510) || defined(CONFIG_CK510EVB))
/*
 *	Define the Timer Control Register base address.
 */
#define	CKTIMER_BASE	0x10008000
/*
 *	Define the offset(index) in CKTIMER_BASE for the registers
 *  addresses of the timer on CK510EVB board
 */
#define	CKTIMER_TCN1_LDCR		0x00	// Timer1 Load Count register
#define	CKTIMER_TCN1_CVR 		0x01	// Timer1 Current Value register
#define	CKTIMER_TCN1_CR			0x02	// Timer1 Control register
#define	CKTIMER_TCN1_EOI		0x03	// Timer1 Interrupt clear register(Setted when timer's terminal count is reached).
#define	CKTIMER_TCN1_ISR		0x04	// Timer1 Interrupt status.

#define	CKTIMER_TCN2_LDCR		0x05	// Timer2 Load Count register
#define	CKTIMER_TCN2_CVR 		0x06	// Timer2 Current Value register
#define	CKTIMER_TCN2_CR			0x07	// Timer2 Control register
#define	CKTIMER_TCN2_EOI		0x08	// Timer2 Interrupt clear register(Setted when timer's terminal count is reached).
#define	CKTIMER_TCN2_ISR		0x09	// Timer2 Interrupt status.

#define	CKTIMER_SYS_ISR			0x28	// System: The interrupts status of all timers register
#define	CKTIMER_SYS_EOI			0x29	// System: Read the register to clear all active interrupts
#define	CKTIMER_SYS_RISR		0x2a	// System: The Unmasked interrupts status register.

#define	CKTIMER_WDT_CR			0x40	// WDT control register
#define	CKTIMER_WDT_TORR		0x41	// WDT timerout range register
#define	CKTIMER_WDT_CCVR		0x42	// WDT Current counter value
#define	CKTIMER_WDT_CRR			0x43	// WDT counter restart register
#define	CKTIMER_WDT_STAT		0x44	// WDT interrupt status register
#define	CKTIMER_WDT_EOI			0x45	// WDT interrupt clear register

#endif


/*
 *	Bit definitions for the Timer Control Register (Timer CR).
 */
/* for or */
#define CKTIMER_TCR_WAIT	0x00000080
#define CKTIMER_TCR_DOZE	0x00000040
#define CKTIMER_TCR_STOP	0x00000020
#define CKTIMER_TCR_DBG		0x00000010
#define CKTIMER_TCR_RCS		0x00000008		// Timer Reference Clock selection
#define	CKTIMER_TCR_IM		0x00000004		// Timer Interrupt mask
#define	CKTIMER_TCR_MS		0x00000002		// Timer Mode select
#define	CKTIMER_TCR_EN		0x00000001		// Timer Enable select

/*
 *	Bit definitions for the WDT Control Register (Timer CR).
 */
/* for or */
#define CKTIMER_TCR_WAIT	0x00000020
#define CKTIMER_TCR_DOZE	0x00000010
#define CKTIMER_TCR_STOP	0x00000008
#define CKTIMER_TCR_DBG		0x00000004
#define	CKTIMER_TCR_RMOD	0x00000002		// Timer Mode select for system reset
#define	CKTIMER_TCR_EN		0x00000001		// Timer Enable select
/****************************************************************************/
#endif	/* cktimer_h */
