#ifndef __ARCH_CKCORENOMMU_ATOMIC__
#define __ARCH_CKCORENOMMU_ATOMIC__

#include <asm/system.h>	/* save_and_cli() */

/*
 * Atomic operations that C can't guarantee us.  Useful for
 * resource counting etc..
 */


typedef struct _atomic_t
{
    int counter; 
} 
atomic_t;

#define ATOMIC_INIT(i)	{ (i) }

#define atomic_read(v)		((v)->counter)
#define atomic_set(v, i)	(((v)->counter) = i)


static __inline__ void atomic_add(int i, volatile atomic_t *v)
{
        unsigned long flags;

        save_and_cli(flags);
        v->counter += i;
        restore_flags(flags);
}

static __inline__ void atomic_sub(int i, volatile atomic_t *v) 
{
        unsigned long flags;

        save_and_cli(flags);
        v->counter -= i;
        restore_flags(flags);        
}



static __inline__ void atomic_inc(volatile atomic_t *v)
{
        atomic_add(1, v);
}

static __inline__ void atomic_dec(volatile atomic_t *v)
{
        atomic_sub(1, v);
}

static __inline__ int atomic_dec_and_test(volatile atomic_t *v)
{
	unsigned long flags, result;
	
        save_and_cli(flags);
        result = (v->counter == 0);
        restore_flags(flags);
        
        return (result);
}

static __inline__ void  atomic_clear_mask(int mask, atomic_t *v) 
{
        unsigned long flags;

        save_and_cli(flags);
        v->counter &= ~mask;
        restore_flags(flags);
}


static __inline__ void atomic_set_mask(int mask, atomic_t *v) 
{
        unsigned long flags;

        save_and_cli(flags);
        v->counter |= mask;
        restore_flags(flags);
}

/* Atomic operations are already serializing */
#define smp_mb__before_atomic_dec()    barrier()
#define smp_mb__after_atomic_dec() barrier()
#define smp_mb__before_atomic_inc()    barrier()
#define smp_mb__after_atomic_inc() barrier()

extern __inline__ int atomic_add_return(int i, atomic_t * v)
{
	unsigned long temp, flags;

	save_and_cli(flags);
	temp = v->counter;
	temp += i;
	v->counter = temp;
	restore_flags(flags);

	return temp;
}

extern __inline__ int atomic_sub_return(int i, atomic_t * v)
{
	unsigned long temp, flags;

	save_and_cli(flags);
	temp = v->counter;
	temp -= i;
	v->counter = temp;
	restore_flags(flags);

	return temp;
}

#define atomic_dec_return(v) atomic_sub_return(1,(v))
#define atomic_inc_return(v) atomic_add_return(1,(v))

#define atomic_sub_and_test(i,v) (atomic_sub_return((i), (v)) == 0)
#define atomic_dec_and_test(v) (atomic_sub_return(1, (v)) == 0)

#endif /* __ARCH_CKCORENOMMU_ATOMIC __ */
