#ifndef _CKCORENOMMU_CHECKSUM_H
#define _CKCORENOMMU_CHECKSUM_H

/*
 * computes the checksum of a memory block at buff, length len,
 * and adds in "sum" (32-bit)
 *
 * returns a 32-bit number suitable for feeding into itself
 * or csum_tcpudp_magic
 *
 * this function must be called with even lengths, except
 * for the last fragment, which may be odd
 *
 * it's best to have buff aligned on a 32-bit boundary
 */
unsigned int csum_partial(const unsigned char * buff, int len, unsigned int sum);


/*
 * the same as csum_partial, but copies from src while it
 * checksums
 *
 * here even more important to align src and dst on a 32-bit (or even
 * better 64-bit) boundary
 */
unsigned int csum_partial_copy(const char *src, char *dst, int len, int sum);


/*
 * the same as csum_partial_copy, but copies from user space.
 *
 * here even more important to align src and dst on a 32-bit (or even
 * better 64-bit) boundary
 */
unsigned int csum_partial_copy_from_user(const char *src, char *dst,
						int len, int sum, int *csum_err);


#define csum_partial_copy_nocheck(src, dst, len, sum)	\
	csum_partial_copy((src), (dst), (len), (sum))


unsigned short ip_fast_csum(unsigned char *iph, unsigned int ihl);


/*
 * this routine is used for miscellaneous IP-like checksums, mainly
 * in icmp.c
 */
unsigned short ip_compute_csum(const unsigned char * buff, int len);


/*
 *	Fold a partial checksum
 */
static inline unsigned int csum_fold(unsigned int sum)//inline
{
#if 0
	//Modified by Li Chunqiang (chunqiang_li@c-sky.com)

	unsigned int temp = 0;

	temp = (sum & 0xffff);
	temp  += (sum >> 16);
	if (temp < (sum >> 16))	//We must take account of the carry bit.
	{
		sum = temp + 1;
	}
	else
	{
		sum = temp;
	}

	temp = (sum & 0xffff); 
        temp  += (sum >> 16);
        if (temp < (sum >> 16))
        {
                sum = temp + 1;
        }
	else
	{
		sum = temp;
	}
#endif
	return 0;//add by phosor for hw checksum
	

        //modify by zxj 2011-06-01
	sum = (sum & 0xffff) + (sum >> 16);
	sum = (sum & 0xffff) + (sum >> 16);
	
	return ~sum;
}


/*
 * computes the checksum of the TCP/UDP pseudo-header
 * returns a 16-bit checksum, already complemented
 */
static inline unsigned int
csum_tcpudp_nofold(unsigned long saddr, unsigned long daddr, unsigned short len,
		  unsigned short proto, unsigned int sum)
{        
#if 0
        //Modified by Li Chunqiang (chunqiang_li@c-sky.com)
        //sum += (saddr + daddr + len + proto);
    
        sum += saddr;
        if (sum < saddr)    //We must take account of the carry bit.
        {
            sum += 1;
        }
        sum  += daddr;
        if (sum < daddr)
        {
            sum += 1;
        }
        sum += len;
        if (sum < len)
        {
            sum += 1;
        }
        sum += proto;
        if (sum < proto)
        {
            sum = sum + 1;
        }
        return sum;
#else
	return 0;//add by phosor for hw checksum
	
	
        //modify by zxj 2011-06-01
        
        #ifdef __BIG_ENDIAN
            unsigned long len_proto = (proto<<16)+len;
        #else
            unsigned long len_proto = ( ntohs( len ) << 16 ) + proto * 256;   
        #endif
        
        sum += saddr;
        if (sum < saddr)    //We must take account of the carry bit.
        {
            sum += 1;
        }
        sum  += daddr;
        if (sum < daddr)
        {
            sum += 1;
        }
        sum += len_proto;
        if (sum < len_proto )
        {
            sum += 1;
        }

        return sum;
#endif

}

static inline unsigned short int
csum_tcpudp_magic(unsigned long saddr, unsigned long daddr, unsigned short len,
		  unsigned short proto, unsigned int sum)
{
	return 0;//add by phosor for hw checksum

	
	return csum_fold(csum_tcpudp_nofold(saddr,daddr,len,proto,sum));
}


#define _HAVE_ARCH_IPV6_CSUM
static __inline__ unsigned short int
csum_ipv6_magic(struct in6_addr *saddr, struct in6_addr *daddr,
		__u32 len, unsigned short proto, unsigned int sum) 
{
	register unsigned long tmp;
        sum += saddr->in6_u.u6_addr32[0];
        sum += saddr->in6_u.u6_addr32[1];
        sum += saddr->in6_u.u6_addr32[2];
        sum += saddr->in6_u.u6_addr32[3];
        sum += daddr->in6_u.u6_addr32[0];
        sum += daddr->in6_u.u6_addr32[1];
        sum += daddr->in6_u.u6_addr32[2];
        sum += daddr->in6_u.u6_addr32[3];
        sum += (len + proto);
	return csum_fold(sum);
}

#endif /* _CKCORENOMMU_CHECKSUM_H */
