/****************************************************************************/

/*
 *	ckcore.h -- C-Sky CKcore CPU sepecific defines
 *
 *	(C) Copyright 1999-2002, Greg Ungerer (gerg@snapgear.com)
 *	(C) Copyright 2000, Lineo (www.lineo.com)
 *      (C) Copyright 2004, Kang Sun
 */

/****************************************************************************/
#ifndef	ckcore_h
#define	ckcore_h
/****************************************************************************/

#include <linux/config.h>

/*
 *	Define the processor support peripherals base address.
 *	This is generally setup by the boards start up code.
 */
#define	CK_MBAR	        0x00000000
#define	CK_MBAR2	0x80000000
#define	CK_IPSBAR	0x40000000

#if (defined(CONFIG_CK510) || defined(CONFIG_CK520))
#undef CK_MBAR
#define	CK_MBAR	CK_IPSBAR
#endif

/*
 *	Define Board Bus clock frequency.
 */


#if defined(CONFIG_CLOCK_27MHz)
#define CK_BUSCLK        27000000 
#elif defined(CONFIG_CLOCK_54MHz)
#define	CK_BUSCLK	 54000000
#elif defined(CONFIG_CLOCK_81MHz)
#define	CK_BUSCLK	 81000000
#elif defined(CONFIG_CLOCK_88MHz)
#define	CK_BUSCLK	 88300000
#elif defined(CONFIG_CLOCK_108MHz)
#define CK_BUSCLK       108000000
#elif defined(CONFIG_CLOCK_135MHz)
#define CK_BUSCLK       132300000
#elif defined(CONFIG_CLOCK_147MHz)
#define CK_BUSCLK       147000000
#elif defined(CONFIG_CLOCK_216MHz)
#define CK_BUSCLK       216000000
#else
#error "Don't know what your Bus clock frequency is??"
#endif


/*
 *     Define the CPU Clock Multiple
 */
 
//#define CONFIG_CPU_CLOCK_X1


#if defined(CONFIG_CPU_CLOCK_X1)
#define CK_CLK  CK_BUSCLK
#elif defined(CONFIG_CPU_CLOCK_X2)
#define	CK_CLK	CK_BUSCLK*2
#elif defined(CONFIG_CPU_CLOCK_X4)
#define CK_CLK  CK_BUSCLK*4
#elif defined(CONFIG_CPU_CLOCK_X8)
#define CK_CLK  CK_BUSCLK*8
#else
//#error "Don't know what the CPU Clock multiple"
#define CONFIG_CPU_CLOCK_X1
#define CK_CLK  CK_BUSCLK
#endif




/*****************************************************************************/
// add by zxj for make menuconfig  2008-12-31

/*
 *	Board setup info.
 */

//define for cache size
#define CACHE_PACR_1M	0x27
#define CACHE_PACR_2M	0x29
#define CACHE_PACR_4M	0x2B
#define CACHE_PACR_8M	0x2D
#define CACHE_PACR_16M	0x2F
#define CACHE_PACR_32M	0x31
#define CACHE_PACR_64M	0x33
#define CACHE_PACR_256M	0x37

// memory total size
#if defined( CONFIG_MEM_8M )
    #define MEM_TOTAL_SIZE      ( 0x800000 )
    #define MEM_TOTAL_MGU_VAL   ( CACHE_PACR_8M )
#elif defined( CONFIG_MEM_16M )
    #define MEM_TOTAL_SIZE      ( 0x1000000 )
    #define MEM_TOTAL_MGU_VAL   ( CACHE_PACR_16M )
#elif defined( CONFIG_MEM_32M )
    #define MEM_TOTAL_SIZE      ( 0x1400000 )
    #define MEM_TOTAL_MGU_VAL   ( CACHE_PACR_32M )
#elif defined( CONFIG_MEM_64M )
    #define MEM_TOTAL_SIZE      ( 0x4000000 )
    #define MEM_TOTAL_MGU_VAL   ( CACHE_PACR_64M )
#elif defined( CONFIG_MEM_256M )
    #define MEM_TOTAL_SIZE      ( 0x10000000 )
    #define MEM_TOTAL_MGU_VAL   ( CACHE_PACR_256M )
#else
    #error "Don't know what the memory size"
#endif


// memory base address
#if defined( CONFIG_MEMB_0B )
    #define	MEM_BASE_ADDR   ( 0x00 )
#elif defined( CONFIG_MEMB_CB )
    #define MEM_BASE_ADDR   ( 0xc0000000 )
#elif defined( CONFIG_MEMB_DB )
    #define MEM_BASE_ADDR   ( 0xd0000000 )
#elif defined( CONFIG_MEMB_EB )
    #define MEM_BASE_ADDR   ( 0xe0000000 )
#else
    #error "Don't know what the memory base address"
#endif

// RAMFS(blkmem) SIZE

#ifdef CONFIG_AVILSI_RAMFS
    #if defined( CONFIG_RAMFS_128K )
        #define	MEM_RAMFS_SIZE	( 128 * 1024 )
    #elif defined( CONFIG_RAMFS_256K )
        #define	MEM_RAMFS_SIZE	( 256 * 1024 )
    #elif defined( CONFIG_RAMFS_512K )
        #define	MEM_RAMFS_SIZE	( 512 * 1024 )
    #elif defined( CONFIG_RAMFS_1M )
        #define	MEM_RAMFS_SIZE	( 1 * 1024 * 1024 )
    #elif defined( CONFIG_RAMFS_2M )
        #define	MEM_RAMFS_SIZE	( 2 * 1024 * 1024 )
    #elif defined( CONFIG_RAMFS_4M )
        #define	MEM_RAMFS_SIZE	( 4 * 1024 * 1024 ) 
    #endif
#endif

#ifndef MEM_RAMFS_SIZE
    #define	MEM_RAMFS_SIZE  ( 0 )
#endif

// memory start offset for kernel
#if defined( CONFIG_KNLS_1M )
    #define MEM_BASE_OFFSET         ( 0x100000 )
    #define MEM_BASE_OFF_MGU_VAL    ( CACHE_PACR_1M )
#elif defined( CONFIG_KNLS_2M )
    #define MEM_BASE_OFFSET ( 0x200000 )
    #define MEM_BASE_OFF_MGU_VAL    ( CACHE_PACR_2M )
#else
    #define	MEM_BASE_OFFSET ( 0 )
#endif

// memory size for kernel
#define MEM_SIZE    ( MEM_BASE_ADDR + MEM_TOTAL_SIZE - MEM_RAMFS_SIZE )
#define MEM_BASE    ( MEM_BASE_ADDR + MEM_BASE_OFFSET - 0x400 )
#define	VBR_BASE	( MEM_BASE )

#ifdef CONFIG_AVILSI_RAMFS
    #define MEM_RAMFS_START ( MEM_SIZE )
#endif



// kernel dma zone size
#if defined( CONFIG_DMAS_1M )
    #define MEM_DMA_SIZE    ( 0x100000 )
    #define MEM_DMA_MGU_VAL ( CACHE_PACR_1M )
#elif defined( CONFIG_DMAS_2M )
    #define MEM_DMA_SIZE    ( 0x200000 )
    #define MEM_DMA_MGU_VAL ( CACHE_PACR_2M )
#elif defined( CONFIG_DMAS_4M )
    #define MEM_DMA_SIZE    ( 0x400000 )
    #define MEM_DMA_MGU_VAL ( CACHE_PACR_4M )
#elif defined( CONFIG_DMAS_8M )
    #define MEM_DMA_SIZE    ( 0x800000 )
    #define MEM_DMA_MGU_VAL ( CACHE_PACR_8M )
#elif defined( CONFIG_DMAS_16M )
    #define MEM_DMA_SIZE    ( 0x1000000 )
    #define MEM_DMA_MGU_VAL ( CACHE_PACR_16M )
#elif defined( CONFIG_DMAS_32M )
    #define MEM_DMA_SIZE    ( 0x2000000 )
    #define MEM_DMA_MGU_VAL ( CACHE_PACR_32M )
#else
    #error "Don't know what the dma zone size"
#endif

/*
#if( MEM_DMA_SIZE >= MEM_TOTAL_SIZE )
    #error "the DMA size > total memory size"
*/

/* 
#define MEM_DMA_START   ( MEM_SIZE - MEM_DMA_SIZE + MEM_RAMFS_SIZE )
*/

/* fix to 0xc1000000 */
#define MEM_DMA_START   ( 0xc1000000 )

// config MGU value

//0 block is 4g space for no cache, here ignore

//1 block is mem_total_size, has cache
#define MGU_ZONE1_SET   ( MEM_BASE_ADDR + MEM_TOTAL_MGU_VAL )

//2 block is dma zone, no cache
#define MGU_ZONE2_SET   ( MEM_DMA_START + MEM_DMA_MGU_VAL )

//3 block is memory of the kernel unused, for pci message box etc. no cache
#define MGU_ZONE3_SET   ( MEM_BASE_ADDR + CACHE_PACR_1M )


#define UART_INIT_WORD 0xf8       /* uart init control word */
#define UART_BAUR_WORD 0x57       /* [27MHZ/(16*19200)]-1 */

#define UART_BASE 0x42000000
#define UART_DATA_OFF 0x0b 
#define UART_STAT_OFF 0x0f
#define UART_CNTL_OFF 0x07
#define UART_BAUR_OFF 0x03


/*****************************************************************************/



/****************************************************************************/
#endif	/* ckcore_h */
