/****************************************************************************/

/*
 *	cktimer.h -- CKcore on board TIMER support defines.
 *
 *      (C) Copyright 2004, Kang Sun (sunk@vlsi.zju.edu.cn)
 *	(C) Copyright 1999-2003, Greg Ungerer (gerg@snapgear.com)
 * 	(C) Copyright 2000, Lineo Inc. (www.lineo.com) 
 */

/****************************************************************************/
#ifndef	cktimer_h
#define	cktimer_h
/****************************************************************************/

#include <linux/config.h>

/*
 *	Define the Counter register and the Control register addresses for
 *      the timer on DH2004 board
 */
#if (defined(CONFIG_CK510) || defined(CONFIG_DH2004))
#define	CKTIMER_TCN0		0x70000044	/* address of 32-bit cascade TIMER counter 0 */
#define	CKTIMER_TCN1 		0x70000048	/* address of 32-bit cascade TIMER counter 1 */
#define	CKTIMER_TCN2		0x7000004c	/* address of 32-bit cascade TIMER counter 2 */
#define	CKTIMER_TCN3 		0x70000050	/* address of 32-bit cascade TIMER counter 3 */

#define CKTIMER_TCR               0x70000040      /* address of 16-bit cascade TIMER controller 1 */

#define CKTIMER_CUR_TCNT0            0x70000070      /* current timer0 counter */
#define CKTIMER_CUR_TCNT1            0x70000074      /* current timer1 counter */
#define CKTIMER_CUR_TCNT2            0x70000078      /* current timer2 counter */
#define CKTIMER_CUR_TCNT3            0x7000007c      /* current timer3 counter */
#endif


/*
 *	Bit definitions for the Timer Control Register (TCR).
 */
/* for or */
#define CKTIMER_TCR0_EN          0x00000001
#define CKTIMER_TCR0_SGLE        0x00000004
#define CKTIMER_TCR0_CAPEN       0x00000008
#define CKTIMER_TCR0_CASCADE     0x00000010

#define CKTIMER_TCR1_EN          0x00000100
#define CKTIMER_TCR1_SGLE        0x00000400
#define CKTIMER_TCR1_CAPEN       0x00000800
#define CKTIMER_TCR1_CASCADE     0x00001000

#define CKTIMER_TCR2_EN          0x00010000
#define CKTIMER_TCR2_SGLE        0x00040000
#define CKTIMER_TCR2_CAPEN       0x00080000
#define CKTIMER_TCR2_CASCADE     0x00100000

#define CKTIMER_TCR3_EN          0x01000000
#define CKTIMER_TCR3_SGLE        0x04000000
#define CKTIMER_TCR3_CAPEN       0x08000000
#define CKTIMER_TCR3_CASCADE     0x10000000

/****************************************************************************/
#endif	/* cktimer_h */
