/****************************************************************************/

/*
 *	ckuart.h -- CK510 for DH2004 Board internal UART support defines.
 *
 *      (C) Copyright 2004 Kang Sun <sunk@vlsi.zju.edu.cn>
 *	(C) Copyright 1999-2003, Greg Ungerer (gerg@snapgear.com)
 * 	(C) Copyright 2000, Lineo Inc. (www.lineo.com) 
 */

/****************************************************************************/
#ifndef ckuart_h
#define	ckuart_h
/****************************************************************************/

#include <linux/config.h>

/*
 *	Define the base address of the UARTS within the MBAR address
 *	space.
 */
#if (defined(CONFIG_DAHUA) || defined(CONFIG_DH2004))
#define	CKDH2004_UART_BASE1		0x42000000	/* Base address of UART1 */
#define CKDH2004_UART_BASE2     0x41000000      /* Base address of UART2 (Added by zoe Meng) */
#endif


/*
 *	Define the CK510 for DH2004 Board UART register set addresses.
 */
#define	CKDH2004_UART_BDR	0x03		/* Baud Rate register (w) */
#define	CKDH2004_UART_SR	0x0f		/* Status register (r) */
#define	CKDH2004_UART_CR	0x07		/* Control register  (r/w) */
#define	CKDH2004_UART_DR	0x0b		/* Data register (r/w) */


/*
 *	Define bit flags in Control Register (CR).
 */
#define	CKDH2004_UART_CR_NULL		0x00	/* No command */
#define	CKDH2004_UART_CR_RXCIE 	        0x80	/* RX Complete interrupt enable */
#define	CKDH2004_UART_CR_TXCIE		0x40	/* TX Complete interrupt enable */
#define	CKDH2004_UART_CR_UDRIE		0x20	/* Uart Data Register Empty interrupt enable */
#define	CKDH2004_UART_CR_RXEN		0x10	/* Receive enable */
#define	CKDH2004_UART_CR_TXEN     	0x08	/* Transmitter enable */
#define	CKDH2004_UART_CR_9BIT	        0x04	/* 9 bit characters */

/*
 *      Define bit flags in the Status Register
 */
#define CKDH2004_UART_SR_RXC            0x80    /* UART Receive Complete */
#define CKDH2004_UART_SR_TXC            0x40    /* UART Transmit Complete */
#define CKDH2004_UART_SR_UDRE           0x20    /* UART Data Register Empty */
#define CKDH2004_UART_SR_FE             0x10    /* Framing Error */
#define CKDH2004_UART_SR_OR             0x08    /* Over Run */

#define CKDH2004_UART_SR_RXERR (CKDH2004_UART_SR_FE | CKDH2004_UART_SR_OR)
/****************************************************************************/
#endif	/* ckuart_h */
