#ifndef __ASMCKCORE_ELF_H
#define __ASMCKCORE_ELF_H

/*
 * ELF register definitions..
 */

#include <linux/config.h>
#include <asm/ptrace.h>
#include <asm/user.h>

typedef unsigned long elf_greg_t;

#define ELF_NGREG (sizeof(struct user_regs_struct) / sizeof(elf_greg_t))

typedef elf_greg_t elf_gregset_t[ELF_NGREG];

typedef struct user_ckcorefp_struct elf_fpregset_t;

/*
 * This is used to ensure we don't load something for the wrong architecture.
 */
#define elf_check_arch(x) ((x)->e_machine == EM_CKCORE)

/*
 * These are used to set parameters in the core dumps.
 */
#define ELF_CLASS	ELFCLASS32
#define ELF_DATA	ELFDATA2MSB
#define ELF_ARCH	EM_CKCORE

/* For ckcore the function pointer to be registered with `atexit' is
   passed in %a1.  Although my copy of the ABI has no such statement, it
   is actually used on ASV.  */
#define ELF_PLAT_INIT(_r, func)	_r->r2 = 0

#define USE_ELF_CORE_DUMP
#define ELF_EXEC_PAGESIZE	4096

/* This is the location that an ET_DYN program is loaded if exec'ed.  Typical
   use of this is to invoke "./ld.so someprog" to test out a new version of
   the loader.  We need to make sure that it is out of the way of the program
   that it will "exec", and that there is sufficient room for the brk.  */

#define ELF_ET_DYN_BASE         0x00000000UL

#define ELF_CORE_COPY_REGS(pr_reg, regs)				\
	/* Bleech. */							\
	pr_reg[0] = regs->pc;						\
	pr_reg[1] = regs->r1;						\
	pr_reg[2] = regs->syscallr2;					\
	pr_reg[3] = regs->sr;						\
	pr_reg[4] = regs->r2;						\
        pr_reg[5] = regs->r3;                                           \
        pr_reg[6] = regs->r4;                                           \
	pr_reg[7] = regs->r5;						\
	pr_reg[8] = regs->r6;						\
        pr_reg[9] = regs->r7;                                           \
        pr_reg[10] = regs->r8;                                          \
        pr_reg[11] = regs->r9;                                          \
        pr_reg[12] = regs->r10;                                         \
        pr_reg[13] = regs->r11;                                         \
	pr_reg[14] = regs->r12;						\
	pr_reg[15] = regs->r13;						\
	pr_reg[16] = regs->r14;                   			\
	pr_reg[17] = regs->r15;						\
        pr_reg[18] = rdusp();
/* This yields a mask that user programs can use to figure out what
   instruction set this cpu supports.  */

#define ELF_HWCAP	(0)

/* This yields a string that ld.so will use to load implementation
   specific libraries for optimization.  This is more specific in
   intent than poking at uname or /proc/cpuinfo.  */

#define ELF_PLATFORM  (NULL)

#ifdef __KERNEL__
#define SET_PERSONALITY(ex, ibcs2) set_personality((ibcs2)?PER_SVR4:PER_LINUX)
#endif

#endif
