#ifndef __CKCORE_ENTRY_H
#define __CKCORE_ENTRY_H

#include <linux/config.h>
#include <asm/setup.h>
#include <asm/page.h>

/*
 * Stack layout in 'ret_from_exception':
 *      Below describes the stack layout after initial exception entry.
 *      All traps, interrupts and exceptions will set up the stack frame
 *      in this way before starting processing proper.
 *	This allows access to the syscall arguments in registers r1-r5
 *
 *	 0(sp) - pc
 *	 4(sp) - r1
 *	 8(sp) - syscallr1
 *	 C(sp) - sr
 *	10(sp) - r2
 *	14(sp) - r3
 *	18(sp) - r4
 *	1C(sp) - r5
 *	20(sp) - r6
 *	24(sp) - r7
 *	28(sp) - r8
 *	2C(sp) - r9
 *	30(sp) - r10
 *	34(sp) - r11
 *      38(sp) - r12
 *      3C(sp) - r13
 *      40(sp) - r14
 *      44(sp) - r15
 */


/*
 *      Offsets into the stack to get at save registers.
 */
#define LSAVE_R1         0x4
#define LSAVE_SYSCALLR1  0x8
#define LSAVE_R2         0x10
#define LSAVE_R3         0x14
#define LSAVE_R4         0x18
#define LSAVE_R5         0x1C
#define LSAVE_R6         0x20
#define LSAVE_R7         0x24
#define LSAVE_R8         0x28
#define LSAVE_R9         0x2C
#define LSAVE_R10        0x30
#define LSAVE_R11        0x34
#define LSAVE_R12        0x38
#define LSAVE_R13        0x3C
#define LSAVE_R14        0x40
#define LSAVE_R15        0x44

/*
 * 97/05/14 Andreas: Register %a2 is now set to the current task throughout
 *		     the whole kernel.
 */

/* the following macro is used when enabling interrupts */
//#if defined(MACH_ATARI_ONLY) && !defined(CONFIG_HADES)
	/* block out HSYNC on the atari */
//#define ALLOWINT 0xfbff
//#define	MAX_NOINT_IPL	3
//#else
	/* portable version */
//#define ALLOWINT 0xf8ff
//#define	MAX_NOINT_IPL	0
//#endif /* machine compilation types */ 

#ifdef __ASSEMBLY__

#define curptr a2

LFLUSH_I_AND_D = 0x00000808
LSIGTRAP = 5

#define H_UNSTM
//#undef H_UNSTM


#define SAVE_ALL save_all
#define RESTORE_ALL restore_all
/*
 *      This code creates the normal kernel pt_regs layout on a trap
 *      or interrupt. The only trick here is that we check whether we
 *      came from supervisor mode before changing stack pointers.
*/

.macro	save_all 
	mtcr    r1, ss2         /* save original r1 */
	mtcr    r2, ss3         /* save original r2 */
        
        mfcr    r1, epsr        /* Get original PSR */
        btsti   r1, 31          /* Check if was supervisor */
        bt      1f
        mtcr    r0, ss1         /* save user stack */
        mfcr    r0, ss0         /* Set kernel stack */
        1:
        subi    r0, 32
        subi    r0, 28
		
	#ifndef H_UNSTM
        stm     r1-r15, (r0)    /* Save all user registers */
	#else
        stw     r1, (r0, 0)
        stw     r2, (r0, 4)
        stw     r3, (r0, 8)
        stw     r4, (r0, 12)
        stw     r5, (r0, 16)
        stw     r6, (r0, 20)
        stw     r7, (r0, 24)
        stw     r8, (r0, 28)
        stw     r9, (r0, 32)
        stw     r10, (r0, 36)
        stw     r11, (r0, 40)
        stw     r12, (r0, 44)
        stw     r13, (r0, 48)
        stw     r14, (r0, 52)
        stw     r15, (r0, 56)
	#endif
		
        subi    r0, 12          /* Make room for PC/PSR/r1 */
        mfcr    r1, ss2         /* Save original r1 on stack */
        stw     r1, (r0, 4)	/* Save r1 */
        stw     r2, (r0, 8)     /* Save syscall r2 on stack */	//syscallr1->syscallr2;r1->r2, Modified by Li Chunqiang 20050626, please refer asm/ptrace.h
        mfcr    r2, epc         /* Save PC on stack */
        stw     r2, (r0)
        mfcr    r2, ss3         /* restore original r2 */
.endm

.macro	restore_all
 psrclr   ie             /* Disable interrupt before restore */
        
        ldw     r2, (r0)        /* Restore PC */
        mtcr    r2, epc         /* Set return PC */    
        ldw     r1, (r0, 4)     /* Get original r1 */
        ldw     r2, (r0, 12)    /* Get saved PSR */
        mtcr    r2, epsr        /* Restore PSR */
        addi    r0, 16    
        btsti   r2, 31          /* Check if returning to user */
		
	#ifndef H_UNSTM
        ldm     r2-r15, (r0)    /* Restore registers */  
	#else
		ldw     r2, (r0, 0)
        ldw     r3, (r0, 4)
        ldw     r4, (r0, 8)
        ldw     r5, (r0, 12)
        ldw     r6, (r0, 16)
        ldw     r7, (r0, 20)
        ldw     r8, (r0, 24)
        ldw     r9, (r0, 28)
        ldw     r10, (r0, 32)
        ldw     r11, (r0, 36)
        ldw     r12, (r0, 40)
        ldw     r13, (r0, 44)
        ldw     r14, (r0, 48)
        ldw     r15, (r0, 52)
	#endif
	
        addi    r0, 28          /* Increment stack pointer */
        addi    r0, 28 
        bt      1f
        mtcr    r0, ss0         /* Save kernel stack*/
        mfcr    r0, ss1         /* Set  user stack */ 
        1:
        rte
.endm

#define SWITCH_STACK_SIZE (15*4)	/* includes return address */

#define SAVE_SWITCH_STACK save_switch_stack
#define RESTORE_SWITCH_STACK restore_switch_stack
#if 0 // DAVIDM
#define GET_CURRENT(tmp) get_current tmp
#else
#define GET_CURRENT(tmp)
#endif

.macro	save_switch_stack
        subi    r0, 32    
        subi    r0, 28

	#ifndef H_UNSTM
        stm     r1-r15, (r0)     /* Save all user regs */
	#else
		stw     r1, (r0, 0)
        stw     r2, (r0, 4)
        stw     r3, (r0, 8)
        stw     r4, (r0, 12)
        stw     r5, (r0, 16)
        stw     r6, (r0, 20)
        stw     r7, (r0, 24)
        stw     r8, (r0, 28)
        stw     r9, (r0, 32)
        stw     r10, (r0, 36)
        stw     r11, (r0, 40)
        stw     r12, (r0, 44)
        stw     r13, (r0, 48)
        stw     r14, (r0, 52)
        stw     r15, (r0, 56)
	#endif
	
.endm

.macro	restore_switch_stack

	#ifndef H_UNSTM
        ldm     r1-r15, (r0)     /* Restore all registers */
	#else
		ldw     r1, (r0, 0)
        ldw     r2, (r0, 4)
        ldw     r3, (r0, 8)
        ldw     r4, (r0, 12)
        ldw     r5, (r0, 16)
        ldw     r6, (r0, 20)
        ldw     r7, (r0, 24)
        ldw     r8, (r0, 28)
        ldw     r9, (r0, 32)
        ldw     r10, (r0, 36)
        ldw     r11, (r0, 40)
        ldw     r12, (r0, 44)
        ldw     r13, (r0, 48)
        ldw     r14, (r0, 52)
        ldw     r15, (r0, 56)	
	#endif
	
		addi    r0, 32
		addi    r0, 28
.endm

#if 0 // DAVIDM
.macro	get_current reg=%d0
	movel	%sp,\reg
	andw	#-KTHREAD_SIZE,\reg
	movel	\reg,%curptr
.endm
#endif

#else /* C source */

#define STR(X) STR1(X)
#define STR1(X) #X

#define PT_OFF_ORIG_D0	 0x24
#define PT_OFF_FORMATVEC 0x32
#define PT_OFF_SR	 0x2C

#endif

#endif /* __CKCORE_ENTRY_H */

