/*
 * include/asm-arm/dec21285.h
 *
 * Copyright (C) 1998 Russell King
 *
 * DAHUA registers
 */
 


#define CKCOREPLD_SIZE		0x00100000
#define CKCOREPLD_BASE		0x80000000

#define PCICFG1_SIZE		0x01000000
#define PCICFG1_BASE		0x00000000

#define PCICFG0_SIZE		0x01000000
#define PCICFG0_BASE		0x00000000
 
#define DAHUA_PCI_IACK		0x79000000
#define DAHUA_CKCOREPLD_BASE		0x42000000
#define DAHUA_PCI_TYPE_0_CONFIG	0x7b000000
#define DAHUA_PCI_TYPE_1_CONFIG	0x7a000000
#define DAHUA_OUTBOUND_WRITE_FLUSH	0x78000000
#define DAHUA_FLASH			0x41000000
#define DAHUA_PCI_IO			0x83000000
#define DAHUA_PCI_MEM			0//0x00010000

/* add by zxj for pci irq */
#define CKCORE_PCI_IRQ      50

#define DAHUA_IO(x)		((volatile unsigned long *)(CKCOREPLD_BASE+(x)))

#define PLD_WDMA_DST_ADDR DAHUA_IO(0)
#define PLD_WDMA_SRC_ADDR DAHUA_IO(0x4)
#define PLD_WDMA_CTRL DAHUA_IO(0x8)

#define PLD_RDMA_SRC_ADDR DAHUA_IO(0x20)
#define PLD_RDMA_DST_ADDR DAHUA_IO(0x24)
#define PLD_RDMA_CTRL DAHUA_IO(0x28)

#define PLD_CPU_IMASK DAHUA_IO(0x40)
#define PLD_CPU_ISTATUS DAHUA_IO(0x44)
#define PLD_CPU_ICMD DAHUA_IO(0x48)
#define PLD_CPU_VERSION DAHUA_IO(0x4c)
#define PLD_CPU_CLKRUN DAHUA_IO(0x50)
#define PLD_CPU_CIS_PTR DAHUA_IO(0x54)
#define PLD_CPU_PM DAHUA_IO(0x58)

#define PLD_PCIAHB_ADDR_NP DAHUA_IO(0x70)
#define PLD_PCIAHB_ADDR_PF DAHUA_IO(0x74)
#define PLD_PCIAHB_TIMER DAHUA_IO(0x78)
#define PLD_AHBPCI_TIMER DAHUA_IO(0x7c)
#define PLD_PCI_CONTROL DAHUA_IO(0x80)
#define PLD_PCI_DV DAHUA_IO(0x84)
#define PLD_PCI_SUB DAHUA_IO(0x88)
#define PLD_PCI_CREV DAHUA_IO(0x8c)
#define PLD_PCI_BROKEN DAHUA_IO(0x90)
#define PLD_PCIAHB_NP_SIZE DAHUA_IO(0x94)
#define PLD_PCIAHB_PF_SIZE DAHUA_IO(0x98)

/*DMA CMD and BIT DEFINE*/
/*interrupt mask*/

#define PLD_INTA_ENABLE (1<<24)
#define PLD_INTB_ENABLE (1<<25)
#define PLD_INTC_ENABLE (1<<26)
#define PLD_INTD_ENABLE (1<<27)

#define PLD_WRITE_DMA_END 	(1<<0)
#define PLD_WRITE_DMA_ABORT (1<<1)
#define PLD_WRITE_DMA_ERROR	(1<<2)
#define PLD_WRITE_DMA_EOORO	(1<<3)
/*Read DMA*/
#define PLD_DMA_INTER_ACK  0x00
#define PLD_DMA_IO_READ  0x20
#define PLD_DMA_MEMORY_READ  0x60
#define PLD_DMA_CONFIG_READ  0xa0
#define PLD_DMA_MEMORY_READ_MUL  0xc0

/*Write DMA*/
#define PLD_DMA_SPCIAL_CYC  0x10
#define PLD_DMA_IO_WRITE  0x30
#define PLD_DMA_MEMORY_WRITE  0x70
#define PLD_DMA_CONFIG_WRITE  0xb0

/*DMA Bit*/
#define PLD_DMA_START 0x01
#define DEV1_IDSEL  0x80000000


#define PLD_PCICMD		DAHUA_IO(0x0004)
#define PLD_CLASSREV		DAHUA_IO(0x0008)
#define PLD_PCICACHELINESIZE	DAHUA_IO(0x000c)
#define PLD_PCIPLDBASE		DAHUA_IO(0x0010)
#define PLD_PCIPLDIOBASE	DAHUA_IO(0x0014)
#define PLD_PCISDRAMBASE	DAHUA_IO(0x0018)
#define PLD_PCIROMBASE		DAHUA_IO(0x0030)
#define PLD_MBOX0		DAHUA_IO(0x0050)
#define PLD_MBOX1		DAHUA_IO(0x0054)
#define PLD_MBOX2		DAHUA_IO(0x0058)
#define PLD_MBOX3		DAHUA_IO(0x005c)
#define PLD_DOORBELL		DAHUA_IO(0x0060)
#define PLD_DOORBELL_SETUP	DAHUA_IO(0x0064)
#define PLD_ROMWRITEREG		DAHUA_IO(0x0068)
#define PLD_PLDBASEMASK		DAHUA_IO(0x00f8)
#define PLD_PLDBASEOFFSET	DAHUA_IO(0x00fc)
#define PLD_SDRAMBASEMASK	DAHUA_IO(0x0100)
#define PLD_SDRAMBASEOFFSET	DAHUA_IO(0x0104)
#define PLD_ROMBASEMASK		DAHUA_IO(0x0108)
#define PLD_SDRAMTIMING		DAHUA_IO(0x010c)
#define PLD_SDRAMADDRSIZE0	DAHUA_IO(0x0110)
#define PLD_SDRAMADDRSIZE1	DAHUA_IO(0x0114)
#define PLD_SDRAMADDRSIZE2	DAHUA_IO(0x0118)
#define PLD_SDRAMADDRSIZE3	DAHUA_IO(0x011c)
#define PLD_I2O_INFREEHEAD	DAHUA_IO(0x0120)
#define PLD_I2O_INPOSTTAIL	DAHUA_IO(0x0124)
#define PLD_I2O_OUTPOSTHEAD	DAHUA_IO(0x0128)
#define PLD_I2O_OUTFREETAIL	DAHUA_IO(0x012c)
#define PLD_I2O_INFREECOUNT	DAHUA_IO(0x0130)
#define PLD_I2O_OUTPOSTCOUNT	DAHUA_IO(0x0134)
#define PLD_I2O_INPOSTCOUNT	DAHUA_IO(0x0138)
#define PLD_SA110_CNTL		DAHUA_IO(0x013c)
#define SA110_CNTL_INITCMPLETE		(1 << 0)
#define SA110_CNTL_ASSERTSERR		(1 << 1)
#define SA110_CNTL_RXSERR		(1 << 3)
#define SA110_CNTL_SA110DRAMPARITY	(1 << 4)
#define SA110_CNTL_PCISDRAMPARITY	(1 << 5)
#define SA110_CNTL_DMASDRAMPARITY	(1 << 6)
#define SA110_CNTL_DISCARDTIMER		(1 << 8)
#define SA110_CNTL_PCINRESET		(1 << 9)
#define SA110_CNTL_I2O_256		(0 << 10)
#define SA110_CNTL_I20_512		(1 << 10)
#define SA110_CNTL_I2O_1024		(2 << 10)
#define SA110_CNTL_I2O_2048		(3 << 10)
#define SA110_CNTL_I2O_4096		(4 << 10)
#define SA110_CNTL_I2O_8192		(5 << 10)
#define SA110_CNTL_I2O_16384		(6 << 10)
#define SA110_CNTL_I2O_32768		(7 << 10)
#define SA110_CNTL_WATCHDOG		(1 << 13)
#define SA110_CNTL_ROMWIDTH_UNDEF	(0 << 14)
#define SA110_CNTL_ROMWIDTH_16		(1 << 14)
#define SA110_CNTL_ROMWIDTH_32		(2 << 14)
#define SA110_CNTL_ROMWIDTH_8		(3 << 14)
#define SA110_CNTL_ROMACCESSTIME(x)	((x)<<16)
#define SA110_CNTL_ROMBURSTTIME(x)	((x)<<20)
#define SA110_CNTL_ROMTRISTATETIME(x)	((x)<<24)
#define SA110_CNTL_XCSDIR(x)		((x)<<28)
#define SA110_CNTL_PCICFN		(1 << 31)

/*
 * footbridge_cfn_mode() is used when we want
 * to check whether we are the central function
 */
#define __footbridge_cfn_mode() ((*((unsigned long *)(CKCOREPLD_BASE + 0x4c))>>12) & 0x02)
//#if defined(CONFIG_FOOTBRIDGE_HOST) && defined(CONFIG_FOOTBRIDGE_ADDIN)
//#define footbridge_cfn_mode() __footbridge_cfn_mode()
//#elif defined(CONFIG_FOOTBRIDGE_HOST)
//#define footbridge_cfn_mode() (1)
//#else
#define footbridge_cfn_mode() __footbridge_cfn_mode()
//#endif

#define PLD_PCIADDR_EXTN	DAHUA_IO(0x0140)
#define PLD_PREFETCHMEMRANGE	DAHUA_IO(0x0144)
#define PLD_XBUS_CYCLE		DAHUA_IO(0x0148)
#define PLD_XBUS_IOSTROBE	DAHUA_IO(0x014c)
#define PLD_DOORBELL_PCI	DAHUA_IO(0x0150)
#define PLD_DOORBELL_SA110	DAHUA_IO(0x0154)
#define PLD_UARTDR		DAHUA_IO(0x0160)
#define PLD_RXSTAT		DAHUA_IO(0x0164)
#define PLD_H_UBRLCR		DAHUA_IO(0x0168)
#define PLD_M_UBRLCR		DAHUA_IO(0x016c)
#define PLD_L_UBRLCR		DAHUA_IO(0x0170)
#define PLD_UARTCON		DAHUA_IO(0x0174)
#define PLD_UARTFLG		DAHUA_IO(0x0178)
#define PLD_IRQ_STATUS		DAHUA_IO(0x0180)
#define PLD_IRQ_RAWSTATUS	DAHUA_IO(0x0184)
#define PLD_IRQ_ENABLE		DAHUA_IO(0x0188)
#define PLD_IRQ_DISABLE		DAHUA_IO(0x018c)
#define PLD_IRQ_SOFT		DAHUA_IO(0x0190)
#define PLD_FIQ_STATUS		DAHUA_IO(0x0280)
#define PLD_FIQ_RAWSTATUS	DAHUA_IO(0x0284)
#define PLD_FIQ_ENABLE		DAHUA_IO(0x0288)
#define PLD_FIQ_DISABLE		DAHUA_IO(0x028c)
#define PLD_FIQ_SOFT		DAHUA_IO(0x0290)
#define PLD_TIMER1_LOAD		DAHUA_IO(0x0300)
#define PLD_TIMER1_VALUE	DAHUA_IO(0x0304)
#define PLD_TIMER1_CNTL		DAHUA_IO(0x0308)
#define PLD_TIMER1_CLR		DAHUA_IO(0x030c)
#define PLD_TIMER2_LOAD		DAHUA_IO(0x0320)
#define PLD_TIMER2_VALUE	DAHUA_IO(0x0324)
#define PLD_TIMER2_CNTL		DAHUA_IO(0x0328)
#define PLD_TIMER2_CLR		DAHUA_IO(0x032c)
#define PLD_TIMER3_LOAD		DAHUA_IO(0x0340)
#define PLD_TIMER3_VALUE	DAHUA_IO(0x0344)
#define PLD_TIMER3_CNTL		DAHUA_IO(0x0348)
#define PLD_TIMER3_CLR		DAHUA_IO(0x034c)
#define PLD_TIMER4_LOAD		DAHUA_IO(0x0360)
#define PLD_TIMER4_VALUE	DAHUA_IO(0x0364)
#define PLD_TIMER4_CNTL		DAHUA_IO(0x0368)
#define PLD_TIMER4_CLR		DAHUA_IO(0x036c)

#define TIMER_CNTL_ENABLE	(1 << 7)
#define TIMER_CNTL_AUTORELOAD	(1 << 6)
#define TIMER_CNTL_DIV1		(0)
#define TIMER_CNTL_DIV16	(1 << 2)
#define TIMER_CNTL_DIV256	(2 << 2)
#define TIMER_CNTL_CNTEXT	(3 << 2)

//#define NR_IRQS			36
#define NR_DAHUA_IRQS		16

#define _ISA_IRQ(x)		(0 + (x))
#define _ISA_INR(x)		((x) - 0)
#define _DAHUA_IRQ(x)		(16 + (x))
#define _DAHUA_INR(x)		((x) - 16)

/*
 * This is a list of all interrupts that the 21285
 * can generate and we handle.
 */
#define IRQ_CONRX		_DAHUA_IRQ(0)
#define IRQ_CONTX		_DAHUA_IRQ(1)
#define IRQ_TIMER1		_DAHUA_IRQ(2)
#define IRQ_TIMER2		_DAHUA_IRQ(3)
#define IRQ_TIMER3		_DAHUA_IRQ(4)
#define IRQ_IN0			_DAHUA_IRQ(5)
#define IRQ_IN1			_DAHUA_IRQ(6)
#define IRQ_IN2			_DAHUA_IRQ(7)
#define IRQ_IN3			_DAHUA_IRQ(8)
#define IRQ_DOORBELLHOST	_DAHUA_IRQ(9)
#define IRQ_DMA1		_DAHUA_IRQ(10)
#define IRQ_DMA2		_DAHUA_IRQ(11)
#define IRQ_PCI			_DAHUA_IRQ(12)
#define IRQ_SDRAMPARITY		_DAHUA_IRQ(13)
#define IRQ_I2OINPOST		_DAHUA_IRQ(14)
#define IRQ_PCI_ABORT		_DAHUA_IRQ(15)
#define IRQ_PCI_SERR		_DAHUA_IRQ(16)
#define IRQ_DISCARD_TIMER	_DAHUA_IRQ(17)
#define IRQ_PCI_DPERR		_DAHUA_IRQ(18)
#define IRQ_PCI_PERR		_DAHUA_IRQ(19)

#define IRQ_MASK_UART_RX	(1 << 2)
#define IRQ_MASK_UART_TX	(1 << 3)
#define IRQ_MASK_TIMER1		(1 << 4)
#define IRQ_MASK_TIMER2		(1 << 5)
#define IRQ_MASK_TIMER3		(1 << 6)
#define IRQ_MASK_IN0		(1 << 8)
#define IRQ_MASK_IN1		(1 << 9)
#define IRQ_MASK_IN2		(1 << 10)
#define IRQ_MASK_IN3		(1 << 11)
#define IRQ_MASK_DOORBELLHOST	(1 << 15)
#define IRQ_MASK_DMA1		(1 << 16)
#define IRQ_MASK_DMA2		(1 << 17)
#define IRQ_MASK_PCI		(1 << 18)
#define IRQ_MASK_SDRAMPARITY	(1 << 24)
#define IRQ_MASK_I2OINPOST	(1 << 25)
#define IRQ_MASK_PCI_ABORT	((1 << 29) | (1 << 30))
#define IRQ_MASK_PCI_SERR	(1 << 23)
#define IRQ_MASK_DISCARD_TIMER	(1 << 27)
#define IRQ_MASK_PCI_DPERR	(1 << 28)
#define IRQ_MASK_PCI_PERR	(1 << 31)

