#ifndef _CKCORE_PTRACE_H
#define _CKCORE_PTRACE_H

#define PT_R0   0
#define PT_R1   1
#define PT_R2   2
#define PT_R3   3
#define PT_R4   4
#define PT_R5   5
#define PT_R6   6
#define PT_R7   7
#define PT_R8   8
#define PT_R9   9
#define PT_R10  10
#define PT_R11  11
#define PT_R12  12
#define PT_R13  13
#define PT_R14  14
#define PT_R15  15
#define PT_PC   16
#define PT_SR   17
#define PT_USP  PT_R0

#ifndef __ASSEMBLY__

/* this struct defines the way the registers are stored on the
   stack during a system call. */
struct pt_regs {
         unsigned long   pc;
         long            r1;
	 //long            syscallr1;	//We do not modify the value of r1 in syscall process, but r2 may be modified for the system return value.
         long            syscallr2;	//When syscall fails, we must recover syscall arg (r2, modified when syscall return), Modified by Li Chunqiang  20050626
         unsigned long   sr;
         long            r2;
         long            r3;
         long            r4;
         long            r5;
         long            r6;
         long            r7;
         long            r8;
         long            r9;
         long            r10;
         long            r11;
         long            r12;
         long            r13;
         long            r14;
         long            r15;
};


/*
 * This is the extended stack used by signal handlers and the context
 * switcher: it's pushed after the normal "struct pt_regs".
 */
struct switch_stack {
         unsigned long   r1;
         unsigned long   r2;
         unsigned long   r3;
         unsigned long   r4;
         unsigned long   r5;
         unsigned long   r6;
         unsigned long   r7;
         unsigned long   r8;
         unsigned long   r9;
         unsigned long   r10;
         unsigned long   r11;
         unsigned long   r12;
         unsigned long   r13;
         unsigned long   r14;
         unsigned long   r15;
};

/* Arbitrarily choose the same ptrace numbers as used by the Sparc code. */
#define PTRACE_GETREGS            12
#define PTRACE_SETREGS            13

#ifdef __KERNEL__

#ifndef PS_S
#define PS_S            0x80000000              /* Supervisor Mode */
#define PS_TM           0x0000c000              /* Trace mode */
#endif

#define user_mode(regs) (!((regs)->sr & PS_S))
#define instruction_pointer(regs) ((regs)->pc)
#define user_stack(regs) (sw_usp)
extern void show_regs(struct pt_regs *);
#endif /* __KERNEL__ */
#endif /* __ASSEMBLY__ */
#endif /* _CKCORE_PTRACE_H */
