/* ------------------------------------------------------------------------- */
/* adap-dahua.h i2c driver algorithms for DH8584 adapters                     */
/* ------------------------------------------------------------------------- */
/*   Copyright (C) 1995-97 Simon G. Vogl
                   1998-99 Hans Berglund

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                */
/* ------------------------------------------------------------------------- */

/* With some changes from Kysti Mlkki <kmalkki@cc.hut.fi> and even
   Frodo Looijaard <frodol@dds.nl> */

/* $Id: i2c-algo-dahua.h,v 1.1.1.1 2005/01/17 01:40:31 licq Exp $ */

#ifndef I2C_ALGO_DH_H
#define I2C_ALGO_DH_H 1

/* --- Defines for dahua-adapters ---------------------------------------	*/
#include <linux/i2c.h>

struct i2c_algo_dahua_data {
	void *data;		/* private data for lolevel routines	*/
	void (*setdahua) (void *data, int ctl, int val);
	int  (*getdahua) (void *data, int ctl);
	int  (*getown) (void *data);
	int  (*getclock) (void *data);
	void (*waitforpin) (void);     

	/* local settings */
	int udelay;
	int mdelay;
	int timeout;
};

#define I2C_DH_ADAP_MAX	16

int i2c_dahua_add_bus(struct i2c_adapter *);
int i2c_dahua_del_bus(struct i2c_adapter *);

#endif /* I2C_ALGO_DH_H */
