#ifndef __LINUX_MTD_NAND_H
#define __LINUX_MTD_NAND_H

#include <linux/config.h>
#include <linux/sched.h>

/*
 * Searches for a NAND device
 */
extern int spi_nand_scan (struct mtd_info *mtd);


/*
 * Standard NAND flash commands
 */
#define NAND_CMD_READ0		0
#define NAND_CMD_READ1		1
#define NAND_CMD_PAGEPROG	0x10
#define NAND_CMD_READOOB	0x50
#define NAND_CMD_ERASE1		0x60
#define NAND_CMD_STATUS		0x70
#define NAND_CMD_SEQIN		0x80
#define NAND_CMD_READID		0x90
#define NAND_CMD_ERASE2		0xd0
#define NAND_CMD_RESET		0xff


	
/*
 * Enumeration for NAND flash chip state
 */
typedef enum {
	FL_READY,
	FL_READING,
	FL_WRITING,
	FL_ERASING,
	FL_SYNCING
}spi_nand_state_t;


struct spi_nand_chip 
{
	void 		(*read_device_id)(struct mtd_info *mtd,int *mf_id, int *dev_id);
	int 		(*read)(struct mtd_info *mtd,loff_t from, size_t len, size_t * retlen, u_char * buf);
	int 		(*write)(struct mtd_info *mtd,loff_t to, size_t len, size_t * retlen, const u_char * buf);
	int 		(*erase)(struct mtd_info *mtd,int begin_addr,int end_addr);
	spinlock_t 	chip_lock;
	wait_queue_head_t wq;
	spi_nand_state_t 	state;
	//char * pdatabuf;
};

/*
 * NAND Flash Manufacturer ID Codes
 */
#define NAND_MFR_TOSHIBA	0x98
#define NAND_MFR_SAMSUNG	0xec
#define NAND_MFR_FUJITSU	0x04
#define NAND_MFR_NATIONAL	0x8f
#define NAND_MFR_WINBOND	0xef
#define NAND_MFR_DAHUA		0xC2


struct spi_nand_flash_dev {
	char * name;
	int id;
	int chipshift;
	unsigned long erasesize;
};


struct spi_nand_manufacturers {
	int id;
	char * name;
};

extern struct spi_nand_flash_dev spi_nand_flash_ids[];
extern struct spi_nand_manufacturers spi_nand_manuf_ids[];


#endif /* __LINUX_MTD_NAND_H */
