#ifndef __SPI_H__
#define __SPI_H__

//SPIж״̬
#define INT_IDLE 0
#define INT_TXDFIFO 1		//txdfifo<= txdffi_level interrupt
#define INT_RXDFIFO 2		//rxdfifo>= rxdffi_level interrupt
#define INT_GEN 3			//general SPI TXD or RXD interrupt
#define INT_WRITE 4			//spd write  interrupt
#define INT_READ 5			//spd read interrupt
#define INT_ERROR 6			//register error interrupt


/* spi I/O addr 1th base addr is 0x60040000 2th is 0x60050000*/
#define SPI_BASE_ADDR (0X60040000)

/*x is 0 or 1*/
#define	SPI_SDR(x)		*(volatile unsigned int *)(SPI_BASE_ADDR + ((x) << 16))
#define	SPI_RDR(x)		*(volatile unsigned int *)(SPI_BASE_ADDR + 0x4 + ((x) << 16))
#define	SPI_BDR(x)		*(volatile unsigned int *)(SPI_BASE_ADDR + 0x8 + ((x) << 16))
#define	SPI_MDR(x)	    *(volatile unsigned int *)(SPI_BASE_ADDR + 0xc + ((x) << 16))
#define	SPI_IQR(x)		*(volatile unsigned int *)(SPI_BASE_ADDR + 0x10 + ((x) << 16))
#define	SPI_TCR(x)		*(volatile unsigned int *)(SPI_BASE_ADDR + 0x14 + ((x) << 16))
#define	SPI_CTR(x)		*(volatile unsigned int *)(SPI_BASE_ADDR + 0x18 + ((x) << 16))
#define	SPI_STR(x)		*(volatile unsigned int *)(SPI_BASE_ADDR + 0x1c + ((x) << 16))
#define	SPI_ADDR(x)	    *(volatile unsigned int *)(SPI_BASE_ADDR + 0x20 + ((x) << 16))
#define	SPI_LEN(x)		*(volatile unsigned int *)(SPI_BASE_ADDR + 0x24 + ((x) << 16))

/* 
    SPI_MODE_CONFIGURE_REGISTER
    see 6 page of spiûֲ_V0.0.3_2008-07-04_.pdf
    
*/

/* unit length 8bits 16bits 32 bits */
#define AVI_SPI_MDR_UNITLEN     24
#define AVI_SPI_MDR_UNIT_8      0x07
#define AVI_SPI_MDR_UNIT_16     0x0F
#define AVI_SPI_MDR_UNIT_32     0x1F

/* delay clock for cs to clock */
#define AVI_SPI_MDR_CSDLYCLK    16

/* delay clock for read */
#define AVI_SPI_MDR_RDDLYCLK    15

/* CPHA & CPOL */
#define AVI_SPI_MDR_CPHA        14
#define AVI_SPI_MDR_CPOL        13

/* MSB of LSB */
#define AVI_SPI_MDR_LSB         12

/* data packet enable */
#define AVI_SPI_MDR_DATPKEN     10

/* hold enable */
#define AVI_SPI_MDR_HOLDEN      9

/* spi flash mode  */
#define AVI_SPI_MDR_FMODE       8

/* txd delay */
#define AVI_SPI_MDR_TXDDLY      1

/* soft reset */
#define AVI_SPI_MDR_SRST        0

/* register */
struct SPI_MDR_REGISTER
{
	unsigned 				:3;			//[31:29]
	unsigned  unit_length 	:5;			//[28:24]
	unsigned				:4;			//[23:20]
	unsigned clk_dlytime	:4;			//[19:16]
	unsigned 				:1;			//[15]
	unsigned cpha		    :1;			//[14]
	unsigned cpol			:1;			//[13]
	unsigned lsb			:1;			//[12]
	unsigned 				:1;			//[11]
	unsigned datapacket_en  :1;		    //[10]
	unsigned hold_en		:1;			//[9]
	unsigned sflash_mode	:1;			//[8]
	unsigned txd_delay	    :7;			//[7:1]
	unsigned soft_rst		:1;			//[0]
};


/* txdffi level */
#define AVI_SPI_IQR_TXDL        16

/* rxdffi level */
#define AVI_SPI_IQR_RXDL        8

/* copmleteie */
#define AVI_SPI_IQR_COMPLIE     2

/* txdffie */
#define AVI_SPI_IQR_TXDE        1

/* rxdffie */
#define AVI_SPI_IQR_RXDE        0


struct SPI_IQR_REGISTER
{
	unsigned 				:8;			//[31:24]
	unsigned 				:2;			//[23:22]
	unsigned txdffi_level	:6;			//[21:16]
	unsigned 				:2;			//[15:14]
	unsigned rxdffi_level	:6;			//[13:8]
	unsigned 				:4;			//[7:3]
	unsigned copmleteie	    :1;			//[2]
	unsigned txdffie		:1;			//[1]
	unsigned rxdffie		:1;			//[0]
};

#define AVI_SPI_CTR_SPDTRIG         27
#define AVI_SPI_CTR_FFSTEN          26
#define AVI_SPI_CTR_CRCEN           25
#define AVI_SPI_CTR_BMULT           24
#define AVI_SPI_CTR_SLVSEL          8
#define AVI_SPI_CTR_DIRECTION       1
#define AVI_SPI_CTR_TRIGGER         0


struct SPI_CTR_REGISTER
{
	unsigned 				:4;			//[31:28]
	unsigned reg_spd_trig	:1;			//[27]
	unsigned reg_ff_st_en	:1;			//[26]
	unsigned reg_crc_en	    :1;			//[25]
	unsigned reg_bmult	    :1;			//[24]
	unsigned 				:8;			//[23:16]
	unsigned				:4;			//[15:12]
	unsigned slave_sel	    :4;			//[11:8];
	unsigned 				:6;			//[7:2]
	unsigned direction		:1;			//[1]
	unsigned trigger		:1;			//[0]
};

#define AVI_SPI_STR_INTFLAG     20
#define AVI_SPI_STR_INTSTATE    16
#define AVI_SPI_STR_CRCSTATE    14
#define AVI_SPI_STR_CMDBCNT     8
#define AVI_SPI_STR_BUSY        6
#define AVI_SPI_STR_DATACNT     0

struct SPI_STR_REGISTER
{
	unsigned				    :8;			//[31:24]
	unsigned 				    :3;			//[23:21]
	unsigned reg_spi_int_flag   :1;		    //[20]
	unsigned reg_spi_int_state  :4;		    //[19:16]
	unsigned 				    :1;			//[15]
	unsigned reg_crc_check_state:1;	        //[14]
	unsigned cmdb_cnt	        :6;			//[13:8]
	unsigned 				    :1;			//[7]
	unsigned busy		        :1;			//[6]
	unsigned data_cnt	        :6;			//[5:0]	
};

#define	MAX_TRANS	(32)
#define	SPI_IRQ		(47)

#define SPI1TH              (0)   ///һ·SPIƬѡ
#define SPI2TH              (1)	  ///ڶ·SPIƬѡ

#define IOCTL_SPI_NORMAL_SEND           (0)
#define IOCTL_SPI_SEND                  (1)
#define IOCTL_SPI_READ					(2)
#define IOCTL_SPI_DEVCS                 (3)
#define IOCTL_SPI_PACKBITS              (4)
#define IOCTL_SPI_BAND                  (5)
#define IOCTL_SPI_LSB                   (6)
#define IOCTL_SPI_NORMAL_READ           (7)

#define IOCTL_CS(cs)                   ((cs >> 8) & 0xFF)
#define IOCTL_CMD(cmd)                 ((cmd) & 0xFF)

#define SPIDEV_MAJOR			153

#define AVI_SPI_CMDLEN_MASK     0xFF00FFFC

typedef struct _SPI_ATTR_T
{	
    unsigned int *addr;
    unsigned int cmdcnt;
	unsigned int cnt;
} SPI_ATTR_T;

void spi_initialize();
int spi_normal_sendbytes(unsigned spi_cs, unsigned int *tbuf, unsigned int tcnt );
int spi_sendbytes( unsigned char spi_cs, unsigned int *tbuf, unsigned int cmdcnt, unsigned int tcnt );
int spi_normal_readbytes( unsigned char spi_cs, unsigned int *rbuf, unsigned int rcnt );
int spi_readbytes( unsigned char spi_cs, unsigned int *rbuf, unsigned int cmdcnt, unsigned int rcnt );
int spi_read_flash_id( int *mf_id, int *dev_id );

#endif
