/*
 * Memory Setup stuff - taken from ???
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

#include "config.h"
#include "version.h"

SYSCFG_SDRAM:
	.long     0x0FFFF0ba     // 32bit data bus...     (EXTDBWTH)  
	.long     0x0200007F     // 60(SAR Error)  -> ff(SAR OK) wbk 0121  0x0000000 ~ 0x01FFFFF (ROMCON0)
   	.long     0x040083FF     // 0x0200000 ~ 0x03FFFFF (ROMCON1)
   	.long     0x06010040     // 0x0400000 ~ 0x05FFFFF (ROMCON2)
  	.long     0x0c020000     // 0x0800000 ~ 0x0BFFFFF (PCMOFFSET)
	.long     0x18040380     // 0x1000000 ~ 0x17FFFFF (DRAMCON0)
	.long     0x20060380     // 0x1800000 ~ 0x1FFFFFF (DRAMCON1)
	.long     0x0            //	(DRAMCON2)
	.long     0x0            //	(DRAMCON3)
	.long     0xce27E360     // Refresh enable...     (REFEXTCON)

/* some parameters for the board */  
SYSCFG:		.long	0x03FF0000
syscfg_val:	.long	0xA3FF0000

/* setting up the memory */
.globl memsetup
memsetup:
	/* set system config register */
	ldr	r0, SYSCFG
	ldr	r1, syscfg_val
	str	r1, [r0]

	/* ROM and RAM Configuration(Multiple Load and Store).  Multiple load
	 * LDMIA instruction cannot be used as there is no way to load the
	 * address SYSCFG_SDRAM into a register (LDR Rn,=sym is broken)
	 */
    adrl    r0, SYSCFG_SDRAM
    ldmia   r0, {r1-r10}
    ldr     r0, =0x3FF0000 + 0x3010 
    stmia   r0, {r1-r10}   		

	/* everything is fine now */
	mov	pc, lr
