/*
 * (C) Copyright 2000
 * Wolfgang Denk, DENX Software Engineering, wd@denx.de.
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

/*
 * Cache support: switch on or off, get status  choish 20020829
 */
#include <armboot.h>
#include <command.h>


#if (CONFIG_COMMANDS & CFG_CMD_CACHE)

#if defined(CONFIG_S3C2500) || defined(CONFIG_S3C2510)
#define DCACHE_ON (1<<2)	// dcaceh enable choish 20020827
#define ICACHE_ON (1<<12)	// icache enable  choish 20020827

static int on_off (const char *);

// CP15 r1 Resister read function   choish 20020827
static unsigned long
read_cp15r1 (void)
{

  unsigned long		value;/*
#if (0)
  unsigned long		tmp;
#endif

  __asm__
  __volatile__ ("mrc     p15, 0, %0, c1, c0, 0   @ read control reg\n":"=r"
		  (value)::"memory");
  printf ("cp15 register r1: 0x%08lX\n", value);

#if (0)
  __asm__
  __volatile__ ("mrc     p15, 0, %0, c6, c0, 0   @ read control reg\n":"=r"
		  (tmp)::"memory");
  printf ("cp15 register r6: %08lx\n", tmp);

  __asm__
  __volatile__ ("mrc     p15, 0, %0, c6, c1, 0   @ read control reg\n":"=r"
		  (tmp)::"memory");
  printf ("cp15 register r6: %08lx\n", tmp);


  __asm__
  __volatile__ ("mrc     p15, 0, %0, c6, c2, 0   @ read control reg\n":"=r"
		  (tmp)::"memory");
  printf ("cp15 register r6: %08lx\n", tmp);


  __asm__
  __volatile__ ("mrc     p15, 0, %0, c6, c3, 0   @ read control reg\n":"=r"
		  (tmp)::"memory");
  printf ("cp15 register r6: %08lx\n", tmp);
#endif
*/
  return value;

}

void
Cache_init (bd_t * bd)
{
	/*
  const char *is;
  const char *ds;
  is = bd->bi_icache;
  switch (on_off (is))
    {
    case 0:
      _ICache_Flush ();
      _ICache_Disable ();

      break;
    case 1:
      _ICache_Enable ();
      _ICache_Flush ();

      break;
    }
  printf ("Instruction Cache is %s\n", icache_status ()? "ON" : "OFF");

  ds = bd->bi_dcache;
  switch (on_off (ds))
    {
    case 0:
      _DCache_Flush ();
      _DCache_Disable ();
      break;
    case 1:
      _DCache_Enable ();
      _DCache_Flush ();
      break;
    }
  printf ("Data (writethrough) Cache is %s\n",
	  dcache_status ()? "ON" : "OFF");
*/
}

int
icache_status (void)
{
  return (read_cp15r1 () & ICACHE_ON) != 0;
}

int
dcache_status (void)
{
  return (read_cp15r1 () & DCACHE_ON) != 0;
}
#endif //


//add by zxj 2008-08-25
#if defined(CONFIG_CK510)

#define DCACHE_OFF	0
#define DCACHE_ON	1
#define ICACHE_OFF	2
#define ICACHE_ON	3

#define DCACHE_BIT	(1 << 3)
#define ICACHE_BIT	(1 << 2)


unsigned int read_reg_cache(void)
{
	volatile register value;
	
	__asm__ __volatile__
  	(
  	  	"mfcr %0, cr18\n"
		: "=r" (value)
		: "0"(value)
	);
	
	
	return  value;
}

void write_reg_cache(unsigned int value)
{
	volatile register value;
	
	__asm__ __volatile__
  	(
  	  	"mfcr %0, cr18\n"
		: "=r" (value)
		: "0"(value)
	);
	
	switch(value)
	{
		case DCACHE_OFF:
		{
			__asm__ __volatile__
		  	(
		  	  	"bclri %0, 3\n"
				: "=r" (value)
				: "0"(value)
			);
			break;
		}
		case DCACHE_ON:
		{
			__asm__ __volatile__
		  	(
		  	  	"bseti %0, 3\n"
				: "=r" (value)
				: "0"(value)
			);
			break;
		}
		case ICACHE_OFF:
		{
			__asm__ __volatile__
		  	(
		  	  	"bclri %0, 2\n"
				: "=r" (value)
				: "0"(value)
			);	
			break;		
		}
		case ICACHE_ON:
		{
			__asm__ __volatile__
		  	(
		  	  	"bseti %0, 2\n"
				: "=r" (value)
				: "0"(value)
			);	
			break;		
		}
		default:
		{
			return;
		}
	}
	
	__asm__ __volatile__
  	(
  	  	"mtcr %0, cr18\n"
  	  	"mfcr %0, cr17\n"
  	  	"bclri %0, 2\n"
  	  	"bseti %0, 4\n"
		: "=r" (value)
		: "0"(value)
	);
	
	//Fluse I | D Cache
	if( value < ICACHE_OFF )
	{
		//DCACHE
		__asm__ __volatile__
	  	(
	  	  	"bclri %0, 0\n"
	  	  	"bseti %0, 1\n"
			: "=r" (value)
			: "0"(value)
		);
	}
	else
	{
		//ICACHE
		__asm__ __volatile__
	  	(
	  	  	"bseti %0, 0\n"
	  	  	"bclri %0, 1\n"
			: "=r" (value)
			: "0"(value)
		);
	}
	
	//write
	__asm__ __volatile__
  	(
		"mtcr %0, cr17\n"
		: "=r" (value)
		: "0"(value)
	);
}


#endif //CONFIG_S3C2500

static int
on_off (const char *s)
{
  if (strcmp (s, "on") == 0)
    {
      return (1);
    }
  else if (strcmp (s, "off") == 0)
    {
      return (0);
    }
  return (-1);
}

int do_icache (cmd_tbl_t *cmdtp, bd_t *bd, int flag, int argc, char *argv[])
{
	#if defined(CONFIG_CK510)
		unsigned int tmp, onoroff;
	
		if (argc != 2)
	    {
	      printf ("Usage:\n%s\n", cmdtp->usage);
	      return 1;
	    }
	    
		tmp = read_reg_cache();
		if( 0 == (tmp & ICACHE_BIT) )
			tmp = 0;
		else
			tmp = 1;
	
		onoroff = on_off(argv[1]);
		
		if( onoroff == tmp )
			return;
		
		switch(onoroff)
		{
			case 0:
			{
				write_reg_cache(ICACHE_OFF);
				break;
			}
			case 1:
			{
				write_reg_cache(ICACHE_ON);
				break;
			}
			default:
				return;
		}
		
		tmp = read_reg_cache();
		
		printf("cache status = 0x%02lx\n",tmp);
		
	#endif
	
	return 0;

}

int do_dcache (cmd_tbl_t *cmdtp, bd_t *bd, int flag, int argc, char *argv[])
{
	#if defined(CONFIG_CK510)
		unsigned int tmp, onoroff;
	
		if (argc != 2)
	    {
	      printf ("Usage:\n%s\n", cmdtp->usage);
	      return 1;
	    }
	    
		tmp = read_reg_cache();
		if( 0 == (tmp & DCACHE_BIT) )
			tmp = 0;
		else
			tmp = 1;
	
		onoroff = on_off(argv[1]);
		
		if( onoroff == tmp )
			return;
		
		switch(onoroff)
		{
			case 0:
			{
				write_reg_cache(DCACHE_OFF);
				break;
			}
			case 1:
			{
				write_reg_cache(DCACHE_ON);
				break;
			}
			default:
				return;
		}
		
		tmp = read_reg_cache();
		
		printf("cache status = 0x%02lx\n",tmp);
		
	#endif
	
	return 0;
}

#endif	/* CFG_CMD_CACHE */