/*
 * (C) Copyright 2002
 * Jongil Park Samsung Electronics <laminaz@samsung.co.kr>
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

/*
 * Boot support
 */
#include <armboot.h>
#include <command.h>
#include <cmd_boot.h>
#include <cmd_autoscript.h>
#include <s_record.h>
#include <net.h>

#if (CONFIG_COMMANDS & CFG_CMD_CRAMFS)

#include "cramfs/cramfs.h"
// modified by choish
#if defined(CONFIG_S5N8947)
#define FLASH_BASE 		0x1000000
#define APP_OFFSET 		0x0020000
#define UNCOMP_LOC 		0x0040000
#define NON_CACHEABLE		0x4000000
#endif

#if defined(CONFIG_S3C2500) || defined(CONFIG_S3C2510)
#define FLASH_BASE 		0x80000000
#define APP_OFFSET 		0x0020000
#define UNCOMP_LOC 		0x0040000
#define NON_CACHEABLE		0x0
#endif
// chois end
#if 1
static char *buf_cramfs = (void *) FLASH_BASE + NON_CACHEABLE + APP_OFFSET;
static char *buf_out = (void *) UNCOMP_LOC;
#else
static uint *buf_cramfs = (uint *) FLASH_BASE + NON_CACHEABLE + APP_OFFSET;
static uint *buf_out = (uint *) UNCOMP_LOC;
#endif

int
uncompress (char *name)
{
  struct cramfs_super *		super;
  struct cramfs_inode *		p;

  if (!(super = cramfs_get_super (buf_cramfs)))
    {
      printf ("Not a valid filesystem\n");
      return 0;
    }

  p = cramfs_lookup (buf_cramfs, cramfs_get_root (buf_cramfs), name);
  if (!p)
    {
      printf ("file %s not found\n", name);
      return 0;
    }

  if (ISDIR (CRAMFS_16 (p->mode)))
    {
      printf ("%s is a directory\n", name);
      return 0;
    }

  return cramfs_inflate (buf_cramfs, p, buf_out, 0, 0x400000);	/* 4 meg max */
}


int
do_cramfs_fsload (cmd_tbl_t * cmdtp, bd_t * bd, int flag, int argc,
		  char *argv[])
{

  char *filename = "boot/linux.bin";
  unsigned long giFlashAppBaseAddr = 0x80030000;
  ulong offset;

  if (argc < 2)
    {
      buf_cramfs = (void *) giFlashAppBaseAddr;
      if (giFlashAppBaseAddr == 0)
	{
	  buf_cramfs = (void *) FLASH_BASE + NON_CACHEABLE + APP_OFFSET;
	}
      buf_out = (void *) UNCOMP_LOC;
    }

  if (argc == 2)
    {
      buf_out = (char *) simple_strtoul (argv[1], NULL, 16);
    }

  if (argc == 3)
    {
      // destination DRAM
      offset = simple_strtoul (argv[1], NULL, 16);
      buf_out = (char *) offset;

      // Source Flash
      offset = simple_strtoul (argv[2], NULL, 16);
      buf_cramfs = (char *) (offset + NON_CACHEABLE);
    }
  if (argc == 4)
    {
      // destination DRAM
      offset = simple_strtoul (argv[1], NULL, 16);
      buf_out = (char *) offset;

      // Source Flash
      offset = simple_strtoul (argv[2], NULL, 16);
      buf_cramfs = (char *) (offset + NON_CACHEABLE);

      // file name
      filename = argv[3];
    }

  /* new code checks for a valid fs first */
  if (cramfs_get_super (buf_cramfs))
    {
      printf ("Loading ");
      if (uncompress (filename) < 0)
	{
	  printf ("uncompress fail \n");
	  return 1;
	}
      else
	{
	  return 0;
	}
    }
  else
    {
      printf ("Fail: can't get cramfs super block. \n");
      return 2;
    }

  return 1;
}

static int
print_file (void *ptr, char *cwd, struct cramfs_inode *inode)
{
  char buf[128];
  int i;
  unsigned short mode = CRAMFS_16 (inode->mode);

  i = sprintf (buf, "%c%c%c%c %s%s",
	       ISDIR (mode) ? 'd' : '-',
	       ISRD (mode) ? 'r' : '-',
	       ISWR (mode) ? 'w' : '-',
	       ISEX (mode) ? 'x' : '-', cwd, cramfs_get_name (ptr, inode));

  for (; i < 35; i++)
    {
      buf[i] = ' ';
      buf[i + 1] = 0;
    }
  i = sprintf (buf + i + 2, "%s%d", buf, cramfs_get_size (ptr, inode));

  for (; i < 40; i++)
    {
      buf[i] = ' ';
      buf[i + 1] = 0;
    }

  printf ("%s%d\n", buf, cramfs_get_size (ptr, inode));
  return 1;
}

static int
print_directory (void *ptr, char *cwd, struct cramfs_inode *dir)
{
  struct cramfs_inode *p;
  char myname[256];
  unsigned int i = CRAMFS_GET_NAMELEN (dir);

  if (strlen (cwd))
    {
      strcpy (myname, cwd);
      strcat (myname, "/");
    }
  else
    {
      myname[0] = 0;
    }
  myname[strlen (myname) + (i << 2)] = 0;
  strncpy (&myname[strlen (myname)],
	   (void *) dir + sizeof (struct cramfs_inode), (i << 2));
  strcat (myname, "/");

  p = cramfs_readdir_next (ptr, dir, (void *) 0);
  if (!p)
    {
      printf ("total 0\n");
      return 0;
    }
  while (p)
    {
      print_file (ptr, myname, p);
      p = cramfs_readdir_next (ptr, dir, p);
    }
  return 1;
}

int
do_cramfs_ls (cmd_tbl_t * cmdtp, bd_t * bd, int flag, int argc, char *argv[])
{
  struct cramfs_inode *inode;
  unsigned int mode;


  if (!cramfs_get_super (buf_cramfs))
    {
      printf ("Not a valid filesystem\n");
      return 1;
    }

  if (argc < 2)
    {
      inode = cramfs_get_root (buf_cramfs);
    }
  else
    {
      inode =
	cramfs_lookup (buf_cramfs, cramfs_get_root (buf_cramfs), argv[1]);
    }

  if (!inode)
    {
      printf ("ls: file not found\n");
      return 1;
    }

  mode = CRAMFS_16 (inode->mode);
  if (ISDIR (mode))
    {
      print_directory (buf_cramfs, "", inode);
    }
  else
    {
      print_file (buf_cramfs, "", inode);
    }
  return 0;
}



#if 0
int
do_cramfs_fsinfo (cmd_tbl_t * cmdtp, bd_t * bd, int flag, int argc,
		  char *argv[])
{
  struct part_info part;
  int ret;

  get_part_info (&part);
  ret = jffs2_1pass_info (&part);

  return (ret == 1);
}
#endif

#endif /* CFG_CMD_CRAMFS */
