/*
 * (C) Copyright 2000
 * Wolfgang Denk, DENX Software Engineering, wd@denx.de.
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

#include "version.h"
#include "armboot.h"

//#define ARMBOOT_VERSION		"v2.5.0c"
extern ulong _armboot_relocation;
extern ulong _armboot_saddr;
extern ulong _armboot_eaddr;

// modified by choish 
#if defined(CONFIG_S5N8947)
const char version_string[] = ARMBOOT_S5N8947;
#endif

#if defined(CONFIG_S3C2500) || defined(CONFIG_S3C2510)
const char version_string[] = ARMBOOT_S3C2500;
#endif

#if defined(CONFIG_CK510)
const char version_string[] = ARMBOOT_CK510;
#endif
// choish end
void
display_banner (bd_t * bd)
{
//  printf ("\n\n%s\n\n", version_string);

  //printf("\nArmboot version: %s -- %s , %s\n", ARMBOOT_VERSION, __DATE__,__TIME__);
  printf("\nDH5K build %s , %s\n",__DATE__,__TIME__);
#if 0
  printf("Support: 1. Auto detect 32M and 64M sdram\n");
  printf("         2. Clear alarm status\n\n");
#endif

#if (0)
  printf("Compile time: %s %s\r\n", __DATE__, __TIME__);
#endif

  //printf ("Code range : 0x%08lx -> 0x%08lx\n", _armboot_start, _armboot_end);

#ifdef CONFIG_USE_IRQ
  printf ("IRQ Stack: %08lx\n", IRQ_STACK_START);
  printf ("FIQ Stack: %08lx\n", FIQ_STACK_START);
#endif

#if (0)
	display_env_config( &bd );
#endif
}

static void
pretty_print_size (ulong size)
{
  if (size > 0x100000)
    {
      printf ("%ld MB\n", size / 0x100000);
    }
  else
    {
      printf ("%ld KB\n", size / 0x400);
    }
}

void
display_dram_config (bd_t * bd)
{
  int i;

  printf ("DRAM:\n");

  for (i = 0; i < CONFIG_NR_DRAM_BANKS; i++)
    {
      printf ("Bank #%d: %08lx ", i, bd->bi_dram[i].start);
      pretty_print_size (bd->bi_dram[i].size);
      printf ("\n");
    }
}

void
display_flash_config (bd_t * bd, ulong size)
{
	unsigned int manid,devid;
  printf ("Flash: ");
  pretty_print_size (size);
  
  #ifdef CFG_DISPLAY_FLASH_ID
	  flash_ReadID(&manid,&devid);

		printf("Mfr_id = %#x, Dev_id = %#x\n", manid,  devid );
	#endif 

  
}

//add by zxj @2008-05-26 =>display the env addr
void
display_env_config ( bd_t * bd )
{
  printf ("Environment: ");
	printf ("Env addr : 0x%08lx ; Env Size : 0x%08lx\n", CFG_ENV_ADDR, CFG_ENV_SIZE);
}
