//-----------------------------------------------------------------------------
// Description : Log library
// Author      : Jongil Park <laminaz.park@samsung.com>
// Date        : 2002.06.14
// Revision    :
//              [2001.5.21] 
//                         SetLogFileSizeThreahold API was added.
//                         GetLogFileSizeThreshold API was added.
//                         Log file spliting feature was added.
//-----------------------------------------------------------------------------


#include "armboot.h"
#include "log.h"
#include "linux/time.h"
// modified by choish
#if defined(CONFIG_S5N8947)
#include "s5n8947.h"
#endif
#if defined(CONFIG_S3C2500)
#include "s3c2500.h"
#endif
#if defined(CONFIG_S3C2510)
#include "s3c2510.h"
#endif
// choish end
static struct _LOG_INFO stLogInfo[] = {
  {"NODELAY", NODELAY},
  {"CRIT", CRIT},
  {"ERR", ERR},
  {"WARN", WARN},
  {"INFO", INFO},
  {"NOTICE", NOTICE},
  {"DEBUG", DEBUG},
  {"MSG", MSG},
  {"DUMPMSG", DUMPMSG},
  {"SM", SM},			// only for Sate Machine
  {"CALLID", CALLID},
  {"LOCAL1", LOCAL1},
  {"LOCAL2", LOCAL2},
  {"LOCAL3", LOCAL3},
  {"LOCAL4", LOCAL4},
  {"LOCAL5", LOCAL5},
  {"LOCAL6", LOCAL6},
  {"LOCAL7", LOCAL7},
  {"LOCAL8", LOCAL8},
  {"LOCAL9", LOCAL9}
};

static int _nLogLevel;


//-----------------------------------------------------------------------------
// Function : log_init()
// Descript : initialize log libary
// Argument : void
// Return   : 
//                              1 Success, -1 Fail
// Revision :
//-----------------------------------------------------------------------------
int
InitLog (void)
{
  int nLogLevel;
  int nRet;

  nLogLevel = ComputeLogLevel ("NODELAY CRIT ERR WARN INFO NOTICE DEBUG MSG");
  nRet = OpenLog (nLogLevel);
  if (nRet < 0)
    {
      return -1;
    }
  else
    {
      return 1;
    }
}



/*********************************************************
    Procedure : Log()
	Description:
*********************************************************/

int
_Log (int nLevel, char *cFormat, ...)
{
  int i;
  va_list ap;
  char printbuffer[CFG_PBSIZE];
  ulong tNow;
  ulong tData;
  ulong tDiffTime;
  ulong t1msec;
  ulong tTime;
  ulong tHour;
  ulong tMin;
  ulong tSec;
  ulong tMsec;


  if (!(nLevel & _nLogLevel))
    return 1;

  // 1 msec
  REG_READ (TIMER_TCNT_0, tNow);
  REG_READ (TIMER_TDATA_0, tData);

  tDiffTime = tData - tNow;
  t1msec = 1 / 1000;
  t1msec *= CFG_HZ;

  tTime = tDiffTime / t1msec;

  tHour = tTime / 60 * 60 * 100;
  tMin = (tTime / 60 * 100) % 60;
  tSec = (tTime / 100) % (60 * 60);
  tMsec = tTime % 100;
//      printf("[%ld:%ld:%ld.%ld] ", tHour, tMin, tSec, tMsec);

  va_start (ap, cFormat);
  i = vsprintf (printbuffer, cFormat, ap);
  va_end (ap);

  puts (printbuffer);
  return 1;
}

/*********************************************************
    Procedure : OpenLog()
	Description:
*********************************************************/

int
OpenLog (int nLogLevel)
{
  _nLogLevel = nLogLevel;

  return 1;
}

/*********************************************************
    Procedure : ComputeLogLevel()
	Description:
*********************************************************/

int
ComputeLogLevel (char *szLevelString)
{
  int i, j;

  for (i = 0, j = 0; i < NUM_OF_LOGLEVEL; i++)
    {
      if (strstr (szLevelString, stLogInfo[i].szLevelName))
	{
	  j |= stLogInfo[i].nLevelValue;
	}
    }

  return j;
}
