/*
 * [2001.5.21] 
 * SetLogFileSizeThreahold API was added.
 * GetLogFileSizeThreshold API was added.
 * Log file spliting feature was added.
 */



#include "log.h"

#define MAX_SPLIT_NUM 	7
#define MAX_PATH		256

static struct _LOG_INFO stLogInfo[] = {
	{"NODELAY", 	NODELAY},
	{"CRIT", 		CRIT},
	{"ERR", 		ERR},
	{"WARN", 		WARN},
	{"INFO", 		INFO},
	{"NOTICE", 		NOTICE},
	{"DEBUG", 		DEBUG},
	{"MSG", 		MSG},
	{"DUMPMSG", 	DUMPMSG},
	{"SM", 			SM},			// only for Sate Machine
	{"CALLID", 		CALLID},
	{"LOCAL1", 		LOCAL1},
	{"LOCAL2", 		LOCAL2},
	{"LOCAL3", 		LOCAL3},
	{"LOCAL4", 		LOCAL4},
	{"LOCAL5", 		LOCAL5},
	{"LOCAL6", 		LOCAL6},
	{"LOCAL7", 		LOCAL7},
	{"LOCAL8", 		LOCAL8},
	{"LOCAL9", 		LOCAL9}
};

static const char *_szWeekOfDay[] = {"sun","mon","tue","wed","thu","fri","sat"};

static char		_szLogFileName[MAX_PATH];
static char 	_szFileName[MAX_PATH];
static int		_current_yday;
static int		_nLogLevel;
static FILE		*_log_fp;
static int		_split_count;
/*
 * default file size thrshold
 */
static int		_nSize = 1024*1024*100; /* 100M */


/*********************************************************
    Procedure : GetCurrentLogLevel()
	Description: returns the current log level.
*********************************************************/

int
GetCurrentLogLevel ()
{
	return _nLogLevel;
}

/*********************************************************
    Procedure : SetCurrentLogLevel()
	Description: update the current log level and returns
		the previous log level.
*********************************************************/

int
SetCurrentLogLevel (int nLogLevel)
{
	int nOldLogLevel;

	nOldLogLevel = _nLogLevel;
	_nLogLevel 	 = nLogLevel;

	return nOldLogLevel;
}

/*********************************************************
    Procedure : SetFileSizeThreshold()
	Description: 
*********************************************************/

int
SetLogFileSizeThreshold (int nSize)
{
	int nOldSize;

	if (nSize <= 0) 
		return -1;

	nOldSize 	= _nSize / (1024 * 1024);
	_nSize 	 	= nSize * (1024 * 1024);

	return nOldSize;
}

/*********************************************************
    Procedure : GetFileSizeThreshold()
	Description: 
*********************************************************/

int
GetLogFileSizeThreshold ()
{
	return (_nSize / (1024 * 1024));
}

/*********************************************************
    Procedure : Log()
	Description:
*********************************************************/

int
_Log (int nLevel, char *cFormat,...)
{
	int 		i;
	va_list 	ap;
	time_t 		clock;
	struct tm 	*c_tm, c_tm_org;
	struct stat stat_buf;

	char tmpfilename[MAX_PATH];


	if(!(nLevel & _nLogLevel)) return 1;

	time (&clock);
	c_tm  = localtime (&clock);

	if (_current_yday != c_tm->tm_yday) {
		struct stat stat_buf;
		struct tm 	*tmp;

		/*
		 * initialize split count to zero.
		 */
		_split_count = 0;

		/*
		 * <<< The bug reported by thhur. 12/26/2000 >>>
		 * the next localtime function changes tm structure that 
		 * library keeps. Therefore, the current time must be saved
		 * for backup. 
		 */

		c_tm_org = *c_tm;

		_current_yday = c_tm->tm_yday;

		fprintf (_log_fp, "\nLog Lotation Occurred\n");
		fflush (_log_fp);
		fclose (_log_fp);

		sprintf (_szFileName, "%s.%s", _szLogFileName, _szWeekOfDay[c_tm->tm_wday]);

		/*
		 * remove all splited log files.
		 */
		for (i = 1; i <= MAX_SPLIT_NUM; i++) {
			sprintf (tmpfilename, "%s.%d", _szFileName, i);
			if (access (tmpfilename, F_OK) == 0) {
				remove (tmpfilename);
			}
		}

		if (stat (_szFileName, &stat_buf) == 0) {
			tmp = localtime (&stat_buf.st_mtime);

			if (tmp->tm_yday == _current_yday)
				_log_fp  = fopen (_szFileName, "a");
			else {
				_log_fp  = fopen (_szFileName, "w");
			}

		} 
		else 
		{
			_log_fp  = fopen (_szFileName, "w");
		}

		c_tm = &c_tm_org;

		if (_log_fp == NULL) 
		{
			return -1;
		}
	}

	if (access (_szFileName, W_OK) == -1) {
		fclose (_log_fp);
		_log_fp = fopen (_szFileName, "w");
		if (_log_fp == NULL) {
			return -1;
		}
	}

	if (stat (_szFileName, &stat_buf) == 0) {
		if (stat_buf.st_size > _nSize) {

			if (_split_count >= MAX_SPLIT_NUM) {
				_split_count = 0;
			}

			_split_count++;
			sprintf (tmpfilename, "%s.%d", _szFileName, _split_count);

			fprintf (_log_fp, "\nLog Split Occurred (%s)\n", tmpfilename);
			fflush (_log_fp);
			fclose (_log_fp);

			rename (_szFileName, tmpfilename);

			_log_fp  = fopen (_szFileName, "w");
		}
	}

	fprintf (_log_fp, "[%02d/%02d %02d:%02d:%02d] ", 
		c_tm->tm_mon+1, c_tm->tm_mday, 
		c_tm->tm_hour, c_tm->tm_min, 
		c_tm->tm_sec);

	va_start (ap, cFormat);
	vfprintf (_log_fp, cFormat, ap);
	va_end (ap);

	if (_nLogLevel & NODELAY)
		fflush (_log_fp);

	return 1;
}

/*********************************************************
    Procedure : OpenLog()
	Description:
*********************************************************/

int
OpenLog (char *szLogFileName, int nLogLevel)
{
	time_t 		clock;
	struct tm 	*c_tm, *tmp;
	struct stat stat_buf;

	clock = time (0);
	c_tm  = localtime (&clock);

	_current_yday = c_tm->tm_yday;

	strcpy (_szLogFileName, szLogFileName);

	sprintf (_szFileName, "%s.%s", _szLogFileName, _szWeekOfDay[c_tm->tm_wday]);

	if (stat (_szFileName, &stat_buf) == 0) {
		tmp = localtime (&(stat_buf.st_mtime));

		if (tmp->tm_yday == _current_yday) {
			_log_fp  = fopen (_szFileName, "a");
		} else {
			_log_fp  = fopen (_szFileName, "w");
		}

	} else {
		_log_fp  = fopen (_szFileName, "w");
	}

	if (_log_fp == NULL) {
		return -1;
	}

	_nLogLevel = nLogLevel;

	return 1;
}

/*********************************************************
    Procedure : CloseLog()
	Description:
*********************************************************/

void CloseLog ()
{
	fflush (_log_fp);
	fclose (_log_fp);
}

#define DUMP_COLUMN_WIDTH			16

/*********************************************************
    Procedure : DumpData()
	Description:
*********************************************************/

int DumpData (int nLevel, char *cData, int nLenth)
{
	int		i, column;
	char	ascii_buf[128], *ptrT;

	if(!(nLevel & _nLogLevel)) return 1;

	ptrT = (char *)cData;

	for (i = 0; i < nLenth; i++) {
		column = i % DUMP_COLUMN_WIDTH;

		/* print the number of low before the first columm */
		if (column == 0) {
			fprintf (_log_fp, "0x%04X | ", i);
		}

		/* print hexa code value */
		fprintf (_log_fp, "%02X ", (unsigned char)ptrT[i] & 0xFF);

		/* gether ascii value */
		if(ptrT[i] == 0)
			ascii_buf[column] = '.';
		else {
			ascii_buf[column] = isprint((int)ptrT[i]) ? ptrT[i] : '_';
		}

		/* print ascii value */
		if (column==(DUMP_COLUMN_WIDTH-1)) {
			ascii_buf[column+1] = 0;
			fprintf (_log_fp, "| %s\n", ascii_buf);
		} else if (i == (nLenth-1)) {
			ascii_buf[column+1] = 0;
			fprintf (_log_fp, "%*s| ", 3*(DUMP_COLUMN_WIDTH-column-1), "");
			fprintf (_log_fp, "%s\n", ascii_buf);
		}
	}

	if (_nLogLevel & NODELAY)
		fflush (_log_fp);

	return 1;
}

/*********************************************************
    Procedure : LogProcessInfo()
	Description:
*********************************************************/

int LogProcessInfo()
{
	time_t 		clock;
	struct tm 	*c_tm, c_tm_org;

	time (&clock);
	c_tm  = localtime (&clock);

	if (_current_yday != c_tm->tm_yday) {
		struct stat stat_buf;
		struct tm 	*tmp;

		c_tm_org = *c_tm;

		_current_yday = c_tm->tm_yday;

		fprintf (_log_fp, "\nLog Lotation Occurred\n");
		fflush (_log_fp);
		fclose (_log_fp);

		sprintf (_szFileName, "%s.%s", _szLogFileName, _szWeekOfDay[c_tm->tm_wday]);
		if (stat (_szFileName, &stat_buf) == 0) {
			tmp = localtime (&stat_buf.st_mtime);

			if (tmp->tm_yday == _current_yday)
				_log_fp  = fopen (_szFileName, "a");
			else {
				_log_fp  = fopen (_szFileName, "w");
			}

		} else {
			_log_fp  = fopen (_szFileName, "w");
		}

		c_tm = &c_tm_org;

		if (_log_fp == NULL) {
			return -1;
		}
	}

	if (access (_szFileName, W_OK) == -1) {
		fclose (_log_fp);
		_log_fp = fopen (_szFileName, "w");
		if (_log_fp == NULL) {
			return -1;
		}
	}

	fprintf (_log_fp, "[%02d/%02d %02d:%02d:%02d] ", 
		c_tm->tm_mon+1, c_tm->tm_mday, 
		c_tm->tm_hour, c_tm->tm_min, 
		c_tm->tm_sec);

	fprintf (_log_fp, "Process [%s] PID [%d] PPID [%d] UID [%d] EUID [%d]\n", 
		getexecname(), (int)getpid(), (int)getppid(), (int)getuid(), (int)geteuid());

	fflush (_log_fp);

	return 1;

}

/*********************************************************
    Procedure : ComputeLogLevel()
	Description:
*********************************************************/

int
ComputeLogLevel(char *szLevelString)
{
	int i, j;

	for (i = 0, j = 0; i < NUM_OF_LOGLEVEL; i++) {
		if (strstr (szLevelString, stLogInfo[i].szLevelName)) {
			j |= stLogInfo[i].nLevelValue;
		}
	}

	return j;
}

/*********************************************************
    Procedure : ComputeLogLevel2()
	Description:
*********************************************************/
int
ComputeLogLevel2(char *szLevelString[])
{
	int i, j, k;

	for (i = 0, j = 0; szLevelString[i] != NULL ; i++) {
		for (k = 0; k < NUM_OF_LOGLEVEL; k++) {
			if (!strcmp (szLevelString[i], stLogInfo[k].szLevelName)) {
				j |= stLogInfo[k].nLevelValue;
			}
		}
	}

	return j;
}
