/*
 * (C) Copyright 2000
 * Wolfgang Denk, DENX Software Engineering, wd@denx.de.
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

#include <armboot.h>
#include <command.h>
#include <cmd_nvedit.h>
#include <cmd_bootm.h>
#include "hdcvi_upgrade.h"

static char *delete_char (char *buffer, char *p, int *colp, int *np,
			  int plen);
static int parse_line (char *, char *[]);
#if (CONFIG_BOOTDELAY >= 0)
static int abortboot (bd_t *, int);
#endif
#undef DEBUG_PARSER

char console_buffer[CFG_CBSIZE];	/* console I/O buffer   */

static char erase_seq[] = "\b \b";	/* erase sequence       */
static char tab_seq[] = "        ";	/* used to expand TABs  */

#ifdef CONFIG_BOOT_RETRY_TIME
static uint64_t endtime = 0;	/* must be set, default is instant timeout */
static int retry_time = -1;	/* -1 so can call readline before main_loop */
#endif

#define	endtick(seconds) (get_ticks() + (uint64_t)(seconds) * get_tbclk())

#ifndef CONFIG_BOOT_RETRY_MIN
#define CONFIG_BOOT_RETRY_MIN CONFIG_BOOT_RETRY_TIME
#endif


/***************************************************************************
 * Watch for 'delay' seconds for autoboot stop or autoboot delay string.
 * returns: 0 -  no key string, allow autoboot
 *          1 - got key string, abort
 */
#if (CONFIG_BOOTDELAY >= 0)
# if defined(CONFIG_AUTOBOOT_KEYED)
static __inline__ int
abortboot (bd_t * bd, int bootdelay)
{
  int abort = 0;
  char ch;
  uint64_t etime = endtick (bootdelay);
  char *delaykey = getenv (bd, "bootdelaykey");
  char *delaymatch;
  char *stopkey = getenv (bd, "bootstopkey");
  char *stopmatch;

#  ifdef CONFIG_AUTOBOOT_PROMPT
  printf (CONFIG_AUTOBOOT_PROMPT, bootdelay);
#  endif

#  ifdef CONFIG_AUTOBOOT_DELAY_STR
  if (delaykey == NULL)
    delaykey = CONFIG_AUTOBOOT_DELAY_STR;
#  endif
#  ifdef CONFIG_AUTOBOOT_STOP_STR
  if (stopkey == NULL)
    stopkey = CONFIG_AUTOBOOT_STOP_STR;
#  endif

#  if DEBUG_BOOTKEYS
  printf ("delay key:<%s>\n", delaykey ? delaykey : "NULL");
  printf ("stop key:<%s>\n", stopkey ? stopkey : "NULL");
#  endif
  delaymatch = delaykey;
  stopmatch = stopkey;

  /* In order to keep up with incoming data, check timeout only
   * when catch up.
   */
  while (!abort && get_ticks () <= etime)
    {
      /* abort if matched all of one of the keys */
      if (delaymatch && !*delaymatch)
	{
#  if DEBUG_BOOTKEYS
	  printf ("got delaykey\n");
#  endif
	  abort = 1;
	}
      if (stopmatch && !*stopmatch)
	{
#  if DEBUG_BOOTKEYS
	  printf ("got stopkey\n");
#  endif
#  ifdef CONFIG_BOOT_RETRY_TIME
	  /* don't retry auto boot */
	  retry_time = -1;
#  endif
	  abort = 1;
	}
      if (tstc ())
	{
	  ch = getc ();		/* get the incoming char */

	  if (stopmatch)
	    {
	      if (*stopmatch != ch)
		stopmatch = stopkey;	/* start over */
	      if (*stopmatch == ch)
		++stopmatch;	/* matched 1 more */
	    }

	  if (delaymatch)
	    {
	      if (*delaymatch != ch)
		delaymatch = delaykey;	/* start over */
	      if (*delaymatch == ch)
		++delaymatch;	/* matched 1 more */
	    }
	}
    }
#  if DEBUG_BOOTKEYS
  if (!abort)
    printf ("key timeout\n");
#  endif

  return abort;
}

# else /* !defined(CONFIG_AUTOBOOT_KEYED) */

static __inline__ int
abortboot (bd_t * bd, int bootdelay)
{
	int abort = 0;
	/*husj fix, must add *, stop any key hit*/
	char c;
	int count = 0;//ͳ*ŵĴ

#ifdef CONFIG_MENUPROMPT
	printf(CONFIG_MENUPROMPT);
#else

    /*鵽һ*ͼȴ
      *ûа߰µĲ*ֱִ
      */
           
    if (tstc()) {
        c = getc();
        if(c != '*')
        {
            goto startUpgrade;
        }
    }
    else
    {
        goto startUpgrade;
    }

	#ifdef CONFIG_IPNC_BOOT
		printf("Hit *** key to stop autoboot: %2d ", bootdelay);
	#else
		printf("Hit any key to stop autoboot: %2d ", bootdelay);
	#endif
#endif


	while ((bootdelay > 0) && (!abort)) {
		int i;

		--bootdelay;
		/* delay 100 * 10ms */
		for (i=0; !abort && i<100; ++i) {
			if (tstc()) {	/* we got a key press	*/
    			c = getc();
				if(c == '*')
				{
					count++;
					if(count == 2)
					{
						abort = 1;
                        
                        hdcvi_disable_wdt();
                        
                        update_flag_clear( );
                        
						bootdelay = 0;
						break;
					}

				}
				else
				{
					count = 0;
				}
			}
			udelay(10000);
		}

		printf("\b\b\b%2d ", bootdelay);
	}

	putc('\n');
	
startUpgrade:

#ifdef CONFIG_SILENT_CONSOLE
	if (abort)
		gd->flags &= ~GD_FLG_SILENT;
#endif

#ifdef UBOOT_UPDATE
	/**ַʱͲԶ*/
	if (abort == 0) {
		if(NetLoop(UPDATE) < 0) {
			//printf("==>use default images\n");
		} else {
			UpdaterRunCommand();
		}
	}
#endif

#ifdef UBOOT_TFTP_UPGRADE
    if (abort == 0) {
		TftpUpgrade();
	}
#endif

#ifdef UBOOT_USB_UPDATE
    if(abort == 0)
    {
        if(USB_init())
        {
            init_usb_pll();
            USB_download((void *)CONFIG_SYS_LOAD_ADDR, 0, USB_FLAG_MEMORY);
        }
    }
#endif

//#ifdef UBOOT_HDCVI_UPDATE

        if(abort == 0)
        {
            hdcvi_upgrade(); 
        }
//#endif


	return abort;
}
# endif	/* CONFIG_AUTOBOOT_KEYED */
#endif /* CONFIG_BOOTDELAY >= 0  */

/****************************************************************************/

void
main_loop (bd_t * bd)
{
  static char lastcommand[CFG_CBSIZE] = { 0, };
  int len;
  int rc = 1;
  int flag = 0x0;

#if (CONFIG_BOOTDELAY >= 0)
  char *s;
  char *jf;
  int bootdelay;
#endif
#ifdef CONFIG_PREBOOT
  char *p;
#endif

  extern int AlarmInit(void);

  AlarmInit();

#if (TIMYU || 0)
	*((uchar *) 0xF003001F) = (*((uchar *) 0xF003001F) & 0xF0);
	printf("Set ide RESET signal is low\n");
#endif

#ifdef CONFIG_PREBOOT
  if ((p = getenv ("preboot")) != NULL)
    {
# ifdef CONFIG_AUTOBOOT_KEYED
      int prev = disable_ctrlc (1);	/* disable Control C checking */
# endif
      run_command (p, bd, 0);
# ifdef CONFIG_AUTOBOOT_KEYED
      disable_ctrlc (prev);	/* restore Control C checking */
# endif
    }
#endif /* CONFIG_PREBOOT */

#if (CONFIG_BOOTDELAY >= 0)
  s = getenv (bd, "bootdelay");
  bootdelay = s ? (int) simple_strtol (s, NULL, 10) : 0;
    

#if 0
  printf ("### main_loop entered:\n\n");
#endif

# ifdef CONFIG_BOOT_RETRY_TIME
  s = getenv (bd, "bootretry");
  if (s != NULL)
    retry_time = (int) simple_strtoul (s, NULL, 10);
  else
    retry_time = CONFIG_BOOT_RETRY_TIME;
  if (retry_time >= 0 && retry_time < CONFIG_BOOT_RETRY_MIN)
    retry_time = CONFIG_BOOT_RETRY_MIN;
# endif	/* CONFIG_BOOT_RETRY_TIME */

	//add by zxj 20080818 for write mac bus length
	//*(unsigned int *)(0x80000000) = 0xfe000880;

  s = getenv (bd, "bootcmd");
  if (bootdelay >= 0 && s && !abortboot (bd, bootdelay))
    {

#if (TIMYU || 1)
     jf = getenv(bd, "mtdfix");
     if (jf[0] == '1')
	{
	 printf("================= erase jffs2\n");
	 setenv(bd, "mtdfix", "0");
	 run_command("saveenv", bd, 0);
	 run_command("erase 1:119-134", bd, 0);
	}
#endif

# ifdef CONFIG_AUTOBOOT_KEYED
      int prev = disable_ctrlc (1);	/* disable Control C checking */
# endif
      run_command (s, bd, 0);
# ifdef CONFIG_AUTOBOOT_KEYED
      disable_ctrlc (prev);	/* restore Control C checking */
# endif
    }
#endif /* CONFIG_BOOTDELAY */


  /*
   * Main Loop for Monitor Command Processing
   */
  for (;;)
    {
#ifdef CONFIG_BOOT_RETRY_TIME
      if (rc >= 0)
	{
	  /* Saw enough of a valid command to
	   * restart the timeout.
	   */
	  reset_cmd_timeout ();
	}
#endif
      len = readline (CFG_PROMPT);

      /* assume no special flags for now */
      flag = 0;
      if (len > 0)
	{
	  strcpy (lastcommand, console_buffer);
	}
      else if (len == 0)
	{
	  //      flag |= CMD_FLAG_REPEAT;
	  lastcommand[0] = 0;
	}
#ifdef CONFIG_BOOT_RETRY_TIME
      else if (len == -2)
	{
	  /* -2 means timed out, retry autoboot
	   */
	  printf ("\nTimed out waiting for command\n");
	  return;		/* retry autoboot */
	}
#endif

      if (len == -1)
	{
	  printf ("<INTERRUPT>\n");
	}
      else
	{
	  rc = run_command (lastcommand, bd, flag);
	}

      if (rc <= 0)
	{
	  /* invalid command or not repeatable, forget it */
	  lastcommand[0] = 0;
	}
    }
}

/***************************************************************************
 * reset command line timeout to retry_time seconds
 */
#ifdef CONFIG_BOOT_RETRY_TIME
void
reset_cmd_timeout (void)
{
  endtime = endtick (retry_time);
}
#endif

/****************************************************************************/

/*
 * Prompt for input and read a line.
 * If  CONFIG_BOOT_RETRY_TIME is defined and retry_time >= 0,
 * time out when time goes past endtime (timebase time in ticks).
 * Return:	number of read characters
 *		-1 if break
 *		-2 if timed out
 */
int
readline (const char *const prompt)
{
  char *p = console_buffer;
  int n = 0;			/* buffer index         */
  int plen = strlen (prompt);	/* prompt length        */
  int col;			/* output column cnt    */
  char c;

  /* print prompt */
  if (prompt)
    puts (prompt);
  col = plen;

  for (;;)
    {
#ifdef CONFIG_BOOT_RETRY_TIME
      while (!tstc ())
	{			/* while no incoming data */
	  if (retry_time >= 0 && get_ticks () > endtime)
	    return (-2);	/* timed out */
	}
#endif
      c = getc ();

      /*
       * Special character handling
       */
      switch (c)
	{
	case '\r':		/* Enter                */
	case '\n':
	  *p = '\0';
	  puts ("\r\n");
	  return (p - console_buffer);

	case 0x03:		/* ^C - break           */
	  console_buffer[0] = '\0';	/* discard input */
	  return (-1);

	case 0x15:		/* ^U - erase line      */
	  while (col > plen)
	    {
	      puts (erase_seq);
	      --col;
	    }
	  p = console_buffer;
	  n = 0;
	  continue;

	case 0x17:		/* ^W - erase word      */
	  p = delete_char (console_buffer, p, &col, &n, plen);
	  while ((n > 0) && (*p != ' '))
	    {
	      p = delete_char (console_buffer, p, &col, &n, plen);
	    }
	  continue;

	case 0x08:		/* ^H  - backspace      */
	case 0x7F:		/* DEL - backspace      */
	  p = delete_char (console_buffer, p, &col, &n, plen);
	  continue;

	default:
	  /*
	   * Must be a normal character then
	   */
	  if (n < CFG_CBSIZE - 2)
	    {
	      if (c == '\t')
		{		/* expand TABs          */
		  puts (tab_seq + (col & 07));
		  col += 8 - (col & 07);
		}
	      else
		{
		  ++col;	/* echo input           */
		  putc (c);
		}
	      *p++ = c;
	      ++n;
	    }
	  else
	    {			/* Buffer full          */
	      putc ('\a');
	    }
	}
    }
}

/****************************************************************************/

static char *
delete_char (char *buffer, char *p, int *colp, int *np, int plen)
{
  char *s;

  if (*np == 0)
    {
      return (p);
    }

  if (*(--p) == '\t')
    {				/* will retype the whole line   */
      while (*colp > plen)
	{
	  puts (erase_seq);
	  (*colp)--;
	}
      for (s = buffer; s < p; ++s)
	{
	  if (*s == '\t')
	    {
	      puts (tab_seq + ((*colp) & 07));
	      *colp += 8 - ((*colp) & 07);
	    }
	  else
	    {
	      ++(*colp);
	      putc (*s);
	    }
	}
    }
  else
    {
      puts (erase_seq);
      (*colp)--;
    }
  (*np)--;
  return (p);
}

/****************************************************************************/

int
parse_line (char *line, char *argv[])
{
  int nargs = 0;

#ifdef DEBUG_PARSER
  printf ("parse_line: \"%s\"\n", line);
#endif
  while (nargs < CFG_MAXARGS)
    {

      /* skip any white space */
      while ((*line == ' ') || (*line == '\t'))
	{
	  ++line;
	}

      if (*line == '\0')
	{			/* end of line, no more args    */
	  argv[nargs] = NULL;
#ifdef DEBUG_PARSER
	  printf ("parse_line: nargs=%d\n", nargs);
#endif
	  return (nargs);
	}

      argv[nargs++] = line;	/* begin of argument string     */

      /* find end of string */
      while (*line && (*line != ' ') && (*line != '\t'))
	{
	  ++line;
	}

      if (*line == '\0')
	{			/* end of line, no more args    */
	  argv[nargs] = NULL;
#ifdef DEBUG_PARSER
	  printf ("parse_line: nargs=%d\n", nargs);
#endif
	  return (nargs);
	}

      *line++ = '\0';		/* terminate current arg         */
    }

  printf ("** Too many args (max. %d) **\n", CFG_MAXARGS);

#ifdef DEBUG_PARSER
  printf ("parse_line: nargs=%d\n", nargs);
#endif
  return (nargs);
}

/****************************************************************************/

static void
process_macros (bd_t * bd, const char *input, char *output)
{
  char c, prev;
  const char *varname_start = 0;
  int inputcnt = strlen (input);
  int outputcnt = CFG_CBSIZE;
  int state = 0;		/* 0 = waiting for '$'  */
  /* 1 = waiting for '('  */
  /* 2 = waiting for ')'  */

#ifdef DEBUG_PARSER
  char *output_start = output;

  printf ("[PROCESS_MACROS] INPUT len %d: \"%s\"\n", strlen (input), input);
#endif

  prev = '\0';			/* previous character   */

  while (inputcnt && outputcnt)
    {
      c = *input++;
      inputcnt--;

      /* remove one level of escape characters */
      if ((c == '\\') && (prev != '\\'))
	{
	  if (inputcnt-- == 0)
	    break;
	  prev = c;
	  c = *input++;
	}

      switch (state)
	{
	case 0:		/* Waiting for (unescaped) $    */
	  if ((c == '$') && (prev != '\\'))
	    {
	      state++;
	    }
	  else
	    {
	      *(output++) = c;
	      outputcnt--;
	    }
	  break;
	case 1:		/* Waiting for (        */
	  if (c == '(')
	    {
	      state++;
	      varname_start = input;
	    }
	  else
	    {
	      state = 0;
	      *(output++) = '$';
	      outputcnt--;

	      if (outputcnt)
		{
		  *(output++) = c;
		  outputcnt--;
		}
	    }
	  break;
	case 2:		/* Waiting for )        */
	  if (c == ')')
	    {
	      int i;
	      char envname[CFG_CBSIZE], *envval;
	      int envcnt = input - varname_start - 1;	/* Varname # of chars */

	      /* Get the varname */
	      for (i = 0; i < envcnt; i++)
		{
		  envname[i] = varname_start[i];
		}
	      envname[i] = 0;

	      /* Get its value */
	      envval = getenv (bd, envname);

	      /* Copy into the line if it exists */
	      if (envval != NULL)
		while ((*envval) && outputcnt)
		  {
		    *(output++) = *(envval++);
		    outputcnt--;
		  }
	      /* Look for another '$' */
	      state = 0;
	    }
	  break;
	}

      prev = c;
    }

  if (outputcnt)
    *output = 0;

#ifdef DEBUG_PARSER
  printf ("[PROCESS_MACROS] OUTPUT len %d: \"%s\"\n",
	  strlen (output_start), output_start);
#endif
}

/****************************************************************************
 * returns:
 *	1  - command executed, repeatable
 *	0  - command executed but not repeatable, interrupted commands are
 *	     always considered not repeatable
 *	-1 - not executed (unrecognized, bootd recursion or too many args)
 *           (If cmd is NULL or "" or longer than CFG_CBSIZE-1 it is
 *           considered unrecognized)
 *
 * WARNING:
 *
 * We must create a temporary copy of the command since the command we get
 * may be the result from getenv(), which returns a pointer directly to
 * the environment data, which may change magicly when the command we run
 * creates or modifies environment variables (like "bootp" does).
 */
int
run_command (const char *cmd, bd_t * bd, int flag)
{
  cmd_tbl_t *cmdtp;
  char cmdbuf[CFG_CBSIZE];	/* working copy of cmd          */
  char *token;			/* start of token in cmdbuf     */
  char *sep;			/* end of token (separator) in cmdbuf */
  char finaltoken[CFG_CBSIZE];
  char *str = cmdbuf;
  char *argv[CFG_MAXARGS + 1];	/* NULL terminated      */
  int argc;
  int repeatable = 1;

#ifdef DEBUG_PARSER
  printf ("[RUN_COMMAND] cmd[%p]=\"%s\"\n", cmd, cmd ? cmd : "NULL");
#endif

  clear_ctrlc ();		/* forget any previous Control C */

  if (!cmd || !*cmd || strlen (cmd) > CFG_CBSIZE - 1)
    return -1;			/* empty command or too long, do nothing */

  strcpy (cmdbuf, cmd);

  /* Process separators and check for invalid
   * repeatable commands
   */

#ifdef DEBUG_PARSER
  printf ("[PROCESS_SEPARATORS] %s\n", cmd);
#endif
  while (*str)
    {

      /*
       * Find separator, or string end
       * Allow simple escape of ';' by writing "\;"
       */
      for (sep = str; *sep; sep++)
	{
	  if ((*sep == ';') &&	/* separator            */
	      (sep != str) &&	/* past string start    */
	      (*(sep - 1) != '\\'))	/* and NOT escaped      */
	    break;
	}

      /*
       * Limit the token to data between separators
       */
      token = str;
      if (*sep)
	{
	  str = sep + 1;	/* start of command for next pass */
	  *sep = '\0';
	}
      else
	str = sep;		/* no more commands for next pass */
#ifdef DEBUG_PARSER
      printf ("token: \"%s\"\n", token);
#endif

      /* find macros in this token and replace them */
      process_macros (bd, token, finaltoken);

      /* Extract arguments */
      argc = parse_line (finaltoken, argv);

      /* Look up command in command table */
      if ((cmdtp = find_cmd (argv[0])) == NULL)
	{
	  printf ("Unknown command '%s' - try 'help'\n", argv[0]);
	  return -1;		/* give up after bad command */
	}

      /* found - check max args */
      if (argc > cmdtp->maxargs)
	{
	  printf ("Usage:\n%s\n", cmdtp->usage);
	  return -1;
	}

#if (CONFIG_COMMANDS & CFG_CMD_BOOTD)
      /* avoid "bootd" recursion */
      if (cmdtp->cmd == do_bootd)
	{
#ifdef DEBUG_PARSER
	  printf ("[%s]\n", finaltoken);
#endif
	  if (flag & CMD_FLAG_BOOTD)
	    {
	      printf ("'bootd' recursion detected\n");
	      return -1;
	    }
	  else
	    {
	      flag |= CMD_FLAG_BOOTD;
	    }
	}
#endif /* CFG_CMD_BOOTD */
#if 0
      _Log (DEBUG, "argc[%d],argv=", argc);
      for (i = 0; i < argc; i++)
	_Log (DEBUG, "%s ", argv[i]);
      printf ("\n");
#endif

      /* OK - call function to do the command */
      (cmdtp->cmd) (cmdtp, bd, flag, argc, argv);

      repeatable &= cmdtp->repeatable;

      /* Did the user stop this? */
      if (had_ctrlc ())
	return 0;		/* if stopped then not repeatable */
    }

  return repeatable;
}

/****************************************************************************/

#if (CONFIG_COMMANDS & CFG_CMD_RUN)
int
do_run (cmd_tbl_t * cmdtp, bd_t * bd, int flag, int argc, char *argv[])
{
  int i;
  int rc = 0;

  if (argc < 2)
    {
      printf ("Usage:\n%s\n", cmdtp->usage);
      return 1;
    }

  for (i = 1; rc == 0 && i < argc; ++i)
    {
      rc = run_command (getenv (bd, argv[i]), bd, flag);
    }

  return rc;
}
#endif
