/*******************************************************************************
* upgrade_hdcvi.c
*
* Copyright (C) 2014-2020 ZheJiang Dahua Technology CO.,LTD.
*
* Author : xia junming <xia_junming@dahuatech.com>
* Version: Ver1.0.00  2014-05-22 Create
*
* Desc: ʹDH9801оƬݣ<ǰ豸Э>豸
*
*       1.  Ӳ˵ 
*           
*       2.  ṹ˵
*
*                    ͼ1: hdcviЭ
*
* A                         豸
*                               |
* B        DVR--->û̬:Ҫ'~SYSUPDT'
*                               |
* C        û̬-->DVR: 豸,boot׼'~BOOTMEN'
*                               |
* D        豸bootȡFlashеʶ: Ҫ ?------------->ֱ
*                               |Y                                              
* E        豸boot:óͨüݵ720p25fpsΪ:6 +10
*                               |
* F         豸boot-->DVR: 豸boot̬'~IINBOOT'
*                               |
* G        豸boot:óģʽ720p25fpsΪ:4 +16
*                               |
* H        DVR--->豸boot:ѯЭ汾ţʹõĴЭ
*                               |
* I        豸boot:ͼȶЭ汾Ųѯܺͻظ
*                               |
* J        DVR--->豸boot:ѯ豸뽫ҪİƥУ  
*                               |
* K        豸boot:豸Уܺͻظ 
*                               | 
* E            DVR--->豸boot:޸ʹõ485䲨'~CHGBIPS'
*                               |
* F            豸boot-->DVR: ޸ʹõ485䲨ʳɹ'~CHGBDOK'
*                               |
* G            DVR--->豸boot:ȷ'~UPTYP'
*                               |
* H            豸boot-->DVR: ȷϳɹ'~PREPROK'/'~ERRFILE'
*                               |
*             DVR--->豸boot:flash'~ER'
*                               |
*             豸boot-->DVR: flashɹ'~ERSSUCC'/'~ERSFAIL'
*                               |
*    ----------DVR--->豸boot:֡/֡'~FRAMEND'<-----------
*   |                           |                                         |
*   |                        ֡                                       |
*   |                           |                                         |
*   |                           |                                         |
*   |                  ݰУݰִ洢                         |
*   |                           |                                         |
*   |                           |                                         |
*   |           豸boot-->DVR: ֡ɹ'~DATASUC'/'~DATAERR'---
*   | 
*   |
*   |
*   --------------------------->|
*                               |
*                               |
*                         ֡
*                               |
*                         ݰдFlash
*                               |
*          豸boot-->DVR:ظɹ'~UPSUC'/ʧ'~UPFAI'
*                               |
*                         
*
*
*
*
*                    ͼ2: hdcviʶ
*
*
*
*
*                          豸
*                               |
*          APPhdcʼ:Ϊ 0豸дupFlag
*                               | 
*         DVR--->û̬:Ҫ'~SYSUPDT'
*                               |
*         û̬-->DVR: 豸,д:0x05, 豸 
*                               |
*         豸bootȡ:==0x05?--N--+1--->̣豸
*                               |Y 
*                               |
*                        
*
*       3.  ʹ˵
*            aݲʵֲ޸ĺͻظ
*            bʹòFlashдյݰвд
*
*       4.  ˵
*
*       5.  ˵
*           豸appֻbootŽʱ:豸յ:~SYSUPDT,ֱӻظ
*           ~SYSUPDT,޸Ϊģʽ̡
* Modification: 
*    Date    : 2014-05-22
*    Revision: Ver1.0.00
*    Author  : Xia_Junming
*    Contents: Create
*******************************************************************************/


/* ========================================================================== */
/*                             ͷļ                                       */
/* ========================================================================== */

#include "armboot.h"
#include "command.h"
#include "reg_hdcvi.h"
#include "cmd_flash.h"
#include "w25Q64cv.h"
#include "hdcvi_upgrade.h"


/* ========================================================================== */
/*                           Ͷ                                   */
/* ========================================================================== */

//#define UPDT_DEBUG           (1)


/* Чݴŵַ */
#define UPDATE_PACK_MEM_ADDR        (0xC0100000)

/* Ч֡size: 1k */
#define FRAME_SIZE                  (0x400)

#define BUF_LENGTH                  (2060)
#define BUF_INDEX_MAX               (BUF_LENGTH - 1)

/* ,FLASHϴ洢Ϣض */
/* ǵFLASHַ */
/* 0x00020000-0x00021000 : "hwid" */
/* 0x00021000-0x00022000 : "updateflag" */
#define UP_FLAG_ADDR           0x0001E000
#define UP_NAME_ADDR           0x0001F000


/* ǵĿ */
#define UP_FLAG_BLK_INDEX      0x00

/* ǵҳ */
#define UP_FLAG_PAGE_INDEX     0x00

/* ǵֽ */
#define UP_FLAG_BYTE_INDEX     0x00

/* У豸upflagsecĿʼֽ */
#define PDT_NAME_BYTE_INDEX     0x04

#define PDT_NAME_MAX            32
#define PDT_NAME_ACK_LEN        40



/* ---ֵ(Ҫ) */
#define UP_CLEAR               0x00

/* ---ֵ() */
#define UP_START               0x05


#define DELAY_SEC              (1000) /* 뼶ʱ */
#define DELAY_M_SEC            (5)    /* 뼶ʱ */
#define START_TRY_TIME         (12000)/* ȴʱ䣬ܳʱ:1 */
#define ACK_TRY_TIME           (1200)  /* Ӧһ״̬ܳʱ:6 */
#define FRAM_TRY_TIME          (12000)/* ݰʱ1κ,˳ */
#define DATA_MISS_TIME         (4000) /* ݰ©ʱ, 20δ֡, ط*/
#define WDT_FEED_TIME          (1000) /* 5 * 1000 = 5 sec ιһι */


#define UP_WD_TIMER        *(volatile unsigned int *)(0x70000038)
#define UP_WD_CW           *(volatile unsigned int *)(0x7000003c)
#define UP_TIME_OUT       (0x00000000)    


#define WDT_ENABLE               0x01
#define WDT_DISABLE             (0x01<<1)
#define WDT_KNOCKER             (0x01<<3)


/* ֡CRCУݸʽ */
typedef union 
{
    struct
    {
        u8 low;  
        u8 high;
    }bytes;
    
    uint16_t checkSum;
    
} FRAME_checkSumData;

typedef union 
{
    struct
    {
        uint16_t low16;
        uint16_t high16;
    }hiLow;
    
    uint32_t reaVal;
    
}RegPara;


/* rs485ݽտƽṹ */
typedef struct RS485_RxBuf
{
    uint32_t  readPos;                  /* ǰȥλ  */
    uint32_t  writePos;                 /* ǰд뵽λ */
    uint32_t  count;                    /* յݳ */    
    u8        rxBuf[BUF_LENGTH];        /* ݻ */
    
} RS485_RxBuf;

/* 485Ĵ */
typedef struct RS485_Para
{
    uint16_t ubdr;                      /* ʣ */
    u8       reLineD;                   /* ʼ */
    u8       reLineU;                   /* ֹ */
    
    uint16_t reDotD;                    /* ʼ */
    uint16_t reDotU;                    /* ֹ */

    uint16_t poLineD;                   /* ʼ */
    uint16_t poLineU;                   /* ֹ */
    uint16_t poBitN;                    /* 485ÿһλ,λ */
    
} RS485_Para;


/* rs485ͨݽṹ */
typedef struct 
{
    /* дݻ */ 
    u8          *pDatabuf;
    
    /* 
    * дֽǰdataLenΪֽغdataLenΪʵʶֽ
    * дǰdataLenΪдֽغdataLenΪʵѾдֽ
    */ 
    uint32_t    dataLen;
    
    /* OSA_TIMEOUT_NONE ȴ */ 
    /* OSA_TIMEOUT_FOREVERһֱȴֱ */
    uint32_t    timeOut; 
    int         reserved[8];
}RS485_Data;


#define max(a,b) (((a)>(b))?(a):(b))
#define min(a,b) (((a)<(b))?(a):(b))


/* ========================================================================== */
/*                                                                  */
/* ========================================================================== */


/* ========================================================================== */
/*                          ȫֱ                                    */
/* ========================================================================== */

/* ΪЭַ */

/* DVRоƬظǰСоƬظboot״̬ */

static const u8 cmdCap[]         = {'~','U','P','D','T','C','A','P'};
static const u8 cmdCapSupport[]  = {'~','C','A','P','S','U','P','T'};
static const u8 cmdCapNone[]     = {'~','C','A','P','N','O','N','E'};

static const u8 cmdUpdt[]        = {'~','*','Y','S','U','P','D','T'};
static const u8 replyBootMen[]   = {'~','B','O','O','T','M','E','N'};
static const u8 replyIinboot[]   = {'~','I','I','N','B','O','O','T'};


/* 豸ƥУ  */ 
static const u8 devName[]         = {'~','D','E','V','N','A','M','E'}; 
static const u8 devAck[]          = {'~','D','E','V',':'}; 


/* Э汾Уѯ  */ 
static const u8 verCmd[]         = {'~','A','S','K','V','E','R','S'}; 

/* Э汾ظ:*Ϊǰ7ֽУͣظʱ */ 
static u8 verAck[]               = {'~','V','E','R','1','0','0','*'}; 


/* ޸Ĳ޸ĲʳɹظϢ */
/* ޸ */
static const u8 chgb[]           = {'~','C','H','G','B'};
static const u8 chgbOk[]         = {'~','C','H','G','B','D','O','K'}; 


/* ͻظϢ */

/*~UPTYƽ̨(Ʒ)( ) */

/* ƽ̨PʾATMELƬAʾƽ̨DʾDH5000ƽ̨Fʾƽ̨ */

/*Ʒ:'1'ʾ'2'ʾо'3'ʾģ */

/*ͣƷʾ͡ */

/* DH5000 ʡtypeʹһͶ,յݰн */
static const u8 cmdTypeAll[]     = {'~','U','P','T','Y','D','3','0'};
static const u8 replyTypeOk[]    = {'~','P','R','E','P','R','O','K'};
static const u8 replyTypeErr[]   = {'~','E','R','R','F','I','L','E'};



/* ظϢ */
static const u8 cmdErase[]       = {'~','E','R'};
static const u8 replyEraseOk[]   = {'~','E','R','S','S','U','C','C'};
static const u8 replyEraseFail[] = {'~','E','R','S','F','A','I','L'};

static const u8 replyDataOk[]    = {'~','D','A','T','A','S','U','C'};
static const u8 replyDataErr[]   = {'~','D','A','T','A','E','R','R'};

static const u8 frmEnd[]         = {'~','F','R','A','M','E','N','D'};
static const u8 replyAllSumErr[] = {'~','S','U','M','E','R','R','A'};

/* ظϢ */
static const u8 replyWrFlash[]   = {'~','W','R','F','L','A', 'S', 'H'};
static const u8 replyUpSucc[]    = {'~','U','P','S','U','C', '3', '0'};
static const u8 replyUpFail[]    = {'~','U','P','F','A','I', '3', '0'};


/* ֡ݻ */
static u8 frmBuf[FRM_LEN + 2];/* 1030 Ϊ1032ֽڣ4ֽڶ*/
static u8 cmdBuf[CMD_LEN];

/* ӲʱżУ */
static const uint32_t baudRateTab[] = 
{
    1200,  2400,  4800,  9600,
    19200, 38400, 57600, 115200
};



static const RS485_Para  modeParasOld[HDCVI_MODE_MAX] =
{ 
    /* 720p@25fps */
    {
        .ubdr    = 0x01,
        .reLineD = 0x12, 
        .reLineU = 0x1b,
        .reDotD  = 0x420,
        .reDotU  = 0xA20,   
        .poLineD = 0x0e,
        .poLineU = 0x1a,
        .poBitN  = 0x28,  /* 0x14 */
    },
    
    /* 720p@30fps */
    {
        .ubdr    = 0x01,
        .reLineD = 0x12, 
        .reLineU = 0x1b,
        .reDotD  = 0x3B0,
        .reDotU  = 0x9B0,
        .poLineD = 0x0e,
        .poLineU = 0x1a,  
        .poBitN  = 0x30, /* 0x18 */ 
    },
    
    /* 720p@50fps */
     {
        .ubdr    = 0x01,
        .reLineD = 0x12, 
        .reLineU = 0x1b,

        .reDotD  = 0x340,
        .reDotU  = 0x940,
        .poLineD = 0x0e,
        .poLineU = 0x1a,
        .poBitN  = 0x50, /* 0x28 */
    },           
    
    /* 720p@60fps */
    {
        .ubdr    = 0x01,
        .reLineD = 0x12, 
        .reLineU = 0x1b,

        .reDotD  = 0x320,
        .reDotU  = 0x920,
        .poLineD = 0x0e,
        .poLineU = 0x1a,
        .poBitN  = 0x60, /* 0x30 */
    },
    
    /* 1080p@25fps */
    {
        .ubdr    = 0x01,
        .reLineD = 0x12, 
        .reLineU = 0x1b,
        .reDotD  = 0x350,
        .reDotU  = 0x950,
        .poLineD = 0x0e,
        .poLineU = 0x1a, 
        .poBitN  = 0x5a, /* 0x2d */
    },
    
    /* 1080p@30fps */
    {
        .ubdr    = 0x01,
        .reLineD = 0x12, 
        .reLineU = 0x1b,
        .reDotD  = 0x320,
        .reDotU  = 0x920,
        .poLineD = 0x0e,
        .poLineU = 0x1a,
        .poBitN  = 0x60, /* 0x30 */
    } 

};


static const RS485_Para  modeParasUp[HDCVI_MODE_MAX] =
{ 
    /* 720p@25fps, 4+2+14+1 */
    {
        .ubdr    = 0x01,
        .reLineD = 0x0d,   /* 13 пʼ*/
        .reLineU = 0x1a,   /* 26 н, 16*/
        .reDotD  = 0x420,
        .reDotU  = 0xA20, 
        .poLineD = 0x0e,   /* 14/2 = 7  пʼ,7-10Ч4*/ 
        .poLineU = 0x16,   /* 22 = 11 н*/
        .poBitN  = 0x28,   /* 0x14 */
    },
    
    /* 720p@30fps */
    {
        .ubdr    = 0x01,
        .reLineD = 0x0d, 
        .reLineU = 0x1a,
        .reDotD  = 0x3B0,
        .reDotU  = 0x9B0,  
        .poLineD = 0x0e, 
        .poLineU = 0x16,  
        .poBitN  = 0x30, /* 0x18 */ 
    },
    
    /* 720p@50fps */
     {
        .ubdr    = 0x01,
        .reLineD = 0x0d, 
        .reLineU = 0x1a,
        .reDotD  = 0x340,
        .reDotU  = 0x940, 
        .poLineD = 0x0e, 
        .poLineU = 0x16, 
        .poBitN  = 0x50, /* 0x28 */
    },           
    
    /* 720p@60fps */
    {
        .ubdr    = 0x01,
        .reLineD = 0x0d, 
        .reLineU = 0x1a,
        .reDotD  = 0x320,
        .reDotU  = 0x920, 
        .poLineD = 0x0e,
        .poLineU = 0x16, 
        .poBitN  = 0x60, /* 0x30 */
    },
    
    /* 1080p@25fps */
    {
        .ubdr    = 0x01,
        .reLineD = 0x0d, 
        .reLineU = 0x1a,
        .reDotD  = 0x350,
        .reDotU  = 0x950,
        .poLineD = 0x0e, 
        .poLineU = 0x16, 
        .poBitN  = 0x5a, /* 0x2d */
    },
    
    /* 1080p@30fps */
    {
        .ubdr    = 0x01,
        .reLineD = 0x0d, 
        .reLineU = 0x1a,
        .reDotD  = 0x320,
        .reDotU  = 0x920, 
        .poLineD = 0x0e, 
        .poLineU = 0x16, 
        .poBitN  = 0x60, /* 0x30 */
    } 
};


#if 0
static const RS485_Para  modeParasUp[HDCVI_MODE_MAX] =
{ 
    /* 720p@25fps, 4 + 1 + 16 */
    {
        .ubdr    = 0x01,
        .reLineD = 0x0c,   /* 12 пʼ*/
        .reLineU = 0x1b,   /* 27 н, 16*/
        .reDotD  = 0x420,
        .reDotU  = 0xA20, 
        .poLineD = 0x0e,   /* 14/2 = 7  пʼ,7-10Ч4*/ 
        .poLineU = 0x16,   /* 22 = 11 н*/
        .poBitN  = 0x28,   /* 0x14 */
    },
    
    /* 720p@30fps */
    {
        .ubdr    = 0x01,
        .reLineD = 0x0c, 
        .reLineU = 0x1b,
        .reDotD  = 0x3B0,
        .reDotU  = 0x9B0,  
        .poLineD = 0x0e, 
        .poLineU = 0x16,  
        .poBitN  = 0x30, /* 0x18 */ 
    },
    
    /* 720p@50fps */
     {
        .ubdr    = 0x01,
        .reLineD = 0x0c, 
        .reLineU = 0x1b,
        .reDotD  = 0x340,
        .reDotU  = 0x940, 
        .poLineD = 0x0e, 
        .poLineU = 0x16, 
        .poBitN  = 0x50, /* 0x28 */
    },           
    
    /* 720p@60fps */
    {
        .ubdr    = 0x01,
        .reLineD = 0x0c, 
        .reLineU = 0x1b,
        .reDotD  = 0x320,
        .reDotU  = 0x920, 
        .poLineD = 0x0e,
        .poLineU = 0x16, 
        .poBitN  = 0x60, /* 0x30 */
    },
    
    /* 1080p@25fps */
    {
        .ubdr    = 0x01,
        .reLineD = 0x0c, 
        .reLineU = 0x1b,
        .reDotD  = 0x350,
        .reDotU  = 0x950,
        .poLineD = 0x0e, 
        .poLineU = 0x16, 
        .poBitN  = 0x5a, /* 0x2d */
    },
    
    /* 1080p@30fps */
    {
        .ubdr    = 0x01,
        .reLineD = 0x0c, 
        .reLineU = 0x1b,
        .reDotD  = 0x320,
        .reDotU  = 0x920, 
        .poLineD = 0x0e, 
        .poLineU = 0x16, 
        .poBitN  = 0x60, /* 0x30 */
    } 
};
#endif
 
static u8                   appautoDev;
static int                  tryTimes;       /* Դ */
static int                  updateFlag;     /* ʶ */
static char                 pdtName[PDT_NAME_MAX];

static RS485_RxBuf          recvBuf = {0};  /* rs485ݽտ */
static uint32_t             stateMachine = 0;
       u8                   *packMemAddr;
       uint32_t             packTotalSize;
       bd_t                 *pBd = NULL;


/* ========================================================================== */
/*                                                                  */
/* ========================================================================== */
/*******************************************************************************
*   : hdcvi_delay_ms
*     : ʱװ
* 
*     :       
*     : 
* ֵ  : 
*                    
*******************************************************************************/
static void hdcvi_delay_ms(int ms)
{

    while(ms > 0)
    {   
        /* 1msʱ׼ȷ */
        udelay(1000); 
        ms--;
    }
}

/*******************************************************************************
*   : appauto_init
*     : ʼȡappautoֵ 
* 
*     :       
*     : 
* ֵ  : 
*                    
*******************************************************************************/
void appauto_init(void)
{ 
    char *s;
    
    if ((s = getenv (pBd, "appauto")) != NULL)
    {
        appautoDev = simple_strtoul(s, NULL, 10);
    }

    printf("-----------appautoDev = %x---------\n", appautoDev);
    hdcvi_wdt_setTimeout(); 
    hdcvi_enable_wdt();
    hdcvi_wdt_feed();  
}


/*******************************************************************************
*   : hdcvi_enable_wdt
*     : Ź. 
* 
*     :       
*     : 
* ֵ  : 
*                    
*******************************************************************************/
void hdcvi_enable_wdt(void)
{ 
    if (0 == appautoDev)
    {
        return;
    }

	UP_WD_CW = WDT_ENABLE;
}

/*******************************************************************************
*   : hdcvi_disable_wdt
*     : رտŹ 
* 
*     :       
*     : 
* ֵ  : 
*                    
*******************************************************************************/
void hdcvi_disable_wdt(void)
{  
    if (0 == appautoDev)
    {
        return;
    }

    UP_WD_CW = (WDT_ENABLE|WDT_DISABLE);
    UP_WD_CW = (~WDT_ENABLE&WDT_DISABLE);
}

/*******************************************************************************
*   : hdcvi_wdt_setTimeout
*     : ÿŹʱʱ 
* 
*     :       
*     : 
* ֵ  : 
*                    
*******************************************************************************/
void  hdcvi_wdt_setTimeout(void)
{
    if (0 == appautoDev)
    {
        return;
    }

    UP_WD_TIMER = UP_TIME_OUT;
}

/*******************************************************************************
*   : hdcvi_wdt_feed
*     :ιӿ 
* 
*     :       
*     : 
* ֵ  : 
*                    
*******************************************************************************/
void hdcvi_wdt_feed(void)
{
    uint32_t tmpVal;

    if (0 == appautoDev)
    {
        return;
    }
    
    tmpVal   = UP_WD_CW;
	tmpVal  |= WDT_KNOCKER;
    UP_WD_CW = tmpVal; 
}

/*******************************************************************************
*   : flash_read
*     : FlashȡָݳֽBUF4ֽڷת
*     : buf  :ȡ
*           addr :flashַ
*           count:ȡֽ
*     : 
* ֵ  : < 0:ʧ
*           count:ȡĸ
*******************************************************************************/
int flash_read(u8 *buf, u32 addr, u32 count)
{
    u32   tmp, cnt, i, ret = 0;
    u32   *pu32tmp = NULL;
    u8    *pu8 = NULL;

    w25q64cv_read(buf, addr, count);
    
    pu8 = (u8 *)buf;
    pu32tmp = (unsigned int *)buf;

    /* 4ֽڲ */
    cnt = count>>2;   
    for (i = 0; i < cnt; i++)
    {
        tmp = *pu32tmp;
        *pu8 ++ = ( ( tmp >> 24 ) & 0xFF );
        *pu8 ++ = ( ( tmp >> 16 ) & 0xFF );
        *pu8 ++ = ( ( tmp >> 8 ) & 0xFF );
        *pu8 ++ = ( ( tmp >> 0 ) & 0xFF );
        pu32tmp++;
    }

    /* 4ֽڲ */
    cnt = count & 0x03;
    if (0 != cnt)
    {
        tmp = *pu32tmp; 
        for (i = 0; i < cnt; i ++)
        {
            *pu8 ++ = ( ( tmp >> ( ( 3 - i ) * 8 ) ) & 0xFF );
        }
    }
    
    return count;
}


/*******************************************************************************
*   : update_pdtname_get
*     : Flashupdateflagȡ豸
*
*     :       
*     : 
* ֵ  : 
*                    
*******************************************************************************/
void update_pdtname_get(void)
{
    char buf[SECTOR_SIZE] = {0};

    flash_read(buf, UP_NAME_ADDR, SECTOR_SIZE);
    
    buf[PDT_NAME_ACK_LEN - 1] = '\0';
    
    printf("pdtName:%s\n", buf );


    /* ȡ豸ʱڰУ */
    memcpy(pdtName, buf, PDT_NAME_MAX - 1);
    pdtName[PDT_NAME_ACK_LEN - 1] = '\0';
}


/*******************************************************************************
*   : update_info_check
*     : FlashupdateflagȡǷҪıǣжǷֱӽ
*           ʱȴͺֱ̣Լʱ䡣 
*     :       
*     : 
* ֵ  : 
*                    
*******************************************************************************/
int update_flag_check(void)
{
    ulong   len = SECTOR_SIZE;
    char    buf[SECTOR_SIZE] = {0};  
    u8      upflag = UP_CLEAR; 

    flash_read(buf, UP_FLAG_ADDR, len); 
    printf("Before write:updtFlag:0x%x\n", buf[UP_FLAG_BYTE_INDEX]); 

     
    /* 5APP,bootֱӽ,֤APPǺõ */
    /* ҪAPPյDVRFLASHдUP_START */  
    upflag = buf[UP_FLAG_BYTE_INDEX];
    if (UP_START  == upflag)
    {
        update_pdtname_get();
        return 0;
    } 
    else if (upflag < UP_START)
    {
        buf[UP_FLAG_BYTE_INDEX]++;
    }
    else
    {
        /*Ƭ>0x05ֱ豸0 */
        buf[UP_FLAG_BYTE_INDEX] = UP_CLEAR;
    }

    w25q64cv_erase(UP_FLAG_ADDR, 1,  flash_erase_4k_mode);
    w25q64cv_write(buf, UP_FLAG_ADDR, len, big_endian); 
    flash_read(buf, UP_FLAG_ADDR, len);
    
    printf("After  write:updtFlag: 0x%x \n", buf[UP_FLAG_BYTE_INDEX]);
    return (-1);
}

/*******************************************************************************
*   : update_flag_clear
*     : ɹһαǡ 
*     :       
*     : 
* ֵ  : 
*                    
*******************************************************************************/
void update_flag_clear(void)
{
    ulong   len = SECTOR_SIZE;
    char    buf[SECTOR_SIZE];

    flash_read(buf, UP_FLAG_ADDR, len);
    printf("Before write:updtFlag:0x%x\n", buf[UP_FLAG_BYTE_INDEX]); 

    buf[UP_FLAG_BYTE_INDEX] = UP_CLEAR;

    w25q64cv_erase(UP_FLAG_ADDR, 1,  flash_erase_4k_mode);
    w25q64cv_write(buf, UP_FLAG_ADDR, len, big_endian); 
    flash_read(buf, UP_FLAG_ADDR, len);
    
    printf("After  write:updtFlag: 0x%x \n", buf[UP_FLAG_BYTE_INDEX]);
}


/*******************************************************************************
*   : hdcvi_rs485_setMode
*     : hdcvi9801оƬ485ʱòģʽ(1080p@-30fps):
*           ʡʼ㡢ֹ㡢ʼ㡢ֹȼĴ
*     :       
*     : 
* ֵ  : 
*                    
*******************************************************************************/
static void hdcvi_rs485_setMode(int mode, RS485_Para *pTable)
{
    RS485_Para *modeParam;
    RegPara    regPara;
    
    modeParam  = pTable;
    modeParam += mode;

    /* copy to register */
    PREG_DVR2CAM_UBDR   = modeParam->ubdr; 
    printf("PREG_DVR2CAM_UBDR: %x  \n", PREG_DVR2CAM_UBDR);  
    
    PREG_DVR2CAM_LINE_D = modeParam->reLineD; 
    printf("PREG_DVR2CAM_LINE_D: %x  \n", PREG_DVR2CAM_LINE_D);
    
    PREG_DVR2CAM_LINE_U = modeParam->reLineU; 
    printf("PREG_DVR2CAM_LINE_U: %x  \n", PREG_DVR2CAM_LINE_U);
    
    PREG_DVR2CAM_DOT_D  = modeParam->reDotD; 
    printf("PREG_DVR2CAM_DOT_D: %x  \n", PREG_DVR2CAM_DOT_D); 
    
    PREG_DVR2CAM_DOT_U  = modeParam->reDotU; 
    printf("PREG_DVR2CAM_DOT_U: %x \n", PREG_DVR2CAM_DOT_U);  

    /* ݴ:ݵֹк*/ 
    regPara.hiLow.high16   = modeParam->poLineD;
    regPara.hiLow.low16    = modeParam->poLineU; 
    PREG_BC_SET0 = regPara.reaVal; 
    printf("PREG_BC_SET0: %x  \n", PREG_BC_SET0);  

    regPara.hiLow.low16    = modeParam->poBitN;
    regPara.hiLow.high16   = 0x00; 
    PREG_BC_SET1 = regPara.reaVal;
    printf("PREG_BC_SET1: %x  \n", PREG_BC_SET1);  

    /* 485 ʹ, ģʽĴ֮ᱻ */
    regPara.reaVal         = 0x01UL;
    PREG_RS485_POS_CTRL    = regPara.reaVal;  
    printf("PREG_RS485_POS_CTRL: %x  \n", PREG_RS485_POS_CTRL);
}


/*******************************************************************************
*   : hdcvi_rs485_init
*     : hdcvi9801оƬ485ӿڣʹܡжϴ
*           ʱжʱȣĴá
*     :       
*     : 
* ֵ  :             
*******************************************************************************/
static void hdcvi_rs485_init(void)
{
    PREG_DVR2CAM_UCR = (1 << RB_UCR_ODD_EVEN_EN)  \
                       | (1 << RB_UCR_D2C_UTO_EN) \
                       | (1 << RB_UCR_D2C_INT_EN) \
                       | (1 << RB_UCR_D2C_EN);
    
    printf("PREG_DVR2CAM_UCR is %x \n", PREG_DVR2CAM_UCR);
}

/*******************************************************************************
*   : hdvci_colorbar_init
*     : ģʽؼĴʼ 
*     : mode:ʽ   
*     : 
* ֵ  :             
*******************************************************************************/
void hdvci_colorbar_init(int mode)
{
    /* hdcvi colorbar 1080p25 */
    if (HDCVI_MODE_1080_25 == mode)
    {
        *((unsigned int *)0x60000024) = 0x0;
        *((unsigned int *)0x60028080) = 0x4 ; //1080p25
        *((unsigned int *)0x6002805c) = 0x1;
        *((unsigned int *)0x60028084) = 0x1 ;
        *((unsigned int *)0x60000014) = 0x832c;
        *((unsigned int *)0x60000028) = 0x1;
        *((unsigned int *)0x60000080) = 0x11;
    }

    if (HDCVI_MODE_1080_30 == mode)
    {
        /* hdcvi colorbar 1080p30 */
        *((unsigned int *)0x60000024) = 0x0; 
        *((unsigned int *)0x60028080) = 0x5; 
        *((unsigned int *)0x6002805c) = 0x1;

        *((unsigned int *)0x60028084) = 0x1;  

        *((unsigned int *)0x60000014) = 0x31a;
        *((unsigned int *)0x60000028) = 0x1; 
        *((unsigned int *)0x60000080) = 0x11;
    }

    if (HDCVI_MODE_720_25 == mode)
    {
        /* hdcvi colorbar 720p25 */

        /* ģʽѡ:0HDCVI룬1BT1120룬2960H*/
        *((unsigned int *)0x60000024) = 0x0;

        /* Hdcviģʽѡ:0--720p25 */
        *((unsigned int *)0x60028080) = 0x0; 

        /* :0رգ1ʹ */
        *((unsigned int *)0x6002805c) = 0x1;

        /* HDCVIĴʹ: 1-0x8000-0x805cĴֵ0-ԭֵ*/  
        *((unsigned int *)0x60028084) = 0x1; 

        /* PLLò */
        *((unsigned int *)0x60000014) = 0x4;

        /* hdcvi ʹ*/
        *((unsigned int *)0x60000028) = 0x1;

        /* ģƫò1ʹbit4 && DACʹbit0 */
        *((unsigned int *)0x60000080) = 0x11;
    }

}


/*******************************************************************************
*   : hdcvi_rs485_init
*     : hdcvi9801оƬ485ֹͣӿ,hdcvi_rs485_initõļĴ
*     :       
*     : 
* ֵ  :             
*******************************************************************************/
static void hdcvi_rs485_deinit(void)
{
    PREG_DVR2CAM_UCR = 0;
}


/*******************************************************************************
*   : hdcvi_write
*     : hdcvi:дݽӿ,оƬ--->DVR
*     : pRs485Data:д
*
*     : 
* ֵ  : < 0:ʧܡ
*           ==0:ɹ 
*******************************************************************************/
static int hdcvi_write(RS485_Data *pRs485Data)
{
    int             i = 0;
    u8              *p;
    u8              waitLen;
    
    if ((pRs485Data->dataLen < 1 ) 
         || (NULL == pRs485Data)
         ||(NULL == pRs485Data->pDatabuf))
    { 
        printf("hdcvi_write: para invalid:%u,%p,%p \n", 
               pRs485Data->dataLen, pRs485Data, 
               pRs485Data->pDatabuf);
        
        pRs485Data->dataLen = 0;
        return (-1);
    }
    
    p = pRs485Data->pDatabuf;
    while(i < pRs485Data->dataLen)
    {  
        /* check:Is fifo full ? */
        waitLen = PREG_CAM2DVR_CAP;
        if (waitLen < THR_RS485_RXFIFO_FULL)
        { 
            /* дд"дĴ" */        
            printf("write: %x \n", *p);
            PREG_CAM2DVR_DAT = *p++;
            i++;
        }
        else
        {
            /* the fifo full , waitting */
            printf("\n fifo is full:%x \n", *p);
            hdcvi_delay_ms(1);
        }     
    }

    return (0);
}

/*******************************************************************************
*   : hdcvi_framCheckRecv
*     : hdcvi: ӽݻȡ֡ÿζȡһ,ȡݰ
*           ʱУԼЭͷУ飬вݶҵЭͷʼ
*           Уͣʱֱڻbuf㲻УͼȷŽ
*           ݰ洢ڴ
*     : .         
*     : .
* ֵ  : < 0:ʧܡ
*           ==0:ɹ 
*******************************************************************************/
static int hdcvi_framCheckRecv(void)
{

    int                 replyLen;
    u8                  *pReply;
    int                 ret, result, i,readBytePos;
    uint16_t            checksum = 0; 
    u8                  *saveMemAddr;
    FRAME_checkSumData  checkSumData;
    static  int         packNum = 0;


    /* ݻ */
    while ((':' != *(recvBuf.rxBuf + recvBuf.readPos))
        && ('~' != *(recvBuf.rxBuf + recvBuf.readPos))
        &&(recvBuf.count > 0))
    {    
        recvBuf.readPos++;
        recvBuf.readPos = (recvBuf.readPos % BUF_LENGTH);
        recvBuf.count--;
    }    

    if ( (recvBuf.count == 0) || (':' != *(recvBuf.rxBuf+recvBuf.readPos)))
    {
         return (-1);
    } 

    
    if((recvBuf.count > 0) && (recvBuf.count < FRM_LEN))
    {
        /* Ѿݹ, 60ûչ1030byte, ֪ͨط */ 
        if (tryTimes <= 1)
        {
            /* ʱط */ 
            printf("time out: only receive %d bytes, please resend\n", recvBuf.count);
            ret = hdcvi_reply(replyDataErr, CMD_LEN);
            if (ret < 0)
            {
                printf("hdcvi_framCheckRecv: pReply, failed\n");
            }
            
            /* óԳʱʱ */
            tryTimes = FRAM_TRY_TIME;
            recvBuf.readPos = (recvBuf.readPos + recvBuf.count) % BUF_LENGTH;
            recvBuf.count = 0;
        }
        
        return (-1);
    } 
    
    printf("-------checksum begin:------------------\n");

    /* Уͼ */
    for (i = 0; i < (FRM_LEN - FRAME_CRC_LEN); i++)
    {   
        readBytePos = (recvBuf.readPos + i) % BUF_LENGTH ;
        checksum   += *(recvBuf.rxBuf  + readBytePos); 
        
#ifdef UPDT_DEBUG 

        printf("%x,", *(recvBuf.rxBuf  + readBytePos)); 
        if (0 ==(i % 32))
        {
            printf("readBytePos = %x, \n", readBytePos);
        }
#endif

    }

    readBytePos = (recvBuf.readPos + FRM_LEN - FRAME_CRC_LEN) % BUF_LENGTH ; 
    
    checkSumData.bytes.low  = *(recvBuf.rxBuf  + readBytePos);
    
#ifdef UPDT_DEBUG   
    printf("\n----low = %x, \n", checkSumData.bytes.low );
#endif
    
    readBytePos = (recvBuf.readPos + FRM_LEN - FRAME_CRC_LEN + 1) % BUF_LENGTH;

        
    checkSumData.bytes.high = *(recvBuf.rxBuf  + readBytePos); 
  
#ifdef UPDT_DEBUG   
    printf("\n----high = %x, \n", checkSumData.bytes.high);
#endif  
    
    printf("checksum: 0x%x , checkSumData.checkSum: 0x%x \n", 
           checksum, checkSumData.checkSum);
    if (checksum == checkSumData.checkSum)
    {
        /* ݰ */
        saveMemAddr = packMemAddr + packTotalSize;
        for (i = 0; i < FRAME_DATA_LEN; i++)
        { 
            readBytePos  = (recvBuf.readPos + FRAME_HEAD_LEN + i) % BUF_LENGTH ;
            *saveMemAddr = *(recvBuf.rxBuf  + readBytePos); 
            saveMemAddr++;
            packTotalSize++;
        }
        
        packNum++;
        printf("\nrecv frame--%d ok\n", packNum);
        
        /* ֪ͨһݰ */
        pReply = replyDataOk;
        result = 0;
    }
    else
    { 
        printf("\nrecv frame--%d checksum err,\n", packNum);

        /* У鲻ʱظطð */
        pReply = replyDataErr; 
        result = -1;
    }
    
    /* ظ */
    ret = hdcvi_reply(pReply, CMD_LEN);
    if (ret < 0)
    {
        printf("hdcvi_framCheckRecv: pReply, failed\n");
    }

    /* óԳʱʱ */
    tryTimes = FRAM_TRY_TIME;
    recvBuf.readPos = (recvBuf.readPos + FRM_LEN) % BUF_LENGTH;
    recvBuf.count -= FRM_LEN;
    
    return  result;
}


/*******************************************************************************
*   : hdcvi_read
*     : hdcvi: ӽݻȡ֡ݣÿζȡһ
*           ,ջȡݰʱȡȺͻݵĳ
*           ȫƥ䣬ֱӷʧ.
*     : pBuf:ȡݽջ.
*           len: ȡݰĳ,ֻCMD_LEN  FRM_LEN.
*     : 
* ֵ  : < 0:ʧܡ
*           ==0:ɹ 
*******************************************************************************/
static int hdcvi_read(u8 *pBuf, int len)
{
    int  readLenTmp;
    
    if (NULL == pBuf) 
    {
        printf("para invalid: pBuf = %x\n", pBuf);
        return (-1);
    }

    if ( (len != CMD_LEN) && (len != FRM_LEN))
    {
        printf("para invalid: len = %d\n" , len);
        return (-1);
    }

    /* ݻ */
    while ((':' != *(recvBuf.rxBuf + recvBuf.readPos))
        && ('~' != *(recvBuf.rxBuf + recvBuf.readPos))
        &&(recvBuf.count > 0))
    {    
        recvBuf.readPos++;
        recvBuf.readPos = (recvBuf.readPos % BUF_LENGTH);
        recvBuf.count--;
    }    

    if (recvBuf.count < len)
    {
        return (-1);
    }

    if ((len == CMD_LEN) && ('~' != *(recvBuf.rxBuf + recvBuf.readPos)))
    { 
        #ifdef UPDT_DEBUG
            printf("not cmd data!\n");
        #endif
        
        return (-1);      
    }
    
    if ((len == FRM_LEN) && (':' != *(recvBuf.rxBuf + recvBuf.readPos)))
    {
        #ifdef UPDT_DEBUG
            printf("not frame data!\n");
        #endif
        
        return (-1);      
    } 
    
#ifdef UPDT_DEBUG

    printf("----recvBuf.count = %d\n", recvBuf.count);
    printf("recvBuf.readPos = %d, recvBuf.writePos = %d\n",
           recvBuf.readPos, recvBuf.writePos);
#endif

    if (recvBuf.readPos > recvBuf.writePos)
    {
        if (BUF_LENGTH - recvBuf.readPos >= len)
        { 
            memcpy(pBuf, (recvBuf.rxBuf + recvBuf.readPos), len); 
            //memset((recvBuf.rxBuf + recvBuf.readPos), 0, len);
            recvBuf.readPos   += len;
            recvBuf.readPos    = recvBuf.readPos % BUF_LENGTH;
            recvBuf.count     -= len;
        }
        else
        {   
            /* 벿 */ 
            readLenTmp = BUF_LENGTH - recvBuf.readPos;
            memcpy(pBuf, (recvBuf.rxBuf + recvBuf.readPos), readLenTmp);   
            //memset((recvBuf.rxBuf + recvBuf.readPos), 0, readLenTmp);

            /* ǰ벿 */
            memcpy(pBuf + readLenTmp, recvBuf.rxBuf, len - readLenTmp);   
            //memset(recvBuf.rxBuf, 0, len - readLenTmp);
            
            recvBuf.readPos   = len - readLenTmp; 
            recvBuf.count     -= len;
        }
        
#ifdef UPDT_DEBUG

        printf("***********1111----:%x, %x, %x, %x, %x, %x, %x, %x\n", 
        pBuf[0],
        pBuf[1],
        pBuf[2],
        pBuf[3],
        pBuf[4],
        pBuf[5],
        pBuf[6],
        pBuf[7]);

        printf("***********111----:%c, %c, %c, %c, %c, %c, %c, %c\n", 
        pBuf[0],
        pBuf[1],
        pBuf[2],
        pBuf[3],
        pBuf[4],
        pBuf[5],
        pBuf[6],
        pBuf[7]);

#endif        
    }
    else 
    {
        memcpy(pBuf, (recvBuf.rxBuf + recvBuf.readPos), len);
        
#ifdef UPDT_DEBUG        
        printf("-----------000----: %x, %x, %x, %x, %x, %x, %x,%x\n", 
        pBuf[0],
        pBuf[1],
        pBuf[2],
        pBuf[3],
        pBuf[4],
        pBuf[5],
        pBuf[6],
        pBuf[7]);

        printf("-----------000----: %c, %c, %c, %c, %c, %c, %c, %c\n", 
        pBuf[0],
        pBuf[1],
        pBuf[2],
        pBuf[3],
        pBuf[4],
        pBuf[5],
        pBuf[6],
        pBuf[7]);
#endif        
        //memset((recvBuf.rxBuf + recvBuf.readPos), 0, len); 
        recvBuf.readPos   += len;
        recvBuf.count     -= len;
    }
    
    return  (0);
}


/*******************************************************************************
*   : hdcvi_reply
*     : hdcvi:ͻظݽӿ
*     : 
*     : 
* ֵ  : < 0:ʧܡ
*           ==0:ɹ 
*******************************************************************************/
static int hdcvi_reply(u8 *pBuf, int len)
{
    RS485_Data data; 

    if ((NULL == pBuf) || ((len != CMD_LEN) && (len != PDT_NAME_ACK_LEN)))
    {
        return (-1);
    }

    printf("hdcvi_reply: len --- %d\n", len);
    printf("hdcvi_reply: \n %c%c%c%c%c%c%c%c \n",
           pBuf[0], pBuf[1], pBuf[2], pBuf[3],
           pBuf[4], pBuf[5], pBuf[6], pBuf[7]);
    
    data.pDatabuf = pBuf;
    data.dataLen  = len;
    data.timeOut  = 100; 
    
    return hdcvi_write(&data); 
}


/*******************************************************************************
*   : hdcvi_upgrade_init
*     : hdcvi:rs485оƬĴسʼݰ洢ʼ
*           ״̬ʼ
*     : 
*     : 
* ֵ  : < 0:ʧܡ
*           ==0:ɹ 
*******************************************************************************/
void hdcvi_upgrade_init(bd_t *bd)
{
    int ret;
    
    pBd = bd;
    appauto_init();
    
    ret = update_flag_check();
    if (ret < 0)
    {      
        printf("Do Not Need upgrade!\n"); 
        /* ƵĲʽ */
        hdvci_colorbar_init(HDCVI_MODE_1080_30);   
        updateFlag = UP_CLEAR;
        return;
    }

    updateFlag = UP_START;

    /* HDCVI_MODE_720_25гʼ,ֹģʽ */
    hdvci_colorbar_init(HDCVI_MODE_720_25); 
    hdcvi_rs485_init();
    hdcvi_rs485_setMode(HDCVI_MODE_720_25, modeParasOld);

    packMemAddr   = (u8 *)UPDATE_PACK_MEM_ADDR;
    packTotalSize = 0;
    
    recvBuf.count = 0;
    stateMachine  = STATE_BOOT_START;
    tryTimes      = START_TRY_TIME;
    
    hdcvi_delay_ms(1 * DELAY_SEC); 
}


/*******************************************************************************
*   : hdcvi_upgrade_start
*     : hdcvi:ѯͻظ
*           ״̬ʼ
*     : 
*     : 
* ֵ  : < 0:ʧܡ
*           ==0:յѯָ 
*           ==1:յʼָ 
*******************************************************************************/
int hdcvi_upgrade_start(void)
{
    int  ret;
    u8   cmd_buf[CMD_LEN];

    memset(cmd_buf, 0, CMD_LEN);
    ret = hdcvi_read(cmd_buf, CMD_LEN);
    if (ret < 0 )
    {   
        return (-1);
    }
    
    if ('~' != cmd_buf[0])
    {
        printf("hdcvi_upgrade_start: cmd err !\n");
        return (-1); 
    }

    /* ʼ:ȱȽ 'Y','S','U','P','D','T' */
    ret = memcmp(&cmd_buf[2], &cmdUpdt[2], (sizeof(cmdUpdt) - 2));
    if (0 != ret)
    { 
        printf("hdcvi_upgrade_start: cmd err !\n");
        return (-1);
    }
    
    hdcvi_wdt_feed();
    hdcvi_delay_ms(3 * DELAY_SEC);
    
    
    ret = hdcvi_reply(replyIinboot, sizeof(replyIinboot));
    if (ret < 0)
    {
       printf("hdcvi_reply:%s, failed\n", replyIinboot);
       return (-1);
    }

    
#if 0
    /*  */
    hdcvi_wdt_feed();

    /* replyIinbootлµֹģʽʱ5Ƶȶ */ 
    hdcvi_delay_ms(3 * DELAY_SEC);
    
    hdcvi_wdt_feed(); 
    hdcvi_rs485_setMode(HDCVI_MODE_720_25, modeParasUp);
    hdcvi_delay_ms(5 * DELAY_SEC); 
    hdcvi_wdt_feed();
    
#endif

    /* Э汾У */
    stateMachine = STATE_VER_CK;
    tryTimes = ACK_TRY_TIME;
    return (0);   
}


/*******************************************************************************
*   : dealwith_erase_cmd
*     : hdcvi: 
*     : 
*     : 
* ֵ  : < 0:ʧܡ
*           ==0:ɹ 
*******************************************************************************/
static int dealwith_version_check(void)
{
    int ret; 
    u8  cmd_buf[CMD_LEN]; 

    memset(cmd_buf, 0, CMD_LEN);
    ret = hdcvi_read(cmd_buf, CMD_LEN);
    if (ret < 0 )
    {   
        //printf("hdcvi_read data failed\n");
        return (-1);
    }

    printf("dealwith_version_check: %x, %x, %x, %x, %x, %x, %x\n", 
            cmd_buf[0],
            cmd_buf[1],
            cmd_buf[2],
            cmd_buf[3],
            cmd_buf[4],
            cmd_buf[5],
            cmd_buf[6]);
 

    /* Э汾 */
    ret = memcmp(cmd_buf, verCmd, sizeof(verCmd));
    if (0 != ret)
    {   
        printf("memcmp:failed\n");
        return (-1);
    } 

    verAck[7] = (verAck[6] + verAck[5] + verAck[4] + verAck[3]\
                +verAck[2] + verAck[1] + verAck[0] ) % 256;

    /* ظЭ汾 */    
    ret = hdcvi_reply(verAck, sizeof(verAck));
    if (ret < 0)
    {
        printf("reply_typok:%s,failed\n", verAck);
        return (-1);
    }
    
    /* 豸У */
    stateMachine = STATE_PDT_NAME_CK; 
    tryTimes = ACK_TRY_TIME;
    hdcvi_delay_ms(100); 
    printf("dealwith_version_check ok\n");
    
    return (0);   
}


/*******************************************************************************
*   : dealwith_erase_cmd
*     : hdcvi: 
*     : 
*     : 
* ֵ  : < 0:ʧܡ
*           ==0:ɹ 
*******************************************************************************/
static int dealwith_pdtname_check(void)
{
    int ret; 
    u8  cmd_buf[CMD_LEN];
    u8  pdtNameAck[PDT_NAME_ACK_LEN];

    memset(cmd_buf, 0, CMD_LEN);
    ret = hdcvi_read(cmd_buf, CMD_LEN);
    if (ret < 0 )
    {   
        //printf("hdcvi_read data failed\n");
        return (-1);
    }

    printf("dealwith_pdtname_check: %x, %x, %x, %x, %x, %x, %x\n", 
            cmd_buf[0],
            cmd_buf[1],
            cmd_buf[2],
            cmd_buf[3],
            cmd_buf[4],
            cmd_buf[5],
            cmd_buf[6]); 

    /* 豸ѯ */
    ret = memcmp(cmd_buf, devName, sizeof(devName));
    if (0 != ret)
    {   
        printf("memcmp:failed\n");
        return (-1);
    } 

    /* 豸ظ */
    memset(pdtNameAck, 0, PDT_NAME_ACK_LEN);
    
    sprintf(pdtNameAck,"%s%s", devAck, pdtName);
    
    printf("pdtNameAck:%s\n", pdtNameAck);
   
    ret = hdcvi_reply(pdtNameAck, PDT_NAME_ACK_LEN);
    if (ret < 0)
    {
        printf("reply_typok:%s,failed\n", pdtNameAck);
        return (-1);
    }

    /* 벨У׶ */
    stateMachine = STATE_CHGB;
    tryTimes = ACK_TRY_TIME;
    hdcvi_delay_ms(100);
    
    printf("dealwith_pdtname_check ok\n");
    return (0);   
}


/*******************************************************************************
*   : dealwith_erase_cmd
*     : hdcvi: 
*     : 
*     : 
* ֵ  : < 0:ʧܡ
*           ==0:ɹ 
*******************************************************************************/
static int dealwith_chgb_cmd(void)
{
    int         ret;
    u8          cmd_buf[CMD_LEN];
    
    memset(cmd_buf, 0, CMD_LEN);
    ret = hdcvi_read(cmd_buf, CMD_LEN);
    if (ret < 0 )
    {   
        return (-1);
    }

    /* Ĳͷ */
    ret = memcmp(cmd_buf, chgb, sizeof(chgb));
    if (0 != ret)
    {   
        return (-1);
    }

    /* ظ޸ĳɹ */  
    ret = hdcvi_reply(chgbOk, sizeof(chgbOk));
    if (ret < 0)
    {
        printf("reply_chgb:%s,failed\n", chgbOk);
        return (-1);
    }

    /* հУ׶ */  
    stateMachine = STATE_TYPE_CK; 
    tryTimes = ACK_TRY_TIME;
    hdcvi_delay_ms(DELAY_M_SEC); 

    printf("dealwith_chgb_cmd ok\n");
    return (0);
}


/*******************************************************************************
*   : dealwith_erase_cmd
*     : hdcvi: 
*     : 
*     : 
* ֵ  : < 0:ʧܡ
*           ==0:ɹ 
*******************************************************************************/
static int dealwith_type_cmd(void)
{
    int ret; 
    u8  cmd_buf[CMD_LEN]; 

    memset(cmd_buf, 0, CMD_LEN);
    ret = hdcvi_read(cmd_buf, CMD_LEN);
    if (ret < 0 )
    {   
        //printf("hdcvi_read data failed\n");
        return (-1);
    }

    printf("dealwith_type_cmd: %x, %x, %x, %x, %x, %x, %x\n", 
            cmd_buf[0],
            cmd_buf[1],
            cmd_buf[2],
            cmd_buf[3],
            cmd_buf[4],
            cmd_buf[5],
            cmd_buf[6]); 

    /* У */
    ret = memcmp(cmd_buf, cmdTypeAll, (CMD_LEN- 3));
    if (0 != ret)
    { 
        /*ǰ׺ֱӷ*/
        printf("dealwith_type_cmd:read cmd failed\n");
        return (-1);
    } 

    ret = memcmp(&cmd_buf[CMD_LEN - 3], &cmdTypeAll[CMD_LEN - 3], 3);
    if (0 != ret)
    {   
        /* Ͳ */
        ret = hdcvi_reply(replyTypeErr, sizeof(replyTypeErr));
        if (ret < 0)
        {
            printf("reply_typeErr:%s,failed\n", replyTypeErr);
        }
        
        return (-1);
    } 
 
    /* ظݰУͨ */    
    ret = hdcvi_reply(replyTypeOk, sizeof(replyTypeOk));
    if (ret < 0)
    {
        printf("reply_typok:%s,failed\n", replyTypeOk);
        return (-1);
    }

    /* ׶ */
    stateMachine = STATE_ERASE; 
    tryTimes = ACK_TRY_TIME;    
    printf("dealwith_type_cmd ok\n"); 
    return (0);   
}


/*******************************************************************************
*   : dealwith_erase_cmd
*     : hdcvi: 
*     : 
*     : 
* ֵ  : < 0:ʧܡ
*           ==0:ɹ 
*******************************************************************************/
static int dealwith_erase_cmd(void)
{
    int         ret;
    u8          cmd_buf[CMD_LEN];

    memset(cmd_buf, 0, CMD_LEN);
    ret = hdcvi_read(cmd_buf, CMD_LEN);
    if (ret < 0 )
    { 
        //printf("dealwith_erase_cmd: hdcvi_read,failed \n");
        return (-1);
    }

    printf("dealwith_erase_cmd: %x, %x, %x, \n", 
            cmd_buf[0],
            cmd_buf[1],
            cmd_buf[2]); 
    
    /* Уͷ */
    ret = memcmp(cmd_buf, cmdErase, sizeof(cmdErase));
    if (0 != ret)
    { 
        printf("dealwith_erase_cmd: memcmp,failed \n");
        return (-1);
    }

    /* ظɹ */    
    ret = hdcvi_reply(replyEraseOk, sizeof(replyEraseOk));
    if (ret < 0)
    {
        printf("reply_typok:%s,failed\n", replyEraseOk);
        return (-1);
    }

    /* ֪ͨݰհУ׶ */
    stateMachine = STATE_RX485_FRAME; 
    tryTimes = FRAM_TRY_TIME;
    printf("dealwith_erase_cmd ok\n");
    return (0);
}


/*******************************************************************************
*   : dealwith_frame_end
*     : hdcvi:֡շִ    
*     : 
*     : 
* ֵ  : < 0:ʧܡ
*           ==0:ɹ 
*******************************************************************************/
static int dealwith_frame_end(void)
{
    int          ret;
    char         recvBuf[CMD_LEN];
      
    memset(recvBuf, 0, CMD_LEN);
    ret = hdcvi_read(recvBuf, CMD_LEN);
    if (ret < 0 )
    {   
        return (-1);
    }

    /* ֡շ */
    ret = memcmp(recvBuf, frmEnd, sizeof(frmEnd));
    if (0 != ret)
    {   
        return (-1);
    }
    
    /* ֡ȡдݽ׶ */
    stateMachine = STATE_FRAME_END;  
    tryTimes = ACK_TRY_TIME;
    return (0);
}


/*******************************************************************************
*   : hdcvi_reply_up_result
*     : hdcvi:ظ         
*     : 
*     : 
* ֵ  : < 0:ʧܡ
*           ==0:ɹ 
*******************************************************************************/
int hdcvi_reply_up_result(int result)
{
    int             len, ret = 0;
    u8              *pReply;

    /* ظ */
    if (STATE_UPGRADE_WR == result)
    {
        pReply = replyWrFlash;
        len    = sizeof(replyWrFlash);
    }
    else if (STATE_UPGRADE_DONE == result)
    {
        pReply = replyUpSucc;
        len    = sizeof(replyUpSucc);
    } 
    else if (STATE_UPGRADE_ERR == result)
    {
        pReply = replyUpFail;
        len    = sizeof(replyUpFail);
    }
    else
    { 
       printf("result: %x invalid!\n", result); 
       return (-1);
    }

    ret = hdcvi_reply(pReply, len);
    if (ret < 0)
    {
        printf("replyTypeOk:%s,failed\n", replyUpSucc);
        return (-1);
    }
 
    return (0);
}


/*******************************************************************************
*   : hdcvi_recv_data
*     : fifoݶȡȫֻbuf 
*     : 
*  
*     : 
* ֵ  :  
*******************************************************************************/
static void hdcvi_recv_data(void)
{  
    u8 dataLen;
    #ifdef UPDT_DEBUG
    static u8 i = 0;
    #endif

    /* ȡݳȼĴ */
    dataLen = PREG_DVR2CAM_CAP;

    #ifdef UPDT_DEBUG    
        printf ("\n Recv dataLen = %d \n", dataLen);     
    #endif
    
    if (dataLen > 0)
    {
        switch (stateMachine)
        {
            /* ֡ʱԽһݿʼʱ1ӣ1ݹ
                  ˵֡ʧܣط֡*/
            case STATE_RX485_FRAME:
            {
                tryTimes = FRAM_TRY_TIME;
                break;
            }

            /* ÷֧뱣boot̬µȴ1ʱΪյ
                  ޸ĳ6*/
            case STATE_BOOT_START:
            {                
                break;
            }

            default:
            {
                tryTimes = ACK_TRY_TIME;
                break;
            }
        }
        
    }
    
    while (dataLen > 0)
    {
        if (recvBuf.count >= (BUF_LENGTH - 1))
        { 
            printf("\n no cirSpace left\n");
            return;
        } 
        
        /* ӼĴжȡ */
        recvBuf.rxBuf[recvBuf.writePos] = PREG_DVR2CAM_DAT;    

        #ifdef UPDT_DEBUG  
            printf ("0x%x, ", recvBuf.rxBuf[recvBuf.writePos]);
            i++;   
        #endif
        
        recvBuf.count++;
        recvBuf.writePos++;
        recvBuf.writePos = (recvBuf.writePos % BUF_LENGTH);   
        dataLen--;
    }

    #ifdef UPDT_DEBUG
        if (32 == i)
        { 
           printf ("\n");
           i = 0;
        }
    #endif
    
}



/*******************************************************************************
*   : pack_write
*     : hdcvi:дFlashظ         
*     : 
*     : 
* ֵ  : < 0:ʧܡ
*           ==0:ɹ 
*******************************************************************************/
static int hdcvi_pack_write(void)
{
    u32     i;
    int     ret = 0;
    u8      *saveMemAddr;

    /* ýӿڲд */
    saveMemAddr = packMemAddr;
    
    printf("\n hdcvi_pack_write: \n");
    printf("\n packTotalSize: %d \n", packTotalSize); 

    ret = pack_write((unsigned long)saveMemAddr, pBd);
    if (ret < 0)
    {      
        printf("pack_write failed!\n");

        return (-1);
    } 
    
    return 0;
}



/*******************************************************************************
*   : hdcvi_upgrade
*     : hdcviӿ: շӦͻظݴ洢д.         
*     : 
*     : 
* ֵ  :             
*******************************************************************************/
int hdcvi_upgrade(void)
{
    int     ret, i = 0, feedtime = 0;

    if (NULL == pBd)
    {
        return (-1);
    }

    if (UP_START != updateFlag)
    {
        return (-1);
    } 
    
    printf("-----------hdcvi_upgrade---------\n"); 
    while(1)
    { 
        hdcvi_recv_data(); /* ݽ */
        
        if (WDT_FEED_TIME == feedtime)
        {
            hdcvi_wdt_feed();  
            feedtime = 0;
        }

        feedtime++;

        if (STATE_RX485_FRAME == stateMachine)
        {
            if (tryTimes > 0)
            {
                /* ݽУ */
                ret = hdcvi_framCheckRecv(); 
                if (ret < 0)
                {      
                    tryTimes--;
                    hdcvi_delay_ms(DELAY_M_SEC);
                }
                
                dealwith_frame_end();
                
                continue;  
            }
            
            printf("frame_recv Or frame_end: Failed!\n");
            goto upgardeFailed; 
        } 
        
        if (STATE_BOOT_START == stateMachine)
        {   
            if (tryTimes > 0)
            {
                ret = hdcvi_upgrade_start();
                if (ret < 0)
                { 
                    tryTimes--;
                    hdcvi_delay_ms(DELAY_M_SEC); 
                }
                
                continue;  
            }
            
            printf("hdcvi_upgrade_start failed!\n");
            goto upgardeExit;
        }
        
        if (STATE_VER_CK == stateMachine)
        {
            if (tryTimes > 0)
            {
                /* Э汾У */
                ret = dealwith_version_check();
                if (ret < 0)
                {      
                    tryTimes--; 
                    hdcvi_delay_ms(DELAY_M_SEC);
                }
                
                continue;  
            }
            
            printf("dealwith_version_check failed\n");   
            goto upgardeFailed;
        }

        if (STATE_PDT_NAME_CK == stateMachine)
        {
            if (tryTimes > 0)
            {
                /* 豸У */
                ret = dealwith_pdtname_check();
                if (ret < 0)
                {      
                    tryTimes--; 
                    hdcvi_delay_ms(DELAY_M_SEC);
                }
                
                continue;  
            }
            
            printf("dealwith_pdtname_check failed\n");
            goto upgardeFailed;
        }

        if (STATE_CHGB == stateMachine)
        {
            if (tryTimes > 0)
            {
                /* У */
                ret = dealwith_chgb_cmd();
                if (ret < 0)
                {      
                    tryTimes--; 
                    hdcvi_delay_ms(DELAY_M_SEC);
                }
                
                continue;  
            }
            
            printf("dealwith_chgb_cmd failed!\n");
            goto upgardeFailed;
        }
        
        if (STATE_TYPE_CK == stateMachine)
        {
            if (tryTimes > 0)
            {
                /* У */
                ret = dealwith_type_cmd();
                if (ret < 0)
                {      
                    tryTimes--; 
                    hdcvi_delay_ms(DELAY_M_SEC);
                }
                
                continue;  
            }
            
            printf("type_check failed!\n");
            goto upgardeFailed;
        }

        if (STATE_ERASE == stateMachine)
        {
            if (tryTimes > 0)
            {
                /* ȴʹ׶ */
                ret = dealwith_erase_cmd();
                if (ret < 0)
                {      
                    tryTimes--; 
                    hdcvi_delay_ms(DELAY_M_SEC);
                }
                
                continue;  
            }
            
            printf("dealwith_erase_cmd failed!\n");
            goto upgardeFailed;
        }

        if (STATE_FRAME_END == stateMachine)
        {
            /* д */
            printf("STATE_FRAME_END!\n");
            
            ret = hdcvi_pack_write();
            if (ret < 0)
            {       
                 printf("pack_write failed!!\n");      
                 goto upgardeFailed; 
            } 
            
            printf("upgrade pack_write done!!\n");

            /* ־appֹļVideoDaemon û
                  ־ѱ´ζϵ󣬲״̬ */
            //update_flag_clear();
            ret = hdcvi_reply_up_result(STATE_UPGRADE_DONE); 
            if (ret < 0)
            {       
                 printf("hdcvi_reply_up_result success failed!!\n");      
                 goto upgardeFailed; 
            }
            
            printf("hdcvi_upgrade success !\n");
            goto upgardeExit; 
        }
 
    }
    
    
upgardeFailed:
    
    hdcvi_reply_up_result(STATE_UPGRADE_ERR);
    
    printf("hdcvi_upgrade failed!\n");
    
upgardeExit:
    
    printf("hdcvi_upgrade Exit!\n");
    
    hdcvi_rs485_deinit();
    
    return (0);
}


/*******************************************************************************
*   : hdcvi_upgrade_cmd_fun
*     : ʽhdcviӿڣá
*          
*     :   
*     : 
* ֵ  :             
*******************************************************************************/
int hdcvi_upgrade_cmd_fun(cmd_tbl_t *cmdtp, bd_t *bd, int flag,
                          int       argc,   char *argv[])
{
    return hdcvi_upgrade();
} 

