/*
 * (C) Copyright 2002
 * Sysgo Real-Time Solutions, GmbH <www.elinos.com>
 * Marius Groeger <mgroeger@sysgo.de>
 *
 * (C) Copyright 2002
 * Sysgo Real-Time Solutions, GmbH <www.elinos.com>
 * Alex Zuepke <azu@sysgo.de>
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

/*
 * CPU specific code
 */

#include "armboot.h"
#include "command.h"
#include <config.h>

#ifdef CONFIG_CK510

ulong _armboot_real_end;
ulong _armboot_start;
ulong _armboot_end;
ulong _armboot_relocation;
ulong _armboot_saddr;
ulong _armboot_eaddr;

void BreakHere(void)	{__asm__("bkpt");}

void reset_cpu(u8 priority )
{
	unsigned int * pr1 = (unsigned int *)0x6F000000;
	unsigned int * pr2 = (unsigned int *)0x6F000004;
	
	if (priority)//high prio
	{
		*pr1 = 0xfd31b759;
		*pr2 = 0x846a02ce;
  }
	else//low prio
  {
		*pr1 = 0xd31b759f;
		*pr2 = 0xe846a02c;
  }
  
	return 0;
}

/* ckcore init */
void cpu_init(bd_t *bd)
{
	//volatile i;
	  reset_cpu(1);
	  
	  IRQInit();
/*
	  _armboot_start = 0xc0800000;
	  _armboot_end = 0xc081FFFF;
	  i = _armboot_end;*/
   // _armboot_real_end = _armboot_end + CONFIG_STACKSIZE;
   // disable_interrupts();
   
}

void cleanup_before_linux(bd_t *bd)
{
    /*
     * this function is called just before we call linux
     * it prepares the processor for linux
     *
     * we turn off caches etc ...
     * and we set the CPU-speed to 73 MHz - see start.S for details
     */
    disable_interrupts();
}

void do_reset (cmd_tbl_t *cmdtp, bd_t *bd, int flag, int argc, char *argv[])
{
    disable_interrupts();
    BreakHere();
}

void do_reboot (cmd_tbl_t *cmdtp, bd_t *bd, int flag, int argc, char *argv[])
{
#define WD_TIMER        *(volatile unsigned int *)(0x70000038)
#define WD_CW           *(volatile unsigned int *)(0x7000003c)
#define TIME_OUT        (0xFFFFFFF0)    
    WD_TIMER = TIME_OUT;
	WD_CW = 0x1;
}

#endif /* CONFIG_CK510 */
