/*
 * (C) Copyright 2002
 * Sysgo Real-Time Solutions, GmbH <www.elinos.com>
 * Marius Groeger <mgroeger@sysgo.de>
 *
 * (C) Copyright 2002
 * Sysgo Real-Time Solutions, GmbH <www.elinos.com>
 * Alex Zuepke <azu@sysgo.de>
 *
 * Copyright (C) 1999 2000 2001 Erik Mouw (J.A.K.Mouw@its.tudelft.nl)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include "armboot.h"
#ifdef CONFIG_CK510
#include <config.h>
#include <vs28xxuart.h>
#include "irq.h"

#define DHC_UART_BUFFER_MAX     128

static unsigned char g_u8RxdBuf[ DHC_UART_BUFFER_MAX ];
static unsigned int g_u32RxdRdPos;
static unsigned int g_u32RxdWrPos;

int calcUartCnt(int BaudRate, int *UartCnt)
{
	*UartCnt = UART_BAUD(BaudRate);
  return 0;
}

void serial_setbrg(bd_t *bd, int baudrate)
{
  unsigned int reg = 0;
	volatile u8 *	Reg	= (volatile u8 *)(UART_BASE);
	/* set baudrate */
  if (baudrate == 1200) 		 calcUartCnt(1200, &reg);
  else if (baudrate == 9600)   calcUartCnt(9600, &reg);
  else if (baudrate == 19200)  calcUartCnt(19200, &reg);
  else if (baudrate == 38400)  calcUartCnt(38400, &reg);
  else if (baudrate == 57600)  calcUartCnt(57600, &reg);
  else if (baudrate == 115200) calcUartCnt(115200, &reg);
  else hang();
    
    if( 115200 == baudrate )
       reg++; 
  	
  Reg[UART_REG_UBR]	= reg;
   //Reg[UART_REG_UBR]	= 28;	
}

void irq_uart0(void)
{
    
    volatile u8 * Reg = (volatile u8 *)UART_BASE;
    char c;

    while( 1 )
    {
    if ( ( !( Reg[UART_REG_USR] & UART_SR_RXC) ) )
    {
        break;
    }

    c = Reg[UART_REG_UDR];


    g_u8RxdBuf[ g_u32RxdWrPos ] = c;

    g_u32RxdWrPos++;



    if ( g_u32RxdWrPos >= DHC_UART_BUFFER_MAX )
    {
        g_u32RxdWrPos = 0;
    }

    }



}
  
/*
 * Initialise the serial port with the given baudrate. The settings
 * are always 8 data bits, no parity, 1 stop bit, no start bits.
 *
 */
void serial_init(bd_t *bd)
{
	const char *baudrate;
	volatile u8 *	Reg	= (volatile u8 *)(UART_BASE);
	/*
	if ((baudrate = getenv(bd, "baudrate")) != 0)
	{
		bd->bi_baudrate = simple_strtoul(baudrate, NULL, 10);
	}
	*/
	serial_setbrg(bd, bd->bi_baudrate);
	
	g_u32RxdRdPos = 0;
	g_u32RxdWrPos = 0;
	
 	//Reg[UART_REG_UCR]	= UART_CR_RXCIE | UART_CR_RXEN | UART_CR_RXB8 |  UART_CR_TXEN;
 	
 	Reg[UART_REG_UCR]	= UART_CR_RXCIE | UART_CR_RXEN	| UART_CR_TXEN;
 	IRQRequest( IRQ_UART0_ID, irq_uart0, IRQ_INT_TYPE_NORMAL );
 	
 	
 	return (0);
}


/*
 * Output a single byte to the serial port.
 * Wait until UART transmit buffer register empty.
 * when it is empty, tramsmit new data...
 */
void serial_putc(const char c)
{
	volatile u8 * pUart = (volatile u8 *)UART_BASE;
    
 	while (!(pUart[UART_REG_USR] & 0x60));
 
 	//add by zxj 2008-05-26 => for enter
 	if( '\n' == c )
	{
		 	pUart[UART_REG_UDR] = '\r';
		 	while (!(pUart[UART_REG_USR] & 0x40));
	}
 	pUart[UART_REG_UDR] = c;
 	return (0);
}


/*
 * Read a single byte from the serial port. Returns 1 on success, 0
 * otherwise. When the function is succesfull, the character read is
 * written into its argument c.
 */
int serial_tstc(void)
{
		//volatile u8 * Reg = (volatile u8 *)UART_BASE;
	//ulong status;

		//printf("r=%d, w=%d\n", g_u32RxdRdPos,  g_u32RxdWrPos );

	//if ( (!(Reg[UART_REG_USR] & UART_SR_RXC))&&(!(Reg[UART_REG_UDR])) )
	if ( g_u32RxdRdPos == g_u32RxdWrPos )
	{
	    return 0;
    }
	else
    {
		return 1;
    }
	//REG_READ(CUSTAT, status);
	//return (status & Uart_Rx_Data_Ready);
}

/*
 * Read a single byte from the serial port. Returns 1 on success, 0
 * otherwise. When the function is succesfull, the character read is
 * written into its argument c.
 */
int serial_getc(void)
{

#if 0
	volatile u8 * Reg = (volatile u8 *)UART_BASE;
	char c;
	
	while ( (!(Reg[UART_REG_USR] & UART_SR_RXC)) );

 	c = Reg[UART_REG_UDR];
#else
    char c;

    
    while( 1 )
    {
        if ( g_u32RxdRdPos != g_u32RxdWrPos )
        {
            break;
        }
    }
    
    c = g_u8RxdBuf[ g_u32RxdRdPos ];
    
    g_u32RxdRdPos ++;
    
    if ( g_u32RxdRdPos >= DHC_UART_BUFFER_MAX )
    {
        g_u32RxdRdPos = 0;
    }


#endif
 	
 	return (c);
}

void UartFlush(void)
{
         volatile u8 * Reg = (volatile u8 *)UART_BASE;
         u32 cnt = 256;
         u8 ch;
         while (cnt--) ch = Reg[UART_REG_UDR];
         
         	g_u32RxdRdPos = 0;
	g_u32RxdWrPos = 0;
}



#endif /* CONFIG_CK510 */
