/*
 * (C) Copyright 2002
 * Sysgo Real-Time Solutions, GmbH <www.elinos.com>
 * Marius Groeger <mgroeger@sysgo.de>
 *
 * (C) Copyright 2002
 * Sysgo Real-Time Solutions, GmbH <www.elinos.com>
 * Alex Zuepke <azu@sysgo.de>
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

/*
 * CPU specific code
 */

#include "armboot.h"
#include "command.h"
#if 0 
/* read co-processor 15, register #1 (control register) */
static unsigned long read_p15_c1(void)
{
    unsigned long value;

    __asm__ __volatile__(
	"mrc     p15, 0, %0, c1, c0, 0   @ read control reg\n"
	: "=r" (value)
	:
	: "memory");
    printf("p15/c1 is = %08lx\n", value);
    return value;
}

/* write to co-processor 15, register #1 (control register) */
static void write_p15_c1(unsigned long value)
{
    printf("write %08lx to p15/c1\n", value);
    __asm__ __volatile__(
    "mcr     p15, 0, %0, c1, c0, 0   @ write it back\n"
	: "=r" (value)
	:
	: "memory");

    read_p15_c1();
}

static void cp_delay(void)
{
    volatile int i;

    /* copro seems to need some delay between reading and writing */
    for (i=0; i<100; i++);
}
#endif

/* See also ARM Ref. Man. */

void cpu_init(bd_t *bd)
{
    /*
     * setup up stack if necessary
     */
extern void reset_cpu(void);  // choish 20020827

#ifdef CONFIG_USE_IRQ
    IRQ_STACK_START = _armboot_end +
      			CONFIG_STACKSIZE + CONFIG_STACKSIZE_IRQ - 4;
    FIQ_STACK_START = IRQ_STACK_START + CONFIG_STACKSIZE_FIQ;
    _armboot_real_end = FIQ_STACK_START + 4;
#else
    _armboot_real_end = _armboot_end + CONFIG_STACKSIZE;
#endif
   // disable_interrupts();
   
  reset_cpu();  // choish 20020827
}

void cleanup_before_linux(bd_t *bd)
{
    /*
     * this function is called just before we call linux
     * it prepares the processor for linux
     *
     * we turn off caches etc ...
     * and we set the CPU-speed to 73 MHz - see start.S for details
     */
    //unsigned long i;
    disable_interrupts();

    /* turn off I-cache */
	/*Young11-mod */
    /* Protection Unit Enable
    asm ("mrc p15, 0, %0, c1, c0, 0": "=r" (i));
    i &= 0x1000;
    asm ("mcr p15, 0, %0, c1, c0, 0": : "r" (i));
	*/
    /* flush I-cache */
    /*m ("mcr p15, 0, %0, c7, c5, 0": : "r" (i));*/
    
	/*Young11-del
	 Not define CONFIG_ARM7_REVD
	 FIXUP please
	*/
	/*#ifdef CONFIG_ARM7_REVD*/
		/* go to high speed */
	/*    IO_SYSCON3 = (IO_SYSCON3 & ~CLKCTL) | CLKCTL_73;*/
	/*#endif*/

}

void do_reset (cmd_tbl_t *cmdtp, bd_t *bd, int flag, int argc, char *argv[])
{
    //extern void reset_cpu(ulong addr);
//    extern void reset_cpu(void);
    disable_interrupts();
   // reset_cpu();
}

#if 0  
void icache_enable(void)
{
    ulong reg;
    reg = read_p15_c1();
    cp_delay();
    //write_p15_c1(reg | C1_PROTECTION_UNIT);
    //cp_delay();
    write_p15_c1(reg | C1_ICACHE_ON);
}

void icache_disable(void)
{
    ulong reg;
    reg = read_p15_c1();
    cp_delay();
    write_p15_c1(reg & ~C1_ICACHE_ON);
}

int icache_status(void)
{
  	return (read_p15_c1() & C1_ICACHE_ON) != 0;
}

void dcache_enable(void)
{
    ulong reg;
    reg = read_p15_c1();
    cp_delay();
    write_p15_c1(reg | C1_DCACHE_ON);
}

void dcache_disable(void)
{
    ulong reg;
    reg = read_p15_c1();
    cp_delay();
    write_p15_c1(reg & ~C1_DCACHE_ON);
}

int dcache_status(void)
{
    return (read_p15_c1() & C1_DCACHE_ON) != 0;
    return 0;
}
#endif
