#include "armboot.h"
#include "command.h"
#include "synopGMAC.h"
#include "net.h"

#ifdef CONFIG_DRIVER_SYNOPGMAC

#if (CONFIG_COMMANDS & CFG_CMD_NET)
u8 *synopGMACMappedAddr = 0x20000000;
synopGMACdevice *synopGMACdev = NULL;
u8 *RxPackets = NULL;

void synopGMAC_delay(u32 delay)
{
	while (delay--);
	return;
}
s32 synopGMAC_reset (synopGMACdevice * gmacdev ) 
{	
	u32 data = 0;
	synopGMACWriteReg((u32 *)gmacdev->DmaBase, DmaBusMode ,DmaResetOn);
    synopGMAC_delay(DEFAULT_LOOP_VARIABLE);
	data = synopGMACReadReg((u32 *)gmacdev->DmaBase, DmaBusMode);	
	return 0;	
}

u32 synopGMAC_read_phy_id(synopGMACdevice * gmacdev)
{ 
	u32 data = 0;
	u16 temp = 0;
	synopGMAC_read_phy_reg((u32 *)gmacdev->MacBase,gmacdev->PhyBase,PHY_VSC8641_ID1, &temp);
	data = temp<<16;
	synopGMAC_read_phy_reg((u32 *)gmacdev->MacBase,gmacdev->PhyBase,PHY_VSC8641_ID2, &temp);
	data |= temp;
	return data;
}

s32 synopGMAC_check_phy_init (synopGMACdevice * gmacdev) 
{	
	//u32 addr;  
	u16 data,temp;
	s32 status = -ESYNOPGMACNOERR;		
	s32 loop_count;
	u32 tmp;
	loop_count = DEFAULT_LOOP_VARIABLE;
	  /* verify chip id */
    if (synopGMAC_read_phy_id(gmacdev) != 0x00070431)
    {
		TR( "VSC8641 Ethernet chip not found?!\n");
		return 0;
    }else
    {
		TR( "VSC8641 Ethernet chip found!\n" );
	}
	while(loop_count-- > 0)
	{
		status = synopGMAC_read_phy_reg((u32 *)gmacdev->MacBase,gmacdev->PhyBase,PHY_VSC8641_MODESTS, &data);
		if(status)	
		{
			TR("==PHY_VSC8641_ PHY_STATUS_REG %x==\n", status);
			return status;
		}

	    if((data & Mii_AutoNegCmplt) != 0)
		{
			TR("Autonegotiation Complete data = %x\n",data);
			break;
		}
	}
	
	status = synopGMAC_read_phy_reg((u32 *)gmacdev->MacBase,gmacdev->PhyBase,PHY_VSC8641_MODESTS, &data);
	if(status)
	{
		TR("==PHY_VSC8641_ PHY_SPECIFIC_STATUS_REG %x==\n", status);
		return status;
	}

    if((data & PHY_VSC8641_MODESTS_LNKSTS) == 0)
	{
		TR("No Link\n");
		gmacdev->LinkState = LINKDOWN; 
		return -ESYNOPGMACPHYERR;
	}
	else
	{
		gmacdev->LinkState = LINKUP; 
		TR("Link UP\n");
	}
	
	status = synopGMAC_read_phy_reg((u32 *)gmacdev->MacBase,gmacdev->PhyBase,PHY_VSC8641_AUX_CTRL_STS, &data);
	if(status)
	{
		TR("==PHY_VSC8641_ PHY_SPECIFIC_STATUS_REG %x==\n", status);
		return status;
	}

	gmacdev->DuplexMode = (data & (0x01<<5))  ? FULLDUPLEX: HALFDUPLEX ;
	TR("Link is up in %s mode data = %x\n",(gmacdev->DuplexMode == FULLDUPLEX) ? "FULL DUPLEX": "HALF DUPLEX",data);

	/*if not set to Master configuration in case of Half duplex mode set it manually as Master*/
	if(gmacdev->DuplexMode == HALFDUPLEX)
	{
		status = synopGMAC_read_phy_reg((u32 *)gmacdev->MacBase,gmacdev->PhyBase,PHY_CONTROL_REG, &data);
		if(status)
		{
			TR("==PHY_VSC8641_ read PHY_CONTROL_REG %x==\n", status);
			return status;
		}
		
		status = synopGMAC_write_phy_reg((u32 *)gmacdev->MacBase,gmacdev->PhyBase,PHY_CONTROL_REG, data | Mii_Manual_Master_Config );
		if(status)
		{
			TR("==PHY_VSC8641_ write PHY_CONTROL_REG %x==\n", status);
			return status;
		}		
	}
	
	status = synopGMAC_read_phy_reg((u32 *)gmacdev->MacBase,gmacdev->PhyBase,PHY_VSC8641_AUX_CTRL_STS, &data);
	if(status)
		return status;
	temp = (data & (0x03<<3))>>3;
	if(temp == 2)
	{
	    gmacdev->Speed      =   SPEED1000;
		TR("Link is with 1000M Speed \n");
	}
	else if(temp == 1)
	{
		gmacdev->Speed      =   SPEED100;
		TR("Link is with 100M Speed \n");
	}
	else 
	{
		gmacdev->Speed      =   SPEED10;
		TR("Link is with 10M Speed \n");
	}

	return -ESYNOPGMACNOERR;
}

s32 synopGMAC_read_version (synopGMACdevice * gmacdev) 
{	
	u32 data = 0;
	data = synopGMACReadReg((u32 *)gmacdev->MacBase, GmacVersion );
	gmacdev->Version = data;
	TR("The data read from %08x is %08x\n",(gmacdev->MacBase+GmacVersion),data);
	return 0;
}
s32 synopGMAC_set_mdc_clk_div(synopGMACdevice *gmacdev,u32 clk_div_val)
{
	u32 orig_data;
	orig_data = synopGMACReadReg((u32 *)gmacdev->MacBase,GmacGmiiAddr); //set the mdc clock to the user defined value
	orig_data &= (~ GmiiCsrClkMask);	   
	orig_data |= clk_div_val;
	synopGMACWriteReg((u32 *)gmacdev->MacBase, GmacGmiiAddr ,orig_data);
	return 0;
}
u32 synopGMAC_get_mdc_clk_div(synopGMACdevice *gmacdev)
{
	u32 data;
	data = synopGMACReadReg((u32 *)gmacdev->MacBase,GmacGmiiAddr);
	data &= GmiiCsrClkMask;
	return data;
}
s32 synopGMAC_get_mac_addr(synopGMACdevice *gmacdev, u32 MacHigh, u32 MacLow, u8 *MacAddr)
{
	u32 data;		
	data = synopGMACReadReg((u32 *)gmacdev->MacBase,MacHigh);
	MacAddr[5] = (data >> 8) & 0xff;
	MacAddr[4] = (data)      & 0xff;

	data = synopGMACReadReg((u32 *)gmacdev->MacBase,MacLow);
	MacAddr[3] = (data >> 24) & 0xff;
	MacAddr[2] = (data >> 16) & 0xff;
	MacAddr[1] = (data >> 8 ) & 0xff;
	MacAddr[0] = (data )      & 0xff;

	return 0;
}

s32 synopGMAC_set_mac_addr(synopGMACdevice *gmacdev, u32 MacHigh, u32 MacLow, u8 *MacAddr)
{
	u32 data;
	
	data = (MacAddr[5] << 8) | MacAddr[4];
	synopGMACWriteReg((u32 *)gmacdev->MacBase,MacHigh,data);
	data = (MacAddr[3] << 24) | (MacAddr[2] << 16) | (MacAddr[1] << 8) | MacAddr[0] ;
	synopGMACWriteReg((u32 *)gmacdev->MacBase,MacLow,data);
	return 0;
}
void synopGMAC_desc_init_ring(DmaDesc *desc)
{
	desc->status = 0;//TxDescEndOfRing;
	desc->length = 0;
	desc->buffer1 = 0;
	desc->buffer2 = 0;
	desc->data1 = 0;
	desc->data2 = 0;
	return;
}

static u32 synopGMACReadReg(u32 *RegBase, u32 RegOffset)
{

  u32 addr = (u32)RegBase + RegOffset;
  u32 data = *(volatile u32 *)addr;
  return data;
}

static void   synopGMACWriteReg(u32 *RegBase, u32 RegOffset, u32 RegData)
{

  u32 addr = (u32)RegBase + RegOffset;
  *(volatile u32 *)addr = RegData;
  return;
}
s32 synopGMAC_read_phy_reg(u32 *RegBase,u32 PhyBase, u32 RegOffset, u16 * data)
{
	u32 addr;
	u32 loop_variable;
	addr = ((PhyBase << GmiiDevShift) & GmiiDevMask) | ((RegOffset << GmiiRegShift) & GmiiRegMask);
	addr = addr | GmiiBusy ; //Gmii busy bit
	synopGMACWriteReg(RegBase,GmacGmiiAddr,addr); //write the address from where the data to be read in GmiiGmiiAddr register of synopGMAC ip

    for(loop_variable = 0; loop_variable < DEFAULT_LOOP_VARIABLE; loop_variable++)
	{ //Wait till the busy bit gets cleared with in a certain amount of time
        if (!(synopGMACReadReg(RegBase,GmacGmiiAddr) & GmiiBusy))
		{
        	break;
		}
    	synopGMAC_delay(DEFAULT_DELAY_VARIABLE);
    }
    if(loop_variable < DEFAULT_LOOP_VARIABLE)
    {
        *data = (u16)(synopGMACReadReg(RegBase,GmacGmiiData) & 0xFFFF);
    }else
    {
        TR("Error::: PHY not responding Busy bit didnot get cleared !!!!!!\n");
		return -ESYNOPGMACPHYERR;
    }
	return -ESYNOPGMACNOERR;
}

s32 synopGMAC_write_phy_reg(u32 *RegBase, u32 PhyBase, u32 RegOffset, u16 data)
{
	u32 addr;
	u32 loop_variable;

	synopGMACWriteReg(RegBase,GmacGmiiData,data); // write the data in to GmacGmiiData register of synopGMAC ip

	addr = ((PhyBase << GmiiDevShift) & GmiiDevMask) | ((RegOffset << GmiiRegShift) & GmiiRegMask) | GmiiWrite;

	addr = addr | GmiiBusy ; //set Gmii clk to 20-35 Mhz and Gmii busy bit
	 
	synopGMACWriteReg(RegBase,GmacGmiiAddr,addr);
    for(loop_variable = 0; loop_variable < DEFAULT_LOOP_VARIABLE; loop_variable++)
	{
        if (!(synopGMACReadReg(RegBase,GmacGmiiAddr) & GmiiBusy))
		{
            break;
        }
        synopGMAC_delay(DEFAULT_DELAY_VARIABLE);
    }

    if(loop_variable < DEFAULT_LOOP_VARIABLE)
	{
		return -ESYNOPGMACNOERR;
	}else
	{
    	TR("Error::: PHY not responding Busy bit didnot get cleared !!!!!!\n");
		return -ESYNOPGMACPHYERR;
    }
}
s32 synopGMAC_attach (synopGMACdevice * gmacdev, u32 macBase, u32 dmaBase, u32 phyBase) 
{
	/*Make sure the Device data strucure is cleared before we proceed further*/
	memset((void *) gmacdev,0,sizeof(synopGMACdevice));
	/*Populate the mac and dma base addresses*/
	gmacdev->MacBase = macBase;
	gmacdev->DmaBase = dmaBase;
	gmacdev->PhyBase = phyBase;	
	return 0;	
}
s32 synopGMAC_dma_bus_mode_init(synopGMACdevice * gmacdev, u32 init_value )
{
	synopGMACWriteReg((u32 *)gmacdev->DmaBase, DmaBusMode ,init_value);
	return 0;

}
s32 synopGMAC_dma_control_init(synopGMACdevice * gmacdev, u32 init_value)
{
	synopGMACWriteReg((u32 *)gmacdev->DmaBase, DmaControl, init_value);
	return 0;
}
static void  synopGMACSetBits(u32 *RegBase, u32 RegOffset, u32 BitPos)
{
  u32 addr = (u32)RegBase + RegOffset;
  u32 data = *(volatile u32 *)addr;
  data |= BitPos; 
  *(volatile u32 *)addr = data;
  return;
}

static void  synopGMACClearBits(u32 *RegBase, u32 RegOffset, u32 BitPos)
{
  u32 addr = (u32)RegBase + RegOffset;
  u32 data = *(volatile u32 *)addr;
  data &= (~BitPos); 
  *(volatile u32 *)addr = data;
  return;
}

void synopGMAC_wd_enable(synopGMACdevice * gmacdev)
{
	synopGMACClearBits((u32 *)gmacdev->MacBase, GmacConfig, GmacWatchdog);
	return;
}
void synopGMAC_jab_enable(synopGMACdevice * gmacdev)
{
	synopGMACSetBits((u32 *)gmacdev->MacBase, GmacConfig, GmacJabber);
	return;
}
void synopGMAC_frame_burst_enable(synopGMACdevice * gmacdev)
{
	synopGMACSetBits((u32 *)gmacdev->MacBase, GmacConfig, GmacFrameBurst);
	return;
}
void synopGMAC_set_full_duplex(synopGMACdevice * gmacdev)
{
	synopGMACSetBits((u32 *)gmacdev->MacBase, GmacConfig, GmacDuplex);
	return;
}
void synopGMAC_set_half_duplex(synopGMACdevice * gmacdev)
{
	synopGMACClearBits((u32 *)gmacdev->MacBase, GmacConfig, GmacDuplex);
	return;
}

void synopGMAC_rx_enable(synopGMACdevice * gmacdev)
{
	synopGMACSetBits((u32 *)gmacdev->MacBase, GmacConfig, GmacRx);
	return;
}
void synopGMAC_rx_disable(synopGMACdevice * gmacdev)
{
	synopGMACClearBits((u32 *)gmacdev->MacBase, GmacConfig, GmacRx);
	return;
}

void synopGMAC_tx_enable(synopGMACdevice * gmacdev)
{
	synopGMACSetBits((u32 *)gmacdev->MacBase, GmacConfig, GmacTx);
	return;
}
void synopGMAC_tx_disable(synopGMACdevice * gmacdev)
{
	synopGMACClearBits((u32 *)gmacdev->MacBase, GmacConfig, GmacTx);
	return;
}

void synopGMAC_select_gmii(synopGMACdevice * gmacdev)
{
	synopGMACClearBits((u32 *)gmacdev->MacBase, GmacConfig, GmacMiiGmii);
	return;
}
void synopGMAC_select_mii(synopGMACdevice * gmacdev)
{
	synopGMACSetBits((u32 *)gmacdev->MacBase, GmacConfig, GmacMiiGmii);
	return;
}

void synopGMAC_pause_control(synopGMACdevice *gmacdev)
{
	u32 omr_reg;
	u32 mac_flow_control_reg;
	omr_reg = synopGMACReadReg((u32 *)gmacdev->DmaBase,DmaControl);
	omr_reg |= DmaRxFlowCtrlAct4K | DmaRxFlowCtrlDeact5K |DmaEnHwFlowCtrl;
	synopGMACWriteReg((u32 *)gmacdev->DmaBase, DmaControl, omr_reg);

	mac_flow_control_reg = synopGMACReadReg((u32 *)gmacdev->MacBase,GmacFlowControl);
	mac_flow_control_reg |= GmacRxFlowControl | GmacTxFlowControl | 0xFFFF0000;
	synopGMACWriteReg((u32 *)gmacdev->MacBase,GmacFlowControl,mac_flow_control_reg);

	return;

}
void synopGMAC_resume_dma_tx(synopGMACdevice * gmacdev)
{
	synopGMACWriteReg((u32 *)gmacdev->DmaBase, DmaTxPollDemand, 0);

}

void synopGMAC_enable_dma_tx(synopGMACdevice * gmacdev)
{
	u32 data;
	data = synopGMACReadReg((u32 *)gmacdev->DmaBase, DmaControl);
  	data |= DmaTxStart; 
	synopGMACWriteReg((u32 *)gmacdev->DmaBase, DmaControl ,data);

}

void synopGMAC_disable_dma_tx(synopGMACdevice * gmacdev)
{
	u32 data;
	data = synopGMACReadReg((u32 *)gmacdev->DmaBase, DmaControl);
  	data &= (~DmaTxStart); 
	synopGMACWriteReg((u32 *)gmacdev->DmaBase, DmaControl ,data);

}
void synopGMAC_enable_dma_rx(synopGMACdevice * gmacdev)
{
	u32 data;
	data = synopGMACReadReg((u32 *)gmacdev->DmaBase, DmaControl);
  	data |= DmaRxStart; 
	synopGMACWriteReg((u32 *)gmacdev->DmaBase, DmaControl ,data);

}

void synopGMAC_disable_dma_rx(synopGMACdevice * gmacdev)
{
	u32 data;
	data = synopGMACReadReg((u32 *)gmacdev->DmaBase, DmaControl);
  	data &= (~DmaRxStart); 
	synopGMACWriteReg((u32 *)gmacdev->DmaBase, DmaControl ,data);

}
/*

void synopGMAC_disable_interrupt_all(synopGMACdevice *gmacdev)
{
	synopGMACWriteReg((u32 *)gmacdev->DmaBase, DmaInterrupt, 0);
	return;
}
*/

s32 synopGMAC_setup_tx_desc_queue(synopGMACdevice * gmacdev,u32 no_of_desc, u32 desc_mode)
{
	s32 i;

	DmaDesc *first_desc = NULL;
	//dma_addr_t dma_addr;
	gmacdev->TxDescCount = 0;

	first_desc = malloc(sizeof(DmaDesc) * no_of_desc);
	if(first_desc == NULL)
	{
		TR("Error in Tx Descriptors memory allocation\n");
		return -ESYNOPGMACNOMEM;
	}
	gmacdev->TxDescCount = no_of_desc;
	gmacdev->TxDesc      = first_desc;
	gmacdev->TxDescDma   = first_desc;
	
	for(i =0; i < gmacdev->TxDescCount; i++)
	{	
		synopGMAC_tx_desc_init_ring(gmacdev->TxDesc + i, i == gmacdev->TxDescCount-1);
	}

	gmacdev->TxNext = 0;
	gmacdev->TxBusy = 0;
	gmacdev->TxNextDesc = gmacdev->TxDesc;
	gmacdev->TxBusyDesc = gmacdev->TxDesc;
	gmacdev->BusyTxDesc  = 0; 

	return -ESYNOPGMACNOERR;
}


void synopGMAC_init_tx_desc_base(synopGMACdevice *gmacdev)
{
	synopGMACWriteReg((u32 *)gmacdev->DmaBase,DmaTxBaseAddr,(u32)gmacdev->TxDescDma);
	return;
}
void synopGMAC_init_rx_desc_base(synopGMACdevice *gmacdev)
{
	synopGMACWriteReg((u32 *)gmacdev->DmaBase,DmaRxBaseAddr,(u32)gmacdev->RxDescDma);
	return;
}
s32 synopGMAC_setup_rx_desc_queue(synopGMACdevice * gmacdev,u32 no_of_desc, u32 desc_mode)
{
	s32 i;
	DmaDesc *first_desc = NULL;
	dma_addr_t dma_addr;
	gmacdev->RxDescCount = 0;

	if(desc_mode == RINGMODE)
	{
	
		first_desc = malloc (sizeof(DmaDesc) * no_of_desc);
		if(first_desc == NULL)
		{
			TR("Error in Rx Descriptor Memory allocation in Ring mode\n");
			return -ESYNOPGMACNOMEM;
		}
		gmacdev->RxDescCount = no_of_desc;
		gmacdev->RxDesc      = first_desc;
		gmacdev->RxDescDma   = first_desc;
		
		for(i =0; i < gmacdev->RxDescCount; i++)
		{
			synopGMAC_rx_desc_init_ring(gmacdev->RxDesc + i, i == gmacdev->RxDescCount-1);
		}

	}

	gmacdev->RxNext = 0;
	gmacdev->RxBusy = 0;
	gmacdev->RxNextDesc = gmacdev->RxDesc;
	gmacdev->RxBusyDesc = gmacdev->RxDesc;

	gmacdev->BusyRxDesc   = 0; 

	return -ESYNOPGMACNOERR;
}


void synopGMAC_rx_desc_init_ring(DmaDesc *desc, bool last_ring_desc)
{
	desc->status = 0;
	desc->length = last_ring_desc ? RxDescEndOfRing : 0;
	desc->buffer1 = 0;
	desc->buffer2 = 0;
	desc->data1 = 0;
	desc->data2 = 0;
	return;
}

void synopGMAC_tx_desc_init_ring(DmaDesc *desc, bool last_ring_desc)
{
	#ifdef ENH_DESC
	desc->status = last_ring_desc? TxDescEndOfRing : 0;
	desc->length = 0; 
	#else
	desc->status = 0;
	desc->length = last_ring_desc? TxDescEndOfRing : 0;
	#endif
	desc->buffer1 = 0;
	desc->buffer2 = 0;
	desc->data1 = 0;
	desc->data2 = 0;
	return;
}
bool synopGMAC_is_rx_desc_valid(u32 status)
{
	return ((status & DescError) == 0) && ((status & DescRxFirst) == DescRxFirst) && ((status & DescRxLast) == DescRxLast);
}

bool synopGMAC_is_desc_owned_by_dma(DmaDesc *desc)
{
return ((desc->status & DescOwnByDma) == DescOwnByDma );
}

bool synopGMAC_is_desc_empty(DmaDesc *desc)
{
	return(((desc->length  & DescSize1Mask) == 0) && ((desc->length  & DescSize2Mask) == 0) );
}
bool synopGMAC_is_last_tx_desc(synopGMACdevice * gmacdev,DmaDesc *desc)
{
#ifdef ENH_DESC
	return (((desc->status & TxDescEndOfRing) == TxDescEndOfRing) || ((u32)gmacdev->TxDesc == desc->data2));
#else
	return (((desc->length & TxDescEndOfRing) == TxDescEndOfRing) || ((u32)gmacdev->TxDesc == desc->data2));
#endif
}

bool synopGMAC_is_last_rx_desc(synopGMACdevice * gmacdev,DmaDesc *desc)
{
	return (((desc->length & RxDescEndOfRing) == RxDescEndOfRing) || ((u32)gmacdev->RxDesc == desc->data2));
}
void synopGMAC_tx_checksum_offload_tcp_pseudo(synopGMACdevice *gmacdev, DmaDesc *desc)
{
	#ifdef ENH_DESC
	desc->status = ((desc->status & (~DescTxCisMask)) | DescTxCisTcpPseudoCs);
	#else
	desc->length = ((desc->length & (~DescTxCisMask)) | DescTxCisTcpPseudoCs);
	#endif

}
void synopGMAC_enable_rx_chksum_offload(synopGMACdevice *gmacdev)
{
	synopGMACSetBits((u32 *)gmacdev->MacBase,GmacConfig,GmacRxIpcOffload);
	return;
}

void synopGMAC_rx_tcpip_chksum_drop_enable(synopGMACdevice *gmacdev)
{
	synopGMACClearBits((u32 *)gmacdev->DmaBase,DmaControl,DmaDisableDropTcpCs);
	return;
}


s32 synopGMAC_set_rx_qptr(synopGMACdevice * gmacdev, u32 Buffer1, u32 Length1, u32 Data1, u32 Buffer2, u32 Length2, u32 Data2)
{
	u32  rxnext      = gmacdev->RxNext;
	DmaDesc * rxdesc = gmacdev->RxNextDesc;

	if(!synopGMAC_is_desc_empty(rxdesc))
		return -1;
	rxdesc->length |= (((Length1 <<DescSize1Shift) & DescSize1Mask) | ((Length2 << DescSize2Shift) & DescSize2Mask));

	rxdesc->buffer1 = Buffer1;
	rxdesc->data1 = Data1;

	rxdesc->extstatus = 0;
	rxdesc->reserved1 = 0;
	rxdesc->timestamplow = 0;
	rxdesc->timestamphigh = 0;

	rxdesc->buffer2 = Buffer2;
	rxdesc->data2 = Data2;

	rxdesc->status = DescOwnByDma;

	gmacdev->RxNext     = synopGMAC_is_last_rx_desc(gmacdev,rxdesc) ? 0 : rxnext + 1;
	gmacdev->RxNextDesc = synopGMAC_is_last_rx_desc(gmacdev,rxdesc) ? gmacdev->RxDesc : (rxdesc + 1);

	(gmacdev->BusyRxDesc)++; //One descriptor will be given to Hardware. So busy count incremented by one
	return rxnext;
}


s32 synopGMAC_set_tx_qptr(synopGMACdevice * gmacdev, u32 Buffer1, u32 Length1, u32 Data1, u32 Buffer2, u32 Length2, u32 Data2,u32 offload_needed)
{
	u32  txnext      = gmacdev->TxNext;
	DmaDesc * txdesc = gmacdev->TxNextDesc;
	if(!synopGMAC_is_desc_empty(txdesc))
		return -1;

	(gmacdev->BusyTxDesc)++; //busy tx descriptor is incremented by one as it will be handed over to DMA
		
	txdesc->length |= (((Length1 <<DescSize1Shift) & DescSize1Mask) | ((Length2 <<DescSize2Shift) & DescSize2Mask));
	#ifdef ENH_DESC
	txdesc->status |=  (DescTxFirst | DescTxLast  ); //ENH_DESC DescTxIntEnable
	#else
	txdesc->length |=  (DescTxFirst | DescTxLast  ); //Its always assumed that complete data will fit in to one descriptor
	#endif

 	txdesc->buffer1 = Buffer1;
	txdesc->data1 = Data1;

 	txdesc->buffer2 = Buffer2;
	txdesc->data2 = Data2;
	#ifdef IPC_OFFLOAD
	synopGMAC_tx_checksum_offload_tcp_pseudo(gmacdev, txdesc);
	#endif
	#ifdef ENH_DESC	
	txdesc->status |= DescOwnByDma;//ENH_DESC
	#else
	txdesc->status = DescOwnByDma;
	#endif

	gmacdev->TxNext = synopGMAC_is_last_tx_desc(gmacdev,txdesc) ? 0 : txnext + 1;
	gmacdev->TxNextDesc = synopGMAC_is_last_tx_desc(gmacdev,txdesc) ? gmacdev->TxDesc : (txdesc + 1);
	return txnext;	
}

s32 synopGMAC_get_rx_qptr(synopGMACdevice * gmacdev, u32 * Status, u32 * Buffer1, u32 * Length1, u32 * Data1, u32 * Buffer2, u32 * Length2, u32 * Data2,
                          u32 * Ext_Status, u32 * Time_Stamp_High, u32 * Time_Stamp_Low)
{
	u32 rxnext       = gmacdev->RxBusy;	// index of descriptor the DMA just completed. May be useful when data 
						//is spread over multiple buffers/descriptors
	DmaDesc * rxdesc = gmacdev->RxBusyDesc;
	if(synopGMAC_is_desc_owned_by_dma(rxdesc))
		return -1;
	if(synopGMAC_is_desc_empty(rxdesc))
		return -1;
	

	if(Status != 0)
		*Status = rxdesc->status;// send the status of this descriptor

	if(Ext_Status != 0)
		*Ext_Status = rxdesc->extstatus;
        if(Time_Stamp_High != 0)
		*Time_Stamp_High = rxdesc->timestamphigh; 
        if(Time_Stamp_Low != 0)
		*Time_Stamp_Low = rxdesc->timestamplow; 

	if(Length1 != 0)
		*Length1 = (rxdesc->length & DescSize1Mask) >> DescSize1Shift;
	if(Buffer1 != 0)
		*Buffer1 = rxdesc->buffer1;
	if(Data1 != 0)
		*Data1 = rxdesc->data1;

	if(Length2 != 0)
		*Length2 = (rxdesc->length & DescSize2Mask) >> DescSize2Shift;
	if(Buffer2 != 0)
		*Buffer2 = rxdesc->buffer2;
	if(Data1 != 0)
		*Data2 = rxdesc->data2;

	gmacdev->RxBusy     = synopGMAC_is_last_rx_desc(gmacdev,rxdesc) ? 0 : rxnext + 1;

	gmacdev->RxBusyDesc = synopGMAC_is_last_rx_desc(gmacdev,rxdesc) ? gmacdev->RxDesc : (rxdesc + 1);
	synopGMAC_rx_desc_init_ring(rxdesc, synopGMAC_is_last_rx_desc(gmacdev,rxdesc));

	(gmacdev->BusyRxDesc)--; //busy tx descriptor is reduced by one as it will be handed over to Processor now
	return(rxnext);

}

/*
void synopGMAC_clear_interrupt(synopGMACdevice *gmacdev)
{
	u32 data;
	data = synopGMACReadReg((u32 *)gmacdev->DmaBase, DmaStatus);
	synopGMACWriteReg((u32 *)gmacdev->DmaBase, DmaStatus ,data);
}

void synopGMAC_enable_interrupt(synopGMACdevice *gmacdev, u32 interrupts)
{
	synopGMACWriteReg((u32 *)gmacdev->DmaBase, DmaInterrupt, interrupts);
	return;
}
*/
u32 synopGMAC_get_rx_desc_frame_length(u32 status)
{
	return ((status & DescFrameLengthMask) >> DescFrameLengthShift);
}
/*
void synopGMAC_enable_rx_chksum_offload(synopGMACdevice *gmacdev)
{
	synopGMACSetBits((u32 *)gmacdev->MacBase,GmacConfig,GmacRxIpcOffload);
	return;
}

void synopGMAC_rx_tcpip_chksum_drop_enable(synopGMACdevice *gmacdev)
{
	synopGMACClearBits((u32 *)gmacdev->DmaBase,DmaControl,DmaDisableDropTcpCs);
	return;
}
*/
s32 synopGMAC_get_tx_qptr(synopGMACdevice * gmacdev, u32 * Status, u32 * Buffer1, u32 * Length1, u32 * Data1, u32 * Buffer2, u32 * Length2, u32 * Data2,
                          u32 * Ext_Status, u32 * Time_Stamp_High, u32 * Time_Stamp_Low)
{
	u32  txover      = gmacdev->TxBusy;
	DmaDesc * txdesc = gmacdev->TxBusyDesc;
	
	if(synopGMAC_is_desc_owned_by_dma(txdesc))
		return -1;
	if(synopGMAC_is_desc_empty(txdesc))
		return -1;

	(gmacdev->BusyTxDesc)--; //busy tx descriptor is reduced by one as it will be handed over to Processor now

	if(Status != 0)   
		*Status = txdesc->status;

	if(Ext_Status != 0)
		*Ext_Status = txdesc->extstatus;
        if(Time_Stamp_High != 0)
		*Time_Stamp_High = txdesc->timestamphigh; 
        if(Time_Stamp_Low != 0)
		*Time_Stamp_High = txdesc->timestamplow; 

	if(Buffer1 != 0)
		*Buffer1 = txdesc->buffer1;
	if(Length1 != 0)
		*Length1 = (txdesc->length & DescSize1Mask) >> DescSize1Shift;
	if(Data1 != 0)
		*Data1 = txdesc->data1;

	if(Buffer2 != 0)
		*Buffer2 = txdesc->buffer2;
	if(Length2 != 0)
		*Length2 = (txdesc->length & DescSize2Mask) >> DescSize2Shift;
	if(Data1 != 0)
		*Data2 = txdesc->data2;

	gmacdev->TxBusy     = synopGMAC_is_last_tx_desc(gmacdev,txdesc) ? 0 : txover + 1;
	gmacdev->TxBusyDesc = synopGMAC_is_last_tx_desc(gmacdev,txdesc) ? gmacdev->TxDesc : (txdesc + 1);
	synopGMAC_tx_desc_init_ring(txdesc, synopGMAC_is_last_tx_desc(gmacdev,txdesc));

	return txover;	
}

void synop_handle_transmit_over(synopGMACdevice *gmacdev)
{
	s32 desc_index;
	u32 data1, data2;
	u32 status;
	u32 length1, length2;
	u32 dma_addr1, dma_addr2;
	u32 ext_status;
	u16 time_stamp_higher;
	u32 time_stamp_high;
	u32 time_stamp_low;
	/*Handle the transmit Descriptors*/
	do 
	{
		desc_index	= synopGMAC_get_tx_qptr(gmacdev, &status, &dma_addr1, &length1, &data1, &dma_addr2, &length2, &data2,&ext_status,&time_stamp_high,&time_stamp_low);	
    } while(desc_index >= 0);
}

/*
void synopGMAC_jumbo_frame_disable(synopGMACdevice * gmacdev)
{
	synopGMACClearBits((u32 *)gmacdev->MacBase, GmacConfig, GmacJumboFrame);
	return;
}

void synopGMAC_rx_own_enable(synopGMACdevice * gmacdev)
{
	synopGMACClearBits((u32 *)gmacdev->MacBase, GmacConfig, GmacRxOwn);
	return;
}

void synopGMAC_loopback_off(synopGMACdevice * gmacdev)
{
	synopGMACClearBits((u32 *)gmacdev->MacBase, GmacConfig, GmacLoopback);
	return;
}
void synopGMAC_retry_enable(synopGMACdevice * gmacdev)
{
	synopGMACClearBits((u32 *)gmacdev->MacBase, GmacConfig, GmacRetry);
	return;
}
void synopGMAC_pad_crc_strip_disable(synopGMACdevice * gmacdev)
{
	synopGMACClearBits((u32 *)gmacdev->MacBase, GmacConfig, GmacPadCrcStrip);
	return;
}
void synopGMAC_back_off_limit(synopGMACdevice * gmacdev, u32 value)
{
	u32 data;
	data = synopGMACReadReg((u32 *)gmacdev->MacBase, GmacConfig);
	data &= (~GmacBackoffLimit);
	data |= value;
	synopGMACWriteReg((u32 *)gmacdev->MacBase, GmacConfig,data);
	return;
}
void synopGMAC_deferral_check_disable(synopGMACdevice * gmacdev)
{
	synopGMACClearBits((u32 *)gmacdev->MacBase, GmacConfig, GmacDeferralCheck);
	return;
}
void synopGMAC_unicast_pause_frame_detect_disable(synopGMACdevice * gmacdev)
{
	synopGMACClearBits((u32 *)gmacdev->MacBase, GmacFlowControl, GmacUnicastPauseFrame);
	return;
}
void synopGMAC_rx_flow_control_enable(synopGMACdevice * gmacdev)
{
	synopGMACSetBits((u32 *)gmacdev->MacBase, GmacFlowControl, GmacRxFlowControl);
	return;
}
void synopGMAC_tx_flow_control_enable(synopGMACdevice * gmacdev)
{
	synopGMACSetBits((u32 *)gmacdev->MacBase, GmacFlowControl, GmacTxFlowControl);
	return;
}
*/
s32 synopGMAC_mac_init(synopGMACdevice * gmacdev)
{
	u32 PHYreg;
	//if(gmacdev->DuplexMode == FULLDUPLEX)
	//{
		synopGMAC_wd_enable(gmacdev);
		synopGMAC_jab_enable(gmacdev);
		synopGMAC_frame_burst_enable(gmacdev);
		//synopGMAC_jumbo_frame_disable(gmacdev);
		//synopGMAC_rx_own_enable(gmacdev);
		//synopGMAC_loopback_off(gmacdev);
		synopGMAC_set_full_duplex(gmacdev);
		//synopGMAC_retry_enable(gmacdev);
		//synopGMAC_pad_crc_strip_disable(gmacdev);
		//synopGMAC_back_off_limit(gmacdev,GmacBackoffLimit0);
		//synopGMAC_deferral_check_disable(gmacdev);
		synopGMAC_tx_enable(gmacdev);	
		synopGMAC_rx_enable(gmacdev);

		if(gmacdev->Speed == SPEED1000)
			synopGMAC_select_gmii(gmacdev);
		else
			synopGMAC_select_mii(gmacdev);
	
		/*Flow Control Configuration*/
		//synopGMAC_unicast_pause_frame_detect_disable(gmacdev);
		//synopGMAC_rx_flow_control_enable(gmacdev);
		//synopGMAC_tx_flow_control_enable(gmacdev);
	//}
	#if 0
	else{//for Half Duplex configuration
		
		synopGMAC_wd_enable(gmacdev);
		synopGMAC_jab_enable(gmacdev);
		synopGMAC_frame_burst_enable(gmacdev);
		//synopGMAC_jumbo_frame_disable(gmacdev);
		//synopGMAC_rx_own_enable(gmacdev);
		//synopGMAC_loopback_off(gmacdev);
		synopGMAC_set_half_duplex(gmacdev);
		//synopGMAC_retry_enable(gmacdev);
		//synopGMAC_pad_crc_strip_disable(gmacdev);
		//synopGMAC_back_off_limit(gmacdev,GmacBackoffLimit0);
		//synopGMAC_deferral_check_disable(gmacdev);
		synopGMAC_tx_enable(gmacdev);	
		synopGMAC_rx_enable(gmacdev);

		if(gmacdev->Speed == SPEED1000)
			synopGMAC_select_gmii(gmacdev);
		else
			synopGMAC_select_mii(gmacdev);

		/*Frame Filter Configuration*/
	 	//synopGMAC_frame_filter_enable(gmacdev);
		//synopGMAC_set_pass_control(gmacdev,GmacPassControl0);
		//synopGMAC_broadcast_enable(gmacdev);
		//synopGMAC_src_addr_filter_disable(gmacdev);
		//synopGMAC_multicast_disable(gmacdev);
		//synopGMAC_dst_addr_filter_normal(gmacdev);
		//synopGMAC_multicast_hash_filter_disable(gmacdev);
		//synopGMAC_promisc_disable(gmacdev);
		//synopGMAC_unicast_hash_filter_disable(gmacdev);
		
		/*Flow Control Configuration*/
		//synopGMAC_unicast_pause_frame_detect_disable(gmacdev);
		//synopGMAC_rx_flow_control_disable(gmacdev);
		//synopGMAC_tx_flow_control_disable(gmacdev);

		/*To set PHY register to enable CRS on Transmit*/
		synopGMACWriteReg((u32 *)gmacdev->MacBase, GmacGmiiAddr, GmiiBusy | 0x00000408);
		PHYreg = synopGMACReadReg((u32 *)gmacdev->MacBase,GmacGmiiData);
		synopGMACWriteReg((u32 *)gmacdev->MacBase, GmacGmiiData, PHYreg   | 0x00000800);
		synopGMACWriteReg((u32 *)gmacdev->MacBase, GmacGmiiAddr, GmiiBusy | 0x0000040a);
	}
	#endif
	return 0;
}

s32  synopGMAC_init_network_interface(void)
{
    synopGMACdev = (synopGMACdevice *)malloc(sizeof(synopGMACdevice));
	if(synopGMACdev == NULL)
	{
		printf("Error in synopGMACpcidev Memory Allocataion \n");
		return -1;
	}
	RxPackets = malloc(PKT_BUF_SIZE);
	if(RxPackets == NULL)
	{
		printf("Error in RxPackets Memory Allocataion \n");
		return -1;
	}
	eth_reset();
	synopGMAC_attach(synopGMACdev,(u32)synopGMACMappedAddr + MACBASE,(u32) synopGMACMappedAddr + DMABASE, DEFAULT_PHY_BASE);
	synopGMAC_read_version(synopGMACdev);
	synopGMAC_set_mdc_clk_div(synopGMACdev,GmiiCsrClk3);
	synopGMACdev->ClockDivMdc = synopGMAC_get_mdc_clk_div(synopGMACMappedAddr);
	synopGMAC_check_phy_init(synopGMACdev);
	synopGMAC_setup_tx_desc_queue(synopGMACdev,TRANSMIT_DESC_SIZE, RINGMODE);
	synopGMAC_init_tx_desc_base(synopGMACdev);
	
	synopGMAC_setup_rx_desc_queue(synopGMACdev,TRANSMIT_DESC_SIZE, RINGMODE);
	synopGMAC_init_rx_desc_base(synopGMACdev);
#ifdef ENH_DESC_8W
	synopGMAC_dma_bus_mode_init(synopGMACdev,DmaFixedBurstEnable| DmaBurstLength8 | DmaDescriptorSkip2 | DmaDescriptor8Words ); 
#else
	synopGMAC_dma_bus_mode_init(synopGMACdev,DmaFixedBurstEnable| DmaBurstLength8 | DmaDescriptorSkip2); 
#endif
	synopGMAC_dma_control_init(synopGMACdev,DmaStoreAndForward); 
	synopGMAC_mac_init(synopGMACdev);
	synopGMAC_pause_control(synopGMACdev);
	#ifdef IPC_OFFLOAD
	synopGMAC_enable_rx_chksum_offload(synopGMACdev);	
	synopGMAC_rx_tcpip_chksum_drop_enable(synopGMACdev);
	#endif
 
	synopGMAC_set_rx_qptr(synopGMACdev,(u32)RxPackets,PKT_BUF_SIZE, (u32)RxPackets,0,0,0);
	return 0;

}

static void eth_reset(void)
{
  synopGMAC_reset(synopGMACdev);
}

void eth_halt( void )
{
    //synopGMAC_disable_dma_tx(synopGMACdev);
	//synopGMAC_disable_dma_rx(synopGMACdev);
}

int eth_init( bd_t *bd )
{   
	int i;
	s32 ret;
	u8 mac_addr0[6] = DEFAULT_MAC_ADDRESS;
	ret = synopGMAC_init_network_interface();
	if(ret < 0)
	{
		printf("ethernet init err!\n");
		return -1;
	}
    /* set the ethernet address */
	synopGMAC_set_mac_addr(synopGMACdev,GmacAddr0High,GmacAddr0Low, mac_addr0); 
	for(i = 0; i < 6; i++)
	{
		bd->bi_enetaddr[i] = mac_addr0[i];
	}
    return 0;
}

/* Get a data block via Ethernet */
extern int eth_rx(void)
{
    u32 rxlen,i,err;;
    u32 status,dma_status_reg,dma_addr1;
	u8 *data;
	s32 desc_index;
    synopGMAC_disable_dma_rx(synopGMACdev);
    //do
	{	desc_index = synopGMAC_get_rx_qptr(synopGMACdev, &status, &dma_addr1,NULL,NULL, NULL,NULL,NULL,NULL,NULL,NULL);
		if(desc_index >= 0 && dma_addr1 !=0)
		{
			if(synopGMAC_is_rx_desc_valid(status))
			{
				rxlen =  synopGMAC_get_rx_desc_frame_length(status) - 4;//CRC			
				data = (u8 *)dma_addr1;	
				for( i=0; i<6; i++ )
				{
					if(0xff != data[i])
					{
                        NetReceive(data, rxlen);
                        break;
                    }
						
				}       
				synopGMAC_set_rx_qptr(synopGMACdev,(u32)RxPackets,PKT_BUF_SIZE, (u32)RxPackets,0,0,0);
			}
		}
	}//while(desc_index >= 0);
	synopGMAC_enable_dma_rx(synopGMACdev);
	return 0;

}

/* Send a data block via Ethernet. */
extern int eth_send(volatile void *packet, int length)
{
	s32 status,tmo,s;   
    synopGMAC_disable_dma_tx(synopGMACdev);
	synop_handle_transmit_over(synopGMACdev);
	status = synopGMAC_set_tx_qptr(synopGMACdev, packet,length,packet,0,0,0,0);
	if(status < 0)
	{
		TR("%s No More Free Tx Descriptors\n",__FUNCTION__);
		return -1;
	}
    synopGMAC_enable_dma_tx(synopGMACdev); 	
	return 0;
}

#endif /* COMMANDS & CFG_NET */

#endif /* CONFIG_DRIVER_SYNOPGMAC */
