/*
 * (C) Copyright 2002
 * Jongil Park Samsung Electronics <laminaz@samsung.co.kr>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

/*
 * CRAMFS support
 */
#ifndef	_CMD_CRAMFS_H
#define	_CMD_CRAMFS_H

#if (CONFIG_COMMANDS & CFG_CMD_CRAMFS)
#define	CMD_TBL_CRAMFS	MK_CMD_TBL_ENTRY(				\
	"fsload",	5,	4,	0,	do_cramfs_fsload,	\
	"fsload  - load binary file from a filesystem image\n",	\
	"[ DRAM:Dest ] [ Flash:Src ] [ filename ]\n"					\
	"    - load binary file from flash bank\n"			\
	"      with offset 'off' to DRAM Destination\n"					\
),									\
	MK_CMD_TBL_ENTRY(						\
	"ls",		2,	2,	1,	do_cramfs_ls,		\
	"ls      - list files in a directory (default /)\n",		\
	"[ directory ]\n"						\
	"    - list files in a directory.\n"				\
),

int do_cramfs_fsload (cmd_tbl_t *cmdtp, bd_t *bd, int flag, int argc, char *argv[]);
int do_cramfs_ls (cmd_tbl_t *cmdtp, bd_t *bd, int flag, int argc, char *argv[]);

#else
#define CMD_TBL_CRAMFS
#endif	/* CFG_CMD_CRAMFS */

#endif	/* _CMD_CRAMFS_H */
