/*
 * (C) Copyright 2000
 * Wolfgang Denk, DENX Software Engineering, wd@denx.de.
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

/*
 * FLASH support
 */
#ifndef	_CMD_FLASH_H
#define	_CMD_FLASH_H

#if (CONFIG_COMMANDS & CFG_CMD_FLASH)
/*
#define	CMD_TBL_FLINFO	MK_CMD_TBL_ENTRY(					\
	"flinfo",	3,	2,	1,	do_flinfo,			\
	"flinfo  - print FLASH memory information\n",				\
	"\n    - print information for all FLASH memory banks\n"		\
	"flinfo N\n    - print information for FLASH memory bank # N\n"		\
),

#define	CMD_TBL_FLERASE	MK_CMD_TBL_ENTRY(					\
	"erase",	3,	3,	1,	do_flerase,			\
	"erase   - erase FLASH memory\n",					\
	"start end\n"								\
	"    - erase FLASH from addr 'start' to addr 'end'\n"			\
	"erase N:SF[-SL]\n    - erase sectors SF-SL in FLASH bank # N\n"	\
	"erase bank N\n    - erase FLASH bank # N\n"				\
	"erase all\n    - erase all FLASH banks\n"				\
),

#define	CMD_TBL_PROTECT	MK_CMD_TBL_ENTRY(					\
	"protect",	4,	4,	1,	do_protect,			\
	"protect - enable or disable FLASH write protection\n",			\
	"on  start end\n"							\
	"    - protect FLASH from addr 'start' to addr 'end'\n"			\
	"protect on  N:SF[-SL]\n"						\
	"    - protect sectors SF-SL in FLASH bank # N\n"			\
	"protect on  bank N\n    - protect FLASH bank # N\n"			\
	"protect on  all\n    - protect all FLASH banks\n"			\
	"protect off start end\n"						\
	"    - make FLASH from addr 'start' to addr 'end' writable\n"		\
	"protect off N:SF[-SL]\n"						\
	"    - make sectors SF-SL writable in FLASH bank # N\n"			\
	"protect off bank N\n    - make FLASH bank # N writable\n"		\
	"protect off all\n    - make all FLASH banks writable\n"		\
),

#define	CMD_TBL_FLWRITE	MK_CMD_TBL_ENTRY(					\
	"flwrite",	3,	3,	1,	do_flwrite,			\
	"flwrite - write data into FLASH memory\n",				\
	"DestAddr\n" 								\
	"    - write data into DestAddr(0x000000~0x800000)\n"		\
),
#define	CMD_TBL_FLROM	MK_CMD_TBL_ENTRY(					\
	"flrom",	3,	3,	1,	do_flrom,			\
	"flrom	- write u-boot into FLASH memory\n",				\
	"DestAddr\n" 								\
	"    - write data into DestAddr(0x00000004~u-Boot size)\n"		\
),
*/
//add by zzh

#define	CMD_TBL_FLWRITE	MK_CMD_TBL_ENTRY(					\
	"flwrite",	3,	3,	1,	do_flwrite,			\
	"flwrite - write data into FLASH memory\n",				\
	"DestAddr\n" 								\
	"    - write data into DestAddr(0x000000~0x800000)\n"		\
),

#define	CMD_TBL_FLREAD	MK_CMD_TBL_ENTRY(					\
	"flread",	6,	6,	1,	do_flread,			\
	"flread - read data into FLASH memory\n",				\
	"DestAddr\n" 								\
	"    - read data into DestAddr(0x000000~0x800000)\n"		\
),


#define	CMD_TBL_READ_FLASH	MK_CMD_TBL_ENTRY(					\
	"rflash",	6,	3,	1,	do_read_flash,			\
	"rflash	- read FLASH memory\n",				\
	"DestAddr\n" 								\
	"    - read data from DestAddr(0x00000000~0x00800000)\n"		\
),

#define	CMD_TBL_WRITE_FLASH	MK_CMD_TBL_ENTRY(					\
	"wflash",	6,	3,	1,	do_write_flash,			\
	"wflash	- write data into FLASH memory\n",				\
	"DestAddr\n" 								\
	"    - write data into DestAddr(0x00000000~0x00800000)\n"		\
),

#define	CMD_TBL_ERASE_FLASH	MK_CMD_TBL_ENTRY(					\
	"eflash",	6,	3,	1,	do_erase_flash,			\
	"eflash	- erase FLASH memory\n",				\
	"start end\n" 								\
	"    - erase FLASH from addr 'start' to addr 'end'\n"		\
),

#define	CMD_TBL_WRITE_FILE_TO_FLASH	MK_CMD_TBL_ENTRY(					\
	"write.boot",	10,	3,	1,	do_write_uboot_to_flash,			\
	"write.boot- write uboot file to FLASH memory\n",				\
	"uboot_file_Start_Addr uboot_length\n" 								\
	"    - from fileStartAdd write file to flash uboot area\n"		\
),
//////////////////////////////
#define	CMD_TBL_WRITE_JFFS2FS_TO_FLASH	MK_CMD_TBL_ENTRY(					\
	"write.fs",	8,	4,	1,	do_write_jffs2_to_flash,			\
	"write.fs - write jffs2 file to FLASH memory\n",				\
	"jffs2_file_Start_Addr  jffs2_length\n" 								\
	"    - from fileStartAdd write file to FLASH at flashAddr\n"		\
	"    - write.fs  fileStartAdd  flashAddr  length \n"		\
),


#define	CMD_TBL_WRITE_KERNEL_TO_FLASH	MK_CMD_TBL_ENTRY(					\
	"write.kernel",	12,	3,	1,	do_write_kernel_to_flash,			\
	"write.kernel - write kernel file to flash kernel area memory\n",				\
	"kernel_file_Start_Addr  kernel_length\n" 								\
	"    - from fileStartAdd write file to FLASH\n"		\
),


#define	CMD_TBL_READ_KERNEL_FROM_FLASH	MK_CMD_TBL_ENTRY(					\
	"load.kernel",	11,	3,	1,	do_load_kernel_from_flash,			\
	"load.kernel - load kernel from flash to memory\n",				\
	"flash ddr \n" 								\
	"    - from flash addr load kernel file to memery\n"		\
),

#define	CMD_TBL_ERASE_UBOOT_AREA MK_CMD_TBL_ENTRY(					\
	"erase.boot",	10,	1,	1,	do_erase_uboot,			\
	"erase.boot - boot area erase\n",				\
	"erase uboot area\n" 								\
	"    - erase uboot area\n"		\
),

#define	CMD_TBL_ERASE_KERNEL_AREA	MK_CMD_TBL_ENTRY(					\
	"erase.kernel",	12,	1,	1,	do_erase_kernel,			\
	"erase.kernel - kernel area erase\n",				\
	"erase kernel area\n" 								\
	"    - erase kernel area\n"		\
),


#define	CMD_TBL_ERASE_USER_AREA	MK_CMD_TBL_ENTRY(					\
	"erase.user",	10,	1,	1,	do_erase_user,			\
	"erase.user - user area erase\n",				\
	"erase user area\n" 								\
	"    -erase user area\n"		\
),

#define	CMD_TBL_LOAD_BOOT	MK_CMD_TBL_ENTRY(					\
	"dl.boot",	7,	1,	1,	do_load_boot_from_uart,			\
	"dl.boot - download uboot from uart and write to flash\n",				\
	"download uboot from uart and write to flash\n" 								\
	"    -download uboot from uart and write to flash\n"		\
),


#define	CMD_TBL_LOAD_KERNEL	MK_CMD_TBL_ENTRY(					\
	"dl.kernel",	9,	1,	1,	do_load_kernel_from_uart,			\
	"dl.kernel - download kernel from uart and write to flash\n",				\
	"download kernel from uart and write to flash\n" 								\
	"    -download kernel from uart and write to flash\n"		\
),

#define	CMD_TBL_LOAD_USER MK_CMD_TBL_ENTRY(					\
	"dl.user",	7,	2,	1,	do_load_user_from_uart,			\
	"dl.user - download userfs from uart and write to flash\n",				\
	"download userfs from uart and write to flash\n" 								\
	"    -download userdata from uart and write to flash\n"		\
	"    -dl.user  dstAddr(flashAddr) \n"           \
),

#define CMD_TBL_HDCVI_UPGRADE MK_CMD_TBL_ENTRY(               \
	"hdcvi_upgrade",	5,	1,	1,	hdcvi_upgrade_cmd_fun,    \
	"hdcvi_upgrade   - hdcvi_upgrade test\n",		          \
	"\n    - simple hdcvi_upgrade test\n"                     \
), 


int do_read_flash (cmd_tbl_t *cmdtp, bd_t *bd, int flag, int argc, char *argv[]);
int do_write_flash (cmd_tbl_t *cmdtp, bd_t *bd, int flag, int argc, char *argv[]);
int do_erase_flash (cmd_tbl_t *cmdtp, bd_t *bd, int flag, int argc, char *argv[]);
int do_write_uboot_to_flash (cmd_tbl_t *cmdtp, bd_t *bd, int flag, int argc, char *argv[]);
int do_write_jffs2_to_flash (cmd_tbl_t *cmdtp, bd_t *bd, int flag, int argc, char *argv[]);
int do_write_kernel_to_flash (cmd_tbl_t *cmdtp, bd_t *bd, int flag, int argc, char *argv[]);
int do_load_kernel_from_flash (cmd_tbl_t *cmdtp, bd_t *bd, int flag, int argc, char *argv[]);
int do_erase_uboot (cmd_tbl_t *cmdtp, bd_t *bd, int flag, int argc, char *argv[]);
int do_erase_kernel (cmd_tbl_t *cmdtp, bd_t *bd, int flag, int argc, char *argv[]);
int do_erase_user (cmd_tbl_t *cmdtp, bd_t *bd, int flag, int argc, char *argv[]);
int do_load_boot_from_uart (cmd_tbl_t *cmdtp, bd_t *bd, int flag, int argc, char *argv[]);
int do_load_kernel_from_uart (cmd_tbl_t *cmdtp, bd_t *bd, int flag, int argc, char *argv[]);
int do_load_user_from_uart (cmd_tbl_t *cmdtp, bd_t *bd, int flag, int argc, char *argv[]);
//int do_flinfo (cmd_tbl_t *cmdtp, bd_t *bd, int flag, int argc, char *argv[]);
//int do_flerase(cmd_tbl_t *cmdtp, bd_t *bd, int flag, int argc, char *argv[]);
//int do_protect(cmd_tbl_t *cmdtp, bd_t *bd, int flag, int argc, char *argv[]);
int do_flwrite(cmd_tbl_t *cmdtp, bd_t *bd, int flag, int argc, char *argv[]);
int do_flread(cmd_tbl_t *cmdtp, bd_t *bd, int flag, int argc, char *argv[]);
//int do_flrom(cmd_tbl_t *cmdtp, bd_t *bd, int flag, int argc, char *argv[]);

int hdcvi_upgrade_cmd_fun(cmd_tbl_t *cmdtp, bd_t *bd, int flag, int argc, char *argv[]);

#else
//#define CMD_TBL_FLINFO
//#define CMD_TBL_FLERASE
//#define CMD_TBL_PROTECT
//#define CMD_TBL_FLWRITE
//#define CMD_TBL_FLROM
#endif	/* CFG_CMD_FLASH */



#endif	/* _CMD_FLASH_H */
