/*
 * (C) Copyright 2000
 * Wolfgang Denk, DENX Software Engineering, wd@denx.de.
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

/*
 * Boot support
 */
#ifndef	_CMD_NVEDIT_H
#define	_CMD_NVEDIT_H
typedef struct tag_bootpara
{
    u8 appauto;
    u8 dh_keyboard;
    u8 ethaddr0[6];
    u8 ethaddr1[6];
    u8 lip0[6];//compatible for IPV6
    u8 lip1[6];
    u8 id[32];
    int fd; 
    int debug;
    u8 hwid[256]; //max length 256
    u8 loglevel[12]; 
    u8 wifiAddr[6];
    u8 reserved[46]; /*reversed for future*/
}bootpara;
#define	CMD_TBL_PRINTENV	MK_CMD_TBL_ENTRY(				\
	"printenv",	3,	CFG_MAXARGS,	1,	do_printenv,		\
	"printenv- print environment variables\n",				\
	"\n    - print values of all environment variables\n"			\
	"printenv name ...\n"							\
	"    - print value of environment variable 'name'\n"			\
),
int do_printenv (cmd_tbl_t *cmdtp, bd_t *bd, int flag, int argc, char *argv[]);

#define CMD_TBL_SETENV		MK_CMD_TBL_ENTRY(				\
	"setenv",	3,	CFG_MAXARGS,	0,	do_setenv,		\
	"setenv  - set environment variables\n",				\
	"name value ...\n"							\
	"    - set environment variable 'name' to 'value ...'\n"		\
	"setenv name\n"								\
	"    - delete environment variable 'name'\n"				\
),
int do_setenv   (cmd_tbl_t *cmdtp, bd_t *bd, int flag, int argc, char *argv[]);

#if ((CONFIG_COMMANDS & (CFG_CMD_ENV|CFG_CMD_FLASH)) == (CFG_CMD_ENV|CFG_CMD_FLASH))
#define	CMD_TBL_SAVEENV		MK_CMD_TBL_ENTRY(				\
	"saveenv",	4,	1,		0,	do_saveenv,		\
	"saveenv - save environment variables to persistent storage\n",		\
	NULL									\
),
int do_saveenv  (cmd_tbl_t *cmdtp, bd_t *bd, int flag, int argc, char *argv[]);
#else
#define CMD_TBL_SAVEENV
#endif	/* CFG_CMD_ENV */

#if (CONFIG_COMMANDS & CFG_CMD_ASKENV)
#define CMD_TBL_ASKENV		MK_CMD_TBL_ENTRY(				\
	"askenv",	8,	CFG_MAXARGS,	1,	do_askenv,		\
	"askenv  - get environment variables from stdin\n",			\
	"name [message] [size]\n"						\
	"    - get environment variable 'name' from stdin (max 'size' chars)\n"	\
	"askenv name\n"								\
	"    - get environment variable 'name' from stdin\n"			\
	"askenv name size\n"							\
	"    - get environment variable 'name' from stdin (max 'size' chars)\n"	\
	"askenv name [message] size\n"						\
	"    - display 'message' string and get environment variable 'name'"	\
	"from stdin (max 'size' chars)\n"					\
),
int do_askenv   (cmd_tbl_t *cmdtp, bd_t *bd, int flag, int argc, char *argv[]);
#else
#define CMD_TBL_ASKENV
#endif	/* CFG_CMD_ASKENV */

#if (CONFIG_COMMANDS & CFG_CMD_RUN)
#define	CMD_TBL_RUN	MK_CMD_TBL_ENTRY(					\
	"run",	3,	CFG_MAXARGS,	1,	do_run,				\
	"run     - run commands in an environment variable\n",			\
	"var [...]\n"								\
	"    - run the commands in the environment variable(s) 'var'\n"		\
),
int do_run (cmd_tbl_t *cmdtp, bd_t *bd, int flag, int argc, char *argv[]);
#else
#define CMD_TBL_RUN
#endif  /* CFG_CMD_RUN */

/* added by chencb 060824 */
#if ((CONFIG_COMMANDS & (CFG_CMD_ENV|CFG_CMD_FLASH)) == (CFG_CMD_ENV|CFG_CMD_FLASH))
#define	CMD_TBL_SETMAC		MK_CMD_TBL_ENTRY(				\
	"mac",	3,	2,		0,	do_setmac,			\
	"mac      - set mac address and save to flash\n",			\
        "value\n"								\
	"    - value format is xx:xx:xx:xx:xx:xx \n"				\
),
int do_setmac(cmd_tbl_t *cmdtp, bd_t *bd, int flag, int argc, char *argv[]);
#else
#define CMD_TBL_SETMAC
#endif	/* CFG_CMD_SETMAC */

/* added by chencb 060825 */
#define CMD_TBL_SETSIP          MK_CMD_TBL_ENTRY(                               \
        "sip",  3,      2,              0,      do_setsip,                      \
        "sip      - set server ip address but not save to flash\n",             \
        "value\n"                                                               \
        "    - value format is x.x.x.x (x=0~255)\n"                             \
),
int do_setsip(cmd_tbl_t *cmdtp, bd_t *bd, int flag, int argc, char *argv[]);

/* added by chencb 060825 */
#define CMD_TBL_SETLIP          MK_CMD_TBL_ENTRY(                               \
        "lip",  3,      2,              0,      do_setlip,                      \
        "lip      - set local ip address but not save to flash\n",              \
        "value\n"                                                               \
        "    - value format is x.x.x.x (x=0~255)\n"                             \
),
int do_setlip(cmd_tbl_t *cmdtp, bd_t *bd, int flag, int argc, char *argv[]);

/* added by chencb 060825 */
#define CMD_TBL_SETID          MK_CMD_TBL_ENTRY(                                \
        "id",  3,      2,              0,      do_set_id,	                \
        "id      - set product id and save to flash\n",                       \
        "value\n"                                                               \
        "    - length of value is 18 or 19\n"			 			\
),
int do_set_id(cmd_tbl_t *cmdtp, bd_t *bd, int flag, int argc, char *argv[]);

#endif	/* _CMD_NVEDIT_H */
