/*
 * (C) Copyright 2000
 * Sysgo Real-Time Solutions, GmbH <www.elinos.com>
 * Marius Groeger <mgroeger@sysgo.de>
 *
 * Configuation settings for the implementa impA7 board.
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

#ifndef __CONFIG_H
#define __CONFIG_H
//#include "config1.h"
/*
 * If we are developing, we might want to start armboot from ram
 * so we MUST NOT initialize critical regs like mem-timing ...
 */
#define CONFIG_INIT_CRITICAL            /* undef for developing */

#define CONFIG_IS_PCI
#undef CONFIG_IS_PCI

/*
 * High Level Configuration Options
 * (easy to change)
 */
/*#define CONFIG_ARM7		1	*//* This is a ARM7 CPU	*/
/*#define CONFIG_IMPA7		1	*//* on an impA7 Board      */
/*#define CONFIG_ARM_THUMB	1	*//* this is an ARM720TDMI */
/*#define CONFIG_ARM7_REVD	1 	*//* enable ARM720 REV.D Workarounds */
#define CONFIG_ARM940T		1	/* this is an ARM940TDMI */

#undef CONFIG_USE_IRQ			/* don't need them anymore */

/*
 * Size of malloc() pool
 */
#define CONFIG_MALLOC_SIZE	(CFG_ENV_SIZE + (128*1024))

/*
 * Hardware drivers
 */
// #define CONFIG_S3C2510  1
#undef  CONFIG_S3C2510
#define CONFIG_CK510		1

//#define CONFIG_DRIVER_IMMAC 1	//modified by zxj @20080522
//#define CONFIG_DRIVER_CS8900 1

#define CONFIG_DRIVER_SYNOPGMAC 0
#ifdef CONFIG_DRIVER_SYNOPGMAC
//#define IPC_OFFLOAD  //new
#define ENH_DESC_8W
#define ENH_DESC

#endif

#ifdef CONFIG_DRIVER_CS8900

//busszie 
#define CS8900_BUS16	1
#define CS8900_BUS32	0

#define CS8900_BASE		0x20000000

#endif

#ifdef CONFIG_DRIVER_IMMAC
#define CKMAC_REG_BASEADDR		 ((volatile unsigned int *)0x80000000)

#endif

#define CFG_LONGHELP	1

/************************************************************************
 * Clock Definition
 ************************************************************************/
#define SYS_CLK							108//54								//108
#define SYS_CPU_CLOCK_M			SYS_CLK						/* CPU CLOCK: in MHz	*/
#define SYS_CPU_CLOCK				SYS_CLK*1000000		/* CPU CLOCK: in Hz	*/
#define SYS_APB_CLOCK_M			(SYS_CPU_CLK / 2)
#define SYS_APB_CLOCK				SYS_CPU_CLK * 500000
#define SYS_AHB_CLOCK_M			SYS_CPU_CLK
#define SYS_AHB_CLOCK				SYS_CPU_CLK * 1000000

/*
 * select serial console configuration
 */
#define CONFIG_SERIAL1		1	/* we use Serial line 1 */

#define CONFIG_BAUDRATE		115200//19200


/* allow to overwrite serial and ethaddr */
#define CONFIG_ENV_OVERWRITE

#define CONFIG_BOOTP_MASK	(CONFIG_BOOTP_DEFAULT|CONFIG_BOOTP_BOOTFILESIZE)
#define CONFIG_COMMANDS		(CONFIG_CMD_DFL )

/* this must be included AFTER the definition of CONFIG_COMMANDS (if any) */
#include <cmd_confdefs.h>

#define CONFIG_BOOTDELAY	1
//#define CONFIG_ZERO_BOOTDELAY_CHECK

#if 0
#define CONFIG_BOOTARGS    	"devfs=mount root=ramfs console=ttyS0,115200"
#else
#undef CONFIG_BOOTARGS
#endif

#define CONFIG_ETHADDR		00:00:00:80:10:00
//#define CONFIG_ETHADDR		00:55:7B:B5:7D:F7
#define CONFIG_IPADDR		172.5.2.16
#define CONFIG_SERVERIP		172.5.2.15
#define CONFIG_NETMASK   	255.255.0.0
#define CONFIG_BOOTFILE		"uImage"
#define CONFIG_BOOTCOMMAND	"load.kernel; go 0xc0100000"

/*
 * NOTE: tftp load addr should be equal to CFG_LOAD_ADDR
 * 20060309 added by gaoyj
 */
#if 0
#define	CONFIG_UPDATE_DA	"protect off all; tftp 100000 armboot-x.bin.img; flwrite"
#define	CONFIG_UPDATE_DC	"tftp A00000 config-x.cramfs.img; flwrite"
#define	CONFIG_UPDATE_DK	"tftp A00000 kernel-x.cramfs.img; flwrite"
#define	CONFIG_UPDATE_DU	"tftp A00000 user-x.cramfs.img; flwrite"
#define	CONFIG_UPDATE_DV	"tftp A00000 vendor-x.cramfs.img; flwrite"
#define	CONFIG_UPDATE_UP	"run dc; run dk; run du; run dv"
#define	CONFIG_TEST_KERNEL	"tftp 40000 linux.bin; go 40000"
#endif

//#define CONFIG_UPDATE_UBOOT_FIRST "tftp 0xc0300000 uboot;flwrite;setenv bootcmd;setenv fupd;save"
#define CONFIG_UPDATE_UBOOT_FIRST "flrom;setenv bootcmd;setenv fupd;save"
#define CONFIG_UPDATE_UBOOT "tftp 0xc0300000 uboot;flwrite"

/*
#define	CONFIG_UPDATE_DA	"protect off all; tftp 100000 armboot-x.bin.img; flwrite 80000000"
#define	CONFIG_UPDATE_DC	"tftp A00000 custom-x.cramfs.img; flwrite"
#define	CONFIG_UPDATE_DR	"tftp A00000 romfs-x.cramfs.img; flwrite"
#define	CONFIG_UPDATE_DW	"tftp A00000 web-x.cramfs.img; flwrite"
#define	CONFIG_UPDATE_DL	"tftp A00000 logo-x.cramfs.img; flwrite"
#define	CONFIG_UPDATE_UP	"tftp A00000 update.img; flwrite"
#define	CONFIG_TEST_KERNEL	"tftp 40000 linux.bin; go 40000"*/
/*********************************************************
 *
 * added by chencb 060914
 *
 * packet update.bin include config,kernel,user,vendor
 * and so on
 *
 ********************************************************/

#define	CONFIG_CLEAN_REGION	"erase 1:9-134"
#define	CONFIG_DH_KEYBOARD	"1"
#define	CONFIG_APPAUTO		"1"
#define CONFIG_HWID         ""
#define	CONFIG_RESERVED_MEM	"1"
#define CONFIG_RESTORE_ENV  	"0"    // added by chencb 060905
#define CONFIG_PRODUCT_ID       "vs28xx"     // added by chencb 060908
/* end */
/* choish 20020828 */
#define CONFIG_ICACHE		"on"
#define CONFIG_DCACHE		"on"
#define CONFIG_WBUFFER		"on"
#define CONFIG_HWADDR0		00:09:30:28:12:22 // choish 20020829 for kernel
#define CONFIG_HWADDR1		00:09:30:28:12:24 // choish 20020829 for kernel
/* choish end */
/*
#if (CONFIG_COMMANDS & CFG_CMD_KGDB) */
/*#define CONFIG_KGDB_BAUDRATE	230400		*//* speed to run kgdb serial port */
/*#define CONFIG_KGDB_SER_INDEX	2		*//* which serial port to use */
/*#endif*/

/*
 * Miscellaneous configurable options
 */
#define	CFG_LONGHELP					/* undef to save memory		*/
#define	CFG_PROMPT		"ckcore # "
#define	CFG_CBSIZE		256			/* Console I/O Buffer Size	*/
#define	CFG_PBSIZE 		(CFG_CBSIZE+sizeof(CFG_PROMPT)+16) /* Print Buffer Size */
#define	CFG_MAXARGS		16			/* max number of command args	*/
#define CFG_BARGSIZE		CFG_CBSIZE		/* Boot Argument Buffer Size	*/

#define CFG_MEMTEST_START	0xc0000000	/* memtest works on	*/
#define CFG_MEMTEST_END		0xc07fffff	/* 4 ... 32 MB in DRAM	*/

#undef  CFG_CLKS_IN_HZ							/* everything, incl board info, in Hz */
//#define	CFG_HZ		0x7a11f					/* incrementer freq: 500 kHz */
#define	CFG_HZ			SYS_CPU_CLOCK		/* incrementer freq: 133 MHz */


						/* valid baudrates */
#define CFG_BAUDRATE_TABLE	{ 9600, 19200, 38400, 57600, 115200 }

#ifndef __ASSEMBLY__
/*-----------------------------------------------------------------------
 * Board specific extension for bd_info
 *
 * This structure is embedded in the global bd_info (bd_t) structure
 * and can be used by the board specific code (eg board/...)
 */

struct bd_info_ext
{
    /* helper variable for board environment handling
     *
     * env_crc_valid == 0    =>   uninitialised
     * env_crc_valid  > 0    =>   environment crc in flash is valid
     * env_crc_valid  < 0    =>   environment crc in flash is invalid
     */
     int	env_crc_valid;
};
#endif

/*-----------------------------------------------------------------------
 * Stack sizes
 *
 * The stack sizes are set up in start.S using the settings below
 */
#define CONFIG_STACKSIZE	(256*1024)/4	/* regular stack */
#ifdef	CONFIG_USE_IRQ
#define CONFIG_STACKSIZE_IRQ	(4*1024)	/* IRQ stack */
#define CONFIG_STACKSIZE_FIQ	(4*1024)	/* FIQ stack */
#endif

/*-----------------------------------------------------------------------
 * Physical Memory Map
 */
#define PHYS_SDRAM_8M_SIZE		0x00800000 	/* 8 MB */
#define PHYS_SDRAM_16_SIZE		0x01000000 	/* 16 MB */
#define PHYS_SDRAM_32M_SIZE		0x02000000 	/* 32 MB */
#define PHYS_SDRAM_64M_SIZE		0x04000000 	/* 64 MB */


#define CONFIG_NR_DRAM_BANKS		1										/* we have 1 banks of DRAM */
#define PHYS_SDRAM_1						0xc0100000 					/* SDRAM Bank #1 */
#define PHYS_SDRAM_1_SIZE				PHYS_SDRAM_16_SIZE 	/* 16 MB */


#define PHYS_FLASH_1			0 //2M 	/* Flash Bank #1 */
#define W25Q64M 1
#undef AM29LV320D
#undef AM29LV160D
#undef AT49BV321
#undef HY29LV320B

#if defined(AM29LV320D) || defined(AT49BV321) || defined(HY29LV320B)
#define PHYS_FLASH_SIZE         0x00400000	/* 4 MB */
#elif defined(MBM29DL640E)
#define PHYS_FLASH_SIZE		0x00800000	/* 8MB	*/
#elif defined(W25Q64M)
#define PHYS_FLASH_SIZE		0x00400000	/* 4MB	*/
#else
#define PHYS_FLASH_SIZE         0x00200000	/* 2 MB */
#endif

#define CFG_FLASH_BASE		PHYS_FLASH_1
#define CFG_FLASH_BUSSIZE8				/* CFG_FLASH_BUSSIZE8 or CFG_FLASH_BUSSIZE16*/
#define CFG_DISPLAY_FLASH_ID

/*-----------------------------------------------------------------------
 * FLASH and environment organization
 */
#define CFG_MAX_FLASH_BANKS	3	/* max number of memory banks		*/
#if defined(AM29LV320D) || defined(AT49BV321)
#define CFG_MAX_FLASH_SECT  71  /* max number of sectors on one chip    */
#elif defined(HY29LV320B)
#define CFG_MAX_FLASH_SECT  67  /* max number of sectors on one chip    */
#elif defined(AM29LV160D)
#define CFG_MAX_FLASH_SECT  35  /* max number of sectors on one chip    */
#elif defined(SST39VF160)
#define CFG_MAX_FLASH_SECT  63  /* max number of sectors on one chip    */
#elif defined(MBM29DL640E)
#define CFG_MAX_FLASH_SECT  142	/* max number of sectors on one chip    */
#elif defined(S29GL064M)
#define CFG_MAX_FLASH_SECT  135	/* max number of sectors on one chip    */
#elif defined(W25Q64M)
#define CFG_MAX_FLASH_SECT  2048	/* max number of sectors on one chip    */
#else
#define CFG_MAX_FLASH_SECT  39  /* max number of sectors on one chip    */
#endif

/* timeout values are in ticks */
#define CFG_FLASH_ERASE_TOUT	(2*CFG_HZ) /* Timeout for Flash Erase */
#define CFG_FLASH_WRITE_TOUT	(2*CFG_HZ) /* Timeout for Flash Write */

#if defined (AM29LV160D) || defined (HY29LV320B)
#define CFG_ENV_ADDR        (PHYS_FLASH_1 + 0x8000)  /* Addr of Environment Sector   */
#define CFG_ENV_SIZE        0x2000      /* Total Size of Environment Sector */
#elif defined(SST39VF160)
#define CFG_ENV_ADDR        (PHYS_FLASH_1 + 0x800)/* Addr of Env Sector   */
#define CFG_ENV_SIZE        0x800	/* Total Size of Environment Sector */
#elif defined(W25Q64M)
#define CFG_ENV_ADDR        (PHYS_FLASH_1 + 0x20000)  /* Addr of Environment Sector   */
#define CFG_ENV_SIZE        0x2000	/* Total Size of Environment Sector */
#else
#define CFG_ENV_ADDR        (PHYS_FLASH_1 + 0x20000)  /* Addr of Environment Sector   */
#define CFG_ENV_SIZE        0x1000	/* Total Size of Environment Sector */
#endif

#define	CFG_LOAD_ADDR		        0xc0100000	/* default load address	*/

#define	CFG_UBOOT_ADDR_BEG		0x0	
#define	CFG_UBOOT_ADDR_END		0x1ffff //128K

#define	CFG_KERNEL_ADDR_BEG		0x22000	
#define	CFG_KERNEL_ADDR_END		0x1a1fff // //1.5M

#define	CFG_USER_ADDR_BEG		0x200000	
#define	CFG_USER_ADDR_END		0x3FFFFF //

/* Flash banks JFFS2 should use */
//#define CFG_JFFS2_FIRST_BANK    0
//#define CFG_JFFS2_FIRST_SECTOR	0x200 //2M
//#define CFG_JFFS2_NUM_BANKS     1

#endif	/* __CONFIG_H */
