/*
 * (C) Copyright 2000
 * Wolfgang Denk, DENX Software Engineering, wd@denx.de.
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

#ifndef	__IMAGE_H__
#define __IMAGE_H__

#include <types.h>
/*
 * Operating System Codes
 */
#define	IH_OS_INVALID		0	/* Invalid OS	*/
#define	IH_OS_OPENBSD		1	/* OpenBSD	*/
#define	IH_OS_NETBSD		2	/* NetBSD	*/
#define	IH_OS_FREEBSD		3	/* FreeBSD	*/
#define	IH_OS_4_4BSD		4	/* 4.4BSD	*/
#define	IH_OS_LINUX		5	/* Linux	*/
#define	IH_OS_SVR4		6	/* SVR4		*/
#define	IH_OS_ESIX		7	/* Esix		*/
#define	IH_OS_SOLARIS		8	/* Solaris	*/
#define	IH_OS_IRIX		9	/* Irix		*/
#define	IH_OS_SCO		10	/* SCO		*/
#define	IH_OS_DELL		11	/* Dell		*/
#define	IH_OS_NCR		12	/* NCR		*/
#define	IH_OS_LYNXOS		13	/* LynxOS	*/
#define	IH_OS_VXWORKS		14	/* VxWorks	*/
#define	IH_OS_PSOS		15	/* pSOS		*/
#define	IH_OS_QNX		16	/* QNX		*/
#define	IH_OS_PPCBOOT		17	/* Firmware	*/

/*
 * CPU Architecture Codes (supported by Linux)
 */
#define	IH_CPU_INVALID		0	/* Invalid CPU	*/
#define	IH_CPU_ALPHA		1	/* Alpha	*/
#define	IH_CPU_ARM		2	/* ARM		*/
#define	IH_CPU_I386		3	/* Intel x86	*/
#define	IH_CPU_IA64		4	/* IA64		*/
#define	IH_CPU_MIPS		5	/* MIPS		*/
#define	IH_CPU_MIPS64		6	/* MIPS	 64 Bit	*/
#define	IH_CPU_PPC		7	/* PowerPC	*/
#define	IH_CPU_S390		8	/* IBM S390	*/
#define	IH_CPU_SH		9	/* SuperH	*/
#define	IH_CPU_SPARC		10	/* Sparc	*/
#define	IH_CPU_SPARC64		11	/* Sparc 64 Bit	*/

/*
 * Image Types
 *
 * "Standalone Programs" are directly runnable in the environment
 *	provided by ARMboot; it is expected that (if they behave
 *	well) you can continue to work in ARMboot after return from
 *	the Standalone Program.
 * "OS Kernel Images" are usually images of some Embedded OS which
 *	will take over control completely. Usually these programs
 *	will install their own set of exception handlers, device
 *	drivers, set up the MMU, etc. - this means, that you cannot
 *	expect to re-enter ARMboot except by resetting the CPU.
 * "RAMDisk Images" are more or less just data blocks, and their
 *	parameters (address, size) are passed to an OS kernel that is
 *	being started.
 * "Multi-File Images" contain several images, typically an OS
 *	(Linux) kernel image and one or more data images like
 *	RAMDisks. This construct is useful for instance when you want
 *	to boot over the network using BOOTP etc., where the boot
 *	server provides just a single image file, but you want to get
 *	for instance an OS kernel and a RAMDisk image.
 *
 *	"Multi-File Images" start with a list of image sizes, each
 *	image size (in bytes) specified by an "uint32_t" in network
 *	byte order. This list is terminated by an "(uint32_t)0".
 *	Immediately after the terminating 0 follow the images, one by
 *	one, all aligned on "uint32_t" boundaries (size rounded up to
 *	a multiple of 4 bytes).
 */

#define	IH_TYPE_INVALID		0	/* Invalid Image		*/
#define IH_TYPE_STANDALONE	1	/* Standalone Program		*/
#define IH_TYPE_KERNEL		2	/* OS Kernel Image		*/
#define IH_TYPE_RAMDISK		3	/* RAMDisk Image		*/
#define IH_TYPE_MULTI		4	/* Multi-File Image		*/
#define IH_TYPE_FIRMWARE	5	/* Binary Image to be programmed in the flash	*/
#define IH_TYPE_SCRIPT		6	/* Script file to be executed from memory	*/
#define IH_TYPE_FILESYSTEM	7	/* Filesystem Image (any type)	*/

/*
 * Compression Types
 */
#define IH_COMP_NONE		0	/*  No   Compression Used	*/
#define IH_COMP_GZIP		1	/* gzip  Compression Used	*/
#define IH_COMP_BZIP2		2	/* bzip2 Compression Used	*/

#define	IH_MAGIC	0x27051956	/* Image Magic Number		*/
#define	IH_NMLEN		32	/* Image Name Length		*/

/*
 * all data in network byte order (aka natural aka bigendian)
 */

typedef struct image_header {
	uint32_t	ih_magic;	/* Image Header Magic Number	*/
	uint32_t	ih_hcrc;	/* Image Header CRC Checksum	*/
	uint32_t	ih_time;	/* Image Creation Timestamp	*/
	uint32_t	ih_size;	/* Image Data Size		*/
	uint32_t	ih_load;	/* Data  Load  Address		*/
	uint32_t	ih_ep;		/* Entry Point Address		*/
	uint32_t	ih_dcrc;	/* Image Data CRC Checksum	*/
	uint8_t		ih_os;		/* Operating System		*/
	uint8_t		ih_arch;	/* CPU architecture		*/
	uint8_t		ih_type;	/* Image Type			*/
	uint8_t		ih_comp;	/* Compression Type		*/
	uint8_t		ih_name[IH_NMLEN];	/* Image Name		*/
} image_header_t;

/***********************************************************************************
 *
 * data head for update packet, the format of packet as follow
 * 
 * |id |crc | head_len | total_len | pkt_type | vendor | reserved | raw data | ....
 * 
 * all data small endian
 * 
 ***********************************************************************************/
#define PACK_ID "DH-DVR-LBX"
typedef struct
{
    uint8_t id[16];                /* product id, should be "DH-DVR-LBX" */
    uint32_t crc;           /* crc code */
    uint32_t head_len;      /* header length */
    uint32_t total_len;     /* packet length */
    uint32_t pkt_type;      /* packet type */
    uint8_t vendor[16];            /* vendor name */
    uint8_t reserved[16];          /* reserved struct */
} header_t;


#define SWAP32(x)       ( \
	                (((x) >> 24) & 0x000000ff) | \
        		(((x) >>  8) & 0x0000ff00) | \
		        (((x) <<  8) & 0x00ff0000) | \
		        (((x) << 24) & 0xff000000) ) \
		        printf("888888");

#define IMAGE_FORMAT_INVALID 0x00
#define IMAGE_FORMAT_LEGACY	 0x01	/* legacy image_header based format */
#define IMAGE_FORMAT_FIT	 0x02	/* new, libfdt based format */


ulong image_multi_count (const image_header_t *hdr);
void image_multi_getimg (const image_header_t *hdr, ulong idx,
			ulong *data, ulong *len);

inline int image_check_magic (const image_header_t *hdr);

int genimg_get_format (void *img_addr);


#endif	/* __IMAGE_H__ */
