
#ifndef _REG_HDCVI_H_ 
#define _REG_HDCVI_H_ 


/* DAC*/
#define REG_DAC_BASE                (0x60000000)

/* register map */
#define REG_DAC_CTRL                (REG_DAC_BASE + 0x0080)

/* register pointer map  */
#define PREG_DAC_CTRL               (*(volatile unsigned int *)(REG_DAC_CTRL))


/* bit */
#define RB_DAC_EN               0
#define RB_DAC_BYPIDAC          1
#define RB_DAC_EN34             2
#define RB_DAC_ENCTR0           3
#define RB_DAC_ENCTR1           4
#define RB_DAC_CLK_SEL          8


#define REG_BASE              (0x60020000)

/* register map */
#define REG_I2S               (REG_BASE + 0x0000)

#define REG_CAM2DVR_DAT       (REG_BASE + 0x4000)
#define REG_CAM2DVR_CAP       (REG_BASE + 0x4004)

#define REG_DVR2CAM_UCR       (REG_BASE + 0x4008)
#define REG_DVR2CAM_UBDR      (REG_BASE + 0x400C)
#define REG_DVR2CAM_ULEV      (REG_BASE + 0x4010)
#define REG_DVR2CAM_UTO       (REG_BASE + 0x4014)
#define REG_DVR2CAM_LINE_D    (REG_BASE + 0x4018)
#define REG_DVR2CAM_LINE_U    (REG_BASE + 0x401C)
#define REG_DVR2CAM_DOT_D     (REG_BASE + 0x4020)
#define REG_DVR2CAM_DOT_U     (REG_BASE + 0x4024)
#define REG_DVR2CAM_CAP       (REG_BASE + 0x4028)
#define REG_DVR2CAM_DAT       (REG_BASE + 0x402C)

#define REG_DVR2CAM_RD_DOT_D  (REG_BASE + 0x4030)
#define REG_DVR2CAM_RD_DOT_U  (REG_BASE + 0x4034)

#define REG_GAIN_CTRL         (REG_BASE + 0x8044)
#define REG_RS485_POS_CTRL    (REG_BASE + 0x8054)
#define REG_AUDIO_CTRL        (REG_BASE + 0x8058)

#define REG_COLORBAR_EN       (REG_BASE + 0x805C)

#define REG_CE_MODE           (REG_BASE + 0x8080)
#define REG_CE_REG_UPDATE     (REG_BASE + 0x8084)
#define REG_BC_SET0           (REG_BASE + 0x8048)
#define REG_BC_SET1           (REG_BASE + 0x804C)  


/* register pointer map */
#define PREG_I2S              (*(volatile unsigned int *)(REG_I2S))

#define PREG_CAM2DVR_DAT      (*(volatile unsigned int *)(REG_CAM2DVR_DAT))
#define PREG_CAM2DVR_CAP      (*(volatile unsigned int *)(REG_CAM2DVR_CAP))

#define PREG_DVR2CAM_UCR      (*(volatile unsigned int *)(REG_DVR2CAM_UCR))
#define PREG_DVR2CAM_UBDR     (*(volatile unsigned int *)(REG_DVR2CAM_UBDR))
#define PREG_DVR2CAM_ULEV     (*(volatile unsigned int *)(REG_DVR2CAM_ULEV))
#define PREG_DVR2CAM_UTO      (*(volatile unsigned int *)(REG_DVR2CAM_UTO))
#define PREG_DVR2CAM_LINE_D   (*(volatile unsigned int *)(REG_DVR2CAM_LINE_D))
#define PREG_DVR2CAM_LINE_U   (*(volatile unsigned int *)(REG_DVR2CAM_LINE_U))
#define PREG_DVR2CAM_DOT_D    (*(volatile unsigned int *)(REG_DVR2CAM_DOT_D))
#define PREG_DVR2CAM_DOT_U    (*(volatile unsigned int *)(REG_DVR2CAM_DOT_U))
#define PREG_DVR2CAM_CAP      (*(volatile unsigned int *)(REG_DVR2CAM_CAP))
#define PREG_DVR2CAM_DAT      (*(volatile unsigned int *)(REG_DVR2CAM_DAT))

#define PREG_DVR2CAM_RD_DOT_D (*(volatile unsigned int *)(REG_DVR2CAM_RD_DOT_D))
#define PREG_DVR2CAM_RD_DOT_U (*(volatile unsigned int *)(REG_DVR2CAM_RD_DOT_U))

#define PREG_GAIN_CTRL        (*(volatile unsigned int *)(REG_GAIN_CTRL))
#define PREG_RS485_POS_CTRL   (*(volatile unsigned int *)(REG_RS485_POS_CTRL))
#define PREG_AUDIO_CTRL       (*(volatile unsigned int *)(REG_AUDIO_CTRL))

#define PREG_COLORBAR_EN      (*(volatile unsigned int *)(REG_COLORBAR_EN))

#define PREG_CE_MODE          (*(volatile unsigned int *)(REG_CE_MODE))
#define PREG_CE_REG_UPDATE    (*(volatile unsigned int *)(REG_CE_REG_UPDATE))
#define PREG_BC_SET0          (*(volatile unsigned int *)(REG_BC_SET0))
#define PREG_BC_SET1          (*(volatile unsigned int *)(REG_BC_SET1))




/* bit map */

/* REG_I2S */
#define RB_I2S_AUDMOD_CHA1    0
#define RB_I2S_AUDMOD_EN      7

#define RB_I2S_MASK          \
                         (~(1 << RB_I2S_AUDMOD_CHA1) & ~(1 << RB_I2S_AUDMOD_EN))

/* REG_DVR2CAM_UCR */
#define RB_UCR_ODD_EVEN_EN    0
#define RB_UCR_D2C_UTO_EN     5
#define RB_UCR_D2C_INT_EN     6
#define RB_UCR_D2C_EN         7


/* REG_AUDIO_CTRL */
#define RB_AUDIO_EN           16
#define RB_AUDIO_TEST_EN      10

/* REG_COLORBAR_EN  */
#define RB_COLORBAR_EN        0


/* threshold*/
#define THR_RS485_RXFIFO_FULL (64)

#define	IOCTL_SET_IRQ_STATIS_ADDR_CMD    MKIOCTL(0x5, 'i', 0x0)

#define ISP_BANK_MAX 6
#define ISP_BANK_960H_MAX 2
#define ISP_BANK_1080P_MAX 4

#define ISP_BANK_DEFAULT 0
#define ISP_BANK_EXT 1

#define ISP_BANK_1080P_OFFSET (0x3F5000)
#define ISP_BANK_960H_OFFSET (0x110000)

/* add register define */
#define ISP_NR3D_BANK0_ADDR (0x6001400C)
#define ISP_NR3D_BANK1_ADDR (0x60014010)
#define ISP_NR3D_BANK2_ADDR (0x60014014)
#define ISP_NR3D_BANK3_ADDR (0x60014018)

#define ISP_H960_BANK0_ADDR (0x60015010)
#define ISP_H960_BANK1_ADDR (0x60015014)

#define ISP_BANK_BASE_ADDR (0xC0E00000)


/* ISP BANK addr */
static unsigned int g_uiBankAddr[ISP_BANK_MAX] =
{ 
    ISP_H960_BANK0_ADDR, ISP_H960_BANK1_ADDR,
        
    ISP_NR3D_BANK0_ADDR, ISP_NR3D_BANK1_ADDR,

    ISP_NR3D_BANK2_ADDR, ISP_NR3D_BANK3_ADDR 
};
                                                     

/* ISP BANK default offset*/
static unsigned int g_uiBankDefOff[ISP_BANK_MAX] = 
{
    ISP_BANK_960H_OFFSET, ISP_BANK_960H_OFFSET,

    ISP_BANK_1080P_OFFSET, ISP_BANK_1080P_OFFSET, 

    ISP_BANK_1080P_OFFSET, ISP_BANK_1080P_OFFSET
};


#define CSC_TABEL_LENGTH (64)

static unsigned int g_u32CscCdc[CSC_TABEL_LENGTH] = 
{
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xd8, 0xc7, 0xba, 0xaf, 0xa5,
    0x9d, 0x95, 0x8e, 0x87, 0x80, 0x7a, 0x74, 0x6e,
    0x69, 0x63, 0x5e, 0x59, 0x54, 0x50, 0x4b, 0x47,
    0x42, 0x3e, 0x3a, 0x36, 0x32, 0x2e, 0x2a, 0x26,
    0x22, 0x1f, 0x1b, 0x17, 0x14, 0x11, 0x0d, 0x0a,
    0x06, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

#endif /* _REG_H_ */



