/******************************************************************************
 * File:        UART.H
 *
 * Description: IS UART definitions.
 *
 * Comments:
 *
 * $File: $
 * $Revision:$
 * $Date:$
 * $Log:$
 ****************************************************************************/

#ifndef _VS28XXUART_H_
#define _VS28XXUART_H_

#define UART_ENABLE		1
#define	UART_BASE		0x42000000	/* 0b0100_0010	(APB)	*/

/************************************************************************
 * UART Baud Rate Register Settings:
 * BDRR = f_clk / (16 * BAUD) - 1.  (%1 error allowed)
 * f_clk = CLOCK_APB_BUS = SYS_CPU_CLOCK / 2;
 ************************************************************************/
//#define SYS_CPU_CLOCK 54000000

#define UART_BAUD(x)		((SYS_CPU_CLOCK/32/(x))-1)

/************************************************************************
 * Device Register Offsets [In Byte Address]
 ************************************************************************/
#define	UART_REG_UBR		0x03	/* Baud rate Register		*/
#define	UART_REG_UCR		0x07	/* Control Register		*/
#define	UART_REG_UDR		0x0B	/* Data Register		*/
#define	UART_REG_USR		0x0F	/* Status Register		*/

/************************************************************************
 * Register Control Bit MASK
 ************************************************************************/
#define	UART_CR_RXCIE		0x80	/* Bit 7			*/
#define UART_CR_TXCIE		0x40
#define	UART_CR_UDRIE		0x20
#define	UART_CR_RXEN		0x10
#define	UART_CR_TXEN		0x08
#define	UART_CR_CHR9		0x04
#define	UART_CR_RXB8		0x02
#define	UART_CR_TXB8		0x01	/* Bit 0			*/

#define	UART_SR_RXC		0x80	/* Bit 7			*/
#define UART_SR_TXC		0x40
#define UART_SR_UDRE		0x20
#define UART_SR_FE		0x10
#define UART_SR_OR		0x08	/* Bit 3			*/

/************************************************************************
 * UART Device Data Structure
 ************************************************************************/
#define UART_FIFO_SIZE		512
typedef struct
{
 volatile u8 *	base;				/* UART Device address		*/
} tUARTDevice;

/************************************************************************
 * UART Device Status Macros
 ************************************************************************/
#define	UART_STATUS_CLOSED	0x00	/* For Open/Close Operation	*/
#define	UART_STATUS_FREE	0x01
#define	UART_STATUS_BUSY	0x02
#define	UART_STATUS_FAILURE	0x03

/************************************************************************
 * Sub module compilation flag: 1 = Enable protocol sub module
 ************************************************************************/
#define	UART_PROTOCOL_ENABLE	0

/************************************************************************
 * Quick and Dirty way to use Uart device: only use it to transfer (it's faster)
 ************************************************************************/
#define UART_QUICK_AND_DIRTY	1

/* Miscellaneous communications definitions */
#define XON			0x11
#define XOFF			0x13

/* Flag definitions */
#define UART_BLOCKING		0x01
#define UART_STOP_AT_NUL	0x02
#define UART_STOP_AT_ENTER	0x03

/* Parity definitions */
#define UART_PARITY_NONE	0x00
#define UART_PARITY_ODD		0x01
#define UART_PARITY_EVEN	0x02

/* Driver API Prototypes */
u8	UartInit(u32 BaudRate);
int	UartWriteChar(char c);
u8	UartReadChar(char * c, u32 timeout);
void	UartFlush(void);

#endif /* #ifndef _VS28XXUART_H_ **/
