#include <stdio.h>
#include <stdlib.h>
#include "config.h"

const unsigned long board_table[] = CFG_BOARD_TABLE;
const unsigned long cpu_table[] = CFG_CPU_TABLE;
const unsigned long driver_table[] = CFG_DRIVER_TABLE;
const unsigned long flash_table[] = CFG_FLASH_TABLE;
const unsigned long sdram_size_table[] = CFG_SDRAM_SIZE_TABLE;
const unsigned long sdram_datawidth_table[] = CFG_SDRAM_DATAWIDTH_TABLE;
const unsigned long sdram_bank_table[] = CFG_SDRAM_BANK_TABLE;

int configure = 0;

int
Board_Selection (void)
{
  int board = 0;

  while (!board)
    {
      printf
	("\n[1] Select BOARD                   1)s5n8947     2)s3c2500     3)s3c2510    4)vs28xx ? \n");
      printf ("> ");
      scanf ("%d", &board);
      if ((board > 4) || (board < 1))
	{
	  printf ("             Wrong Number !!!\n");
	  board = 0;
	}
      else
	{
	  configure |=
	    (board_table[board - 1] | cpu_table[board - 1] |
	     driver_table[board - 1]);
	  return configure;
	}			// else
    }				// while(!board)

}				// Board_Selection


int
Flash_Selection (void)
{
  int flash_size = 0, flash = 0;

  while (!flash_size)
    {
      printf
	("\n[2] Select Flash Memory size       1)2MB    2)4MB    3)8M ? \n");
      printf ("> ");
      scanf ("%d", &flash_size);
      if ((flash_size > 3) || (flash_size < 1))
	{
	  printf ("             Wrong Number !!!\n");
	  flash_size = 0;
	}
    }				// while(!flash_size)

  while (!flash)
    {
      if (flash_size == 3)
	{
	  printf
	    ("\n[3] Select Flash Vendor            1)FUJITSU   2)SPANSION\n");
	  printf ("> ");
	  scanf ("%d", &flash);
	  if ((flash > 2) || (flash < 1))
	    {
	      printf ("             Wrong Number !!!\n");
	      flash = 0;
	    }
	  else
	    {
	      configure |= flash_table[flash + 7];
	      return configure;
	    }
	}			// if(flash_size == 2)
      else if (flash_size == 2)
	{
	  printf
	    ("\n[3] Select Flash Vendor            1)AMD         2)ATMEL       3)HYNIX  ? \n");
	  printf ("> ");
	  scanf ("%d", &flash);
	  if ((flash > 3) || (flash < 1))
	    {
	      printf ("             Wrong Number !!!\n");
	      flash = 0;
	    }
	  else
	    {
	      configure |= flash_table[flash + 4];
	      return configure;
	    }
	}			// if(flash_size == 2)
      else
	{
	  printf
	    ("\n[3] Select Flash Vendor            1)SAMSUNG    2)AMD    3)FUJITSU    4)STMicro    5)SST  ? \n");
	  printf ("> ");
	  scanf ("%d", &flash);
	  if ((flash > 5) || (flash < 1))
	    {
	      printf ("             Wrong Number !!!\n");
	      flash = 0;
	    }
	  else
	    {
	      configure |= flash_table[flash - 1];
	      return configure;
	    }
	}			// else

    }				// while(!flash)
}				// Flash_Selection

int
Sdram_Selection (void)
{
  int sdram_size = 0, sdram_width = 0, sdram_bank = 0;

  while (!sdram_size)
    {
      printf
	("\n[4] Select SDRAM size              1)8MB         2)16MB        3)32MB  ? \n");
      printf ("> ");
      scanf ("%d", &sdram_size);
      if ((sdram_size > 3) || (sdram_size < 1))
	{
	  printf ("             Wrong Number !!!\n");
	  sdram_size = 0;
	}
      else
	{
	  configure |= sdram_size_table[sdram_size - 1];
	}
    }				// while(!sdram_size)

  while (!sdram_width)
    {
      printf
	("\n[5] Select SDRAM Data Width        1)16Bit       2)32Bit  ? \n");
      printf ("> ");
      scanf ("%d", &sdram_width);
      if ((sdram_width > 2) || (sdram_width < 1))
	{
	  printf ("             Wrong Number !!!\n");
	  sdram_width = 0;
	}
      else
	{
	  configure |= sdram_datawidth_table[sdram_width - 1];
	}
    }				// while(!sdram_width)

  while (!sdram_bank)
    {
      printf
	("\n[6] Select SDRAM Bank(MCU)         1)1Bank       2)2Bank  ? \n");
      printf ("> ");
      scanf ("%d", &sdram_bank);
      if ((sdram_bank > 2) || (sdram_bank < 1))
	{
	  printf ("             Wrong Number !!!\n");
	  sdram_bank = 0;
	}
      else
	{
	  configure |= sdram_bank_table[sdram_bank - 1];
	}
    }				// while(!sdram_bank)

  return configure;

}				// Sdram_Selection

int
Configuration_Setting (int config)
{

  system ("echo 'ARCH   = arm' > include/config.mk");

  // board, CPU and MAC driver configuration
  if (config & S5N8947)
  {
    system ("echo 'BOARD  = s5n8947'  >> include/config.mk;	\
		echo 'CPU    = arm7tdmi' >> include/config.mk;	\
		echo 'DRIVER = mac8947'  >> include/config.mk;	\
		echo '#include <configs/config_s5n8947.h>' > include/config.h");
  }
  else if (config & S3C2500)
  {
    system ("echo 'BOARD  = s3c2500'  >> include/config.mk;	\
                echo 'CPU    = arm940t'  >> include/config.mk;	\
                echo 'DRIVER = mac2500'  >> include/config.mk;	\
                echo '#include <configs/config_s3c2500.h>' > include/config.h");
  }
  else if (config & S3C2510)
  {
    system ("echo 'BOARD  = s3c2510'  >> include/config.mk;	\
                echo 'CPU    = arm940t'  >> include/config.mk;	\
                echo 'DRIVER = mac2510'  >> include/config.mk;	\
                echo '#include <configs/config_s3c2510.h>' > include/config.h");
  }
  else if (config & VS28xx)
  {
    system ("echo 'ARCH   = ckcore' > include/config.mk");
    system ("echo 'BOARD  = VS28xx'  >> include/config.mk;	\
                echo 'CPU    = CK510'  >> include/config.mk;	\
                echo 'DRIVER = macpld'  >> include/config.mk;	\
                echo '#include <configs/config_vs28xx.h>' > include/config.h");
  }
  else
    {
      printf ("Illegal Board Configuration !!!");
      return 1;
    }

  // flash memory configuration
  if ((config & 0xf000) == K8B1616UBA)
    system ("echo '#define K8B1616UBA'  >>include/config.h;	\
                 echo '#define K8B1616UBA'  > include/config1.h");
  else if ((config & 0xf000) == AM29LV160D)
    system ("echo '#define AM29LV160D'  >>include/config.h;	\
                echo '#define AM29LV160D'  > include/config1.h");
  else if ((config & 0xf000 ) == MBM29LV160BE)
    system ("echo '#define AM29LV160D'  >>include/config.h;	\
                echo '#define AM29LV160D'  > include/config1.h;	\
                echo '#define MBM29LV160BE'>>include/config.h;	\
                echo '#define MBM29LV160BE'> include/config1.h");
  else if ((config & 0xf000 ) == M29W160DB)
    system ("echo '#define AM29LV160D'  >>include/config.h;	\
                echo '#define AM29LV160D'  > include/config1.h;	\
                echo '#define M29W160DB'   >>include/config.h;	\
                echo '#define M29W160DB'   > include/config1.h");
  else if ((config & 0xf000) ==  SST39VF160)
    system ("echo '#define SST39VF160'  >>include/config.h;	\
                echo '#define SST39VF160'  > include/config1.h");
  else if ((config & 0xf000) == AM29LV320D)
    system ("echo '#define AM29LV320D'  >>include/config.h;	\
                echo '#define AM29LV320D'  > include/config1.h");
  else if ((config & 0xf000) == AT49BV321)
    system ("echo '#define AT49BV321'   >>include/config.h;	\
                echo '#define AT49BV321'   > include/config1.h");
  else if ((config & 0xf000) == HY29LV320B)
    system ("echo '#define HY29LV320B'   >>include/config.h;	\
                echo '#define HY29LV320B'   > include/config1.h");
  else if ((config & 0xf000) == MBM29DL640E)
    system ("echo '#define MBM29DL640E'   >>include/config.h;	\
                echo '#define MBM29DL640E'   > include/config1.h");
  else if ((config & 0x6000) == S29GL064M)
    system ("echo '#define S29GL064M'   >>include/config.h;	\
                echo '#define S29GL064M'   > include/config1.h");
  else
    {
      printf ("Illegal Flash Memory Configuration !!!");
      return 1;
    }

  // SDRAM configuration
  // SDRAM size
  if (config & SD8MB)
    system ("echo '#define SD8MB'  >>include/config.h;		\
                echo '#define SD8MB'  >>include/config1.h");
  else if (config & SD16MB)
    system ("echo '#define SD16MB' >>include/config.h;		\
                echo '#define SD16MB' >>include/config1.h");
  else if (config & SD32MB)
    system ("echo '#define SD32MB' >>include/config.h;		\
                echo '#define SD32MB' >>include/config1.h");
  else
    {
      printf ("Illegal SDRAM size Configuration !!!");
      return 1;
    }

  // SDRAM Data Bus Width
  if (config & SD16BIT)
    system ("echo '#define SD16BIT' >>include/config.h;		\
                echo '#define SD16BIT' >>include/config1.h");
  else if (config & SD32BIT)
    system ("echo '#define SD32BIT' >>include/config.h;		\
                echo '#define SD32BIT' >>include/config1.h");
  else
    {
      printf ("Illegal SDRAM Data Bus Width Configuration !!!");
      return 1;
    }

  // SDRAM Bank
  if (config & SD1BANK)
    system ("echo '#define SD1BANK' >>include/config.h;		\
                echo '#define SD1BANK' >>include/config1.h");
  else if (config & SD2BANK)
    system ("echo '#define SD2BANK' >>include/config.h;		\
                 echo '#define SD2BANK' >>include/config1.h");
  else
    {
      printf ("Illegal SDRAM Bank Configuration !!!");
      return 1;
    }

  return 0;

}

int
main ()
{
  system ("clear");
  printf
    ("********************************************************************************\n");
  printf
    ("*                                                                              *\n");
  printf
    ("*                S A M S U N G    N E T C O M M    P R O D U C T               *\n");
  printf
    ("*                                                                              *\n");
  printf
    ("*                     B O A R D   C O N F I G U R A T I O N                    *\n");
  printf
    ("*                                                                              *\n");
  printf
    ("*                         S5N8947, S3C2500, S3C2510                            *\n");
  printf
    ("*                                                                              *\n");
  printf
    ("*                                                                              *\n");
  printf
    ("*                                    SAMSUNG Electronics System Solution       *\n");
  printf
    ("********************************************************************************\n");
  printf ("\n\n");


  configure |= Board_Selection () | Flash_Selection () | Sdram_Selection ();

  if (Configuration_Setting (configure))
    {
      printf ("\nBoard Configuraiton Fail !!!\n");
      printf ("\nTry Again !!!\n");
    }
  else
    printf ("\n\nBoard Configuration Completed !!!\n\n");
  return 0;

}
