#
#  "$Id: Makefile 378 2008-04-29 09:01:34Z wang_haifeng $"
#
#  Copyright (c)1992-2007, ZheJiang Dahua Technology Stock CO.LTD.
#  All Rights Reserved.
#
#	Description:	
#	Revisions:		Year-Month-Day  SVN-Author  Modification
#

LIB_NAME = json
LIB_DIR = ./lib/$(platform)

SRC_ROOT = ./src
SRC_DIR = lib_json

INTER_ROOT = ./tmp/$(platform)

LIB_TARGET = $(LIB_DIR)/lib$(LIB_NAME).a

TARGET = $(LIB_TARGET)

SRC_PATH := $(patsubst %, $(SRC_ROOT)/%, ${SRC_DIR})

SRC_FILE_C := $(foreach dir, ${SRC_PATH}, $(wildcard $(dir)/*.c))
SRC_FILE_CPP := $(foreach dir, ${SRC_PATH}, $(wildcard $(dir)/*.cpp))

INTER_OBJ = $(patsubst $(SRC_ROOT)/%.c, $(INTER_ROOT)/%.o, ${SRC_FILE_C})
INTER_OBJ += $(patsubst $(SRC_ROOT)/%.cpp, $(INTER_ROOT)/%.o, ${SRC_FILE_CPP})

$(foreach dir, ${SRC_DIR}, $(shell mkdir -p $(INTER_ROOT)/$(dir)))

all : $(TARGET)

$(LIB_TARGET) : $(INTER_OBJ)
	$(shell mkdir $(LIB_DIR))
	$(AR) $(AFLAGS) $@ $^

$(INTER_ROOT)/%.o : $(SRC_ROOT)/%.cpp
	$(CPP) -c $(CFLAGS) $< -o $@

$(INTER_ROOT)/%.o : $(SRC_ROOT)/%.c
	$(CC) -c $(CFLAGS) $< -o $@

clean:
	rm -rf ${INTER_OBJ}
	rm -rf $(TARGET)
